/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.h2.Driver;
import org.h2.api.DatabaseEventListener;
import org.h2.constant.SysProperties;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.WebSession;
import org.h2.server.web.WebThread;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.RandomUtils;
import org.h2.util.Resources;
import org.h2.util.SortedProperties;
import org.h2.util.Tool;

public class WebServer
implements Service {
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String[][] LANGUAGES = new String[][]{{"de", "Deutsch"}, {"en", "English"}, {"es", "Espa\u00f1ol"}, {"fr", "Fran\u00e7ais"}, {"hu", "Magyar"}, {"in", "Indonesia"}, {"it", "Italiano"}, {"ja", "\u65e5\u672c\u8a9e"}, {"nl", "Nederlands"}, {"pl", "Polski"}, {"pt_BR", "Portugu\u00eas (Brasil)"}, {"pt_PT", "Portugu\u00eas (Europeu)"}, {"ru", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439"}, {"tr", "T\u00fcrk\u00e7e"}, {"uk", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"}, {"zh_CN", "\u4e2d\u6587 (\u7b80\u4f53)"}, {"zh_TW", "\u4e2d\u6587 (\u7e41\u9ad4)"}};
    private static final String[] GENERIC = new String[]{"Generic JNDI Data Source|javax.naming.InitialContext|java:comp/env/jdbc/Test|sa", "Generic Firebird Server|org.firebirdsql.jdbc.FBDriver|jdbc:firebirdsql:localhost:c:/temp/firebird/test|sysdba", "Generic OneDollarDB|in.co.daffodil.db.jdbc.DaffodilDBDriver|jdbc:daffodilDB_embedded:school;path=C:/temp;create=true|sa", "Generic SQLite|org.sqlite.JDBC|jdbc:sqlite:test|sa", "Generic DB2|COM.ibm.db2.jdbc.net.DB2Driver|jdbc:db2://localhost/test|", "Generic Oracle|oracle.jdbc.driver.OracleDriver|jdbc:oracle:thin:@localhost:1521:test|scott", "Generic MS SQL Server 2000|com.microsoft.jdbc.sqlserver.SQLServerDriver|jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=sqlexpress|sa", "Generic MS SQL Server 2005|com.microsoft.sqlserver.jdbc.SQLServerDriver|jdbc:sqlserver://localhost;DatabaseName=test|sa", "Generic PostgreSQL|org.postgresql.Driver|jdbc:postgresql:test|", "Generic MySQL|com.mysql.jdbc.Driver|jdbc:mysql://localhost:3306/test|", "Generic HSQLDB|org.hsqldb.jdbcDriver|jdbc:hsqldb:test;hsqldb.default_table_type=cached|sa", "Generic Derby (Server)|org.apache.derby.jdbc.ClientDriver|jdbc:derby://localhost:1527/test;create=true|sa", "Generic Derby (Embedded)|org.apache.derby.jdbc.EmbeddedDriver|jdbc:derby:test;create=true|sa", "Generic H2 (Server)|org.h2.Driver|jdbc:h2:tcp://localhost/~/test|sa", "Generic H2 (Embedded)|org.h2.Driver|jdbc:h2:~/test|sa"};
    private static int ticker;
    private static final long SESSION_TIMEOUT = 1800000L;
    private String driverList;
    private int port;
    private boolean allowOthers;
    private Set running = Collections.synchronizedSet(new HashSet());
    private boolean ssl;
    private HashMap connInfoMap = new HashMap();
    private long lastTimeoutCheck;
    private HashMap sessions = new HashMap();
    private HashSet languages = new HashSet();
    private String startDateTime;
    private ServerSocket serverSocket;
    private String url;
    private ShutdownHandler shutdownHandler;
    private Thread listenerThread;
    private boolean ifExists;
    private boolean allowScript;
    private boolean trace;
    private TranslateThread translateThread;

    byte[] getFile(String string) throws IOException {
        this.trace("getFile <" + string + ">");
        byte[] byArray = Resources.get("/org/h2/server/web/res/" + string);
        if (byArray == null) {
            this.trace(" null");
        } else {
            this.trace(" size=" + byArray.length);
        }
        return byArray;
    }

    synchronized void remove(WebThread webThread) {
        this.running.remove(webThread);
    }

    private String generateSessionId() {
        byte[] byArray = RandomUtils.getSecureBytes(16);
        return ByteUtils.convertBytesToString(byArray);
    }

    WebSession getSession(String string) {
        Object object;
        long l = System.currentTimeMillis();
        if (this.lastTimeoutCheck + 1800000L < l) {
            object = this.sessions.keySet().toArray();
            for (int i = 0; i < ((Object[])object).length; ++i) {
                String string2 = (String)object[i];
                WebSession webSession = (WebSession)this.sessions.get(string2);
                Long l2 = (Long)webSession.get("lastAccess");
                if (l2 == null || l2 + 1800000L >= l) continue;
                this.trace("timeout for " + string2);
                this.sessions.remove(string2);
            }
            this.lastTimeoutCheck = l;
        }
        if ((object = (WebSession)this.sessions.get(string)) != null) {
            object.lastAccess = System.currentTimeMillis();
        }
        return object;
    }

    WebSession createNewSession(String string) {
        String string2;
        while (this.sessions.get(string2 = this.generateSessionId()) != null) {
        }
        WebSession webSession = new WebSession(this);
        webSession.put("sessionId", string2);
        webSession.put("ip", string);
        webSession.put("language", DEFAULT_LANGUAGE);
        this.sessions.put(string2, webSession);
        this.readTranslations(webSession, DEFAULT_LANGUAGE);
        return this.getSession(string2);
    }

    String getStartDateTime() {
        return this.startDateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String[] stringArray) {
        Object object;
        Properties properties = this.loadProperties();
        this.driverList = properties.getProperty("drivers");
        this.port = SortedProperties.getIntProperty(properties, "webPort", 8082);
        this.ssl = SortedProperties.getBooleanProperty(properties, "webSSL", false);
        this.allowOthers = SortedProperties.getBooleanProperty(properties, "webAllowOthers", false);
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            object = stringArray[i];
            if ("-webPort".equals(object)) {
                this.port = MathUtils.decodeInt(stringArray[++i]);
                continue;
            }
            if ("-webSSL".equals(object)) {
                if (Tool.readArgBoolean(stringArray, i) != 0) {
                    this.ssl = Tool.readArgBoolean(stringArray, i) == 1;
                    ++i;
                    continue;
                }
                this.ssl = true;
                continue;
            }
            if ("-webAllowOthers".equals(object)) {
                if (Tool.readArgBoolean(stringArray, i) != 0) {
                    this.allowOthers = Tool.readArgBoolean(stringArray, i) == 1;
                    ++i;
                    continue;
                }
                this.allowOthers = true;
                continue;
            }
            if ("-webScript".equals(object)) {
                this.allowScript = true;
                continue;
            }
            if ("-baseDir".equals(object)) {
                String string = stringArray[++i];
                SysProperties.setBaseDir(string);
                continue;
            }
            if ("-ifExists".equals(object)) {
                if (Tool.readArgBoolean(stringArray, i) != 0) {
                    this.ifExists = Tool.readArgBoolean(stringArray, i) == 1;
                    ++i;
                    continue;
                }
                this.ifExists = true;
                continue;
            }
            if ("-trace".equals(object)) {
                this.trace = true;
                continue;
            }
            if (!"-log".equals(object) || !SysProperties.OLD_COMMAND_LINE_OPTIONS) continue;
            this.trace = Tool.readArgBoolean(stringArray, i) == 1;
            ++i;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", new Locale(DEFAULT_LANGUAGE, ""));
        object = simpleDateFormat;
        synchronized (object) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.startDateTime = simpleDateFormat.format(new Date());
        }
        this.trace(this.startDateTime);
        for (int i = 0; i < LANGUAGES.length; ++i) {
            this.languages.add(LANGUAGES[i][0]);
        }
        this.updateURL();
    }

    public String getURL() {
        return this.url;
    }

    private void updateURL() {
        this.url = (this.ssl ? "https" : "http") + "://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    public void start() throws SQLException {
        this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
        this.port = this.serverSocket.getLocalPort();
        this.updateURL();
    }

    public void listen() {
        this.listenerThread = Thread.currentThread();
        try {
            while (this.serverSocket != null) {
                Socket socket = this.serverSocket.accept();
                WebThread webThread = new WebThread(socket, this);
                this.running.add(webThread);
                webThread.start();
            }
        }
        catch (Exception exception) {
            this.trace(exception.toString());
        }
    }

    public boolean isRunning(boolean bl) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.port, this.ssl);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    public void stop() {
        Object object;
        int n;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                this.traceError(iOException);
            }
            this.serverSocket = null;
        }
        if (this.listenerThread != null) {
            try {
                this.listenerThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                TraceSystem.traceThrowable(interruptedException);
            }
        }
        ArrayList<Object> arrayList = new ArrayList(this.sessions.values());
        for (n = 0; n < arrayList.size(); ++n) {
            object = (WebSession)arrayList.get(n);
            ((WebSession)object).close();
        }
        arrayList = new ArrayList(this.running);
        for (n = 0; n < arrayList.size(); ++n) {
            object = (WebThread)arrayList.get(n);
            try {
                ((WebThread)object).stopNow();
                ((Thread)object).join(100L);
                continue;
            }
            catch (Exception exception) {
                this.traceError(exception);
            }
        }
    }

    void trace(String string) {
        if (this.trace) {
            System.out.println(string);
        }
    }

    void traceError(Throwable throwable) {
        if (this.trace) {
            throwable.printStackTrace();
        }
    }

    boolean supportsLanguage(String string) {
        return this.languages.contains(string);
    }

    void readTranslations(WebSession webSession, String string) {
        Properties properties = new Properties();
        try {
            this.trace("translation: " + string);
            byte[] byArray = this.getFile("_text_" + string + ".properties");
            this.trace("  " + new String(byArray));
            properties.load(new ByteArrayInputStream(byArray));
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String string2 = (String)entry.getValue();
                if (!string2.startsWith("#")) continue;
                entry.setValue(string2.substring(1));
            }
        }
        catch (IOException iOException) {
            TraceSystem.traceThrowable(iOException);
        }
        webSession.put("text", new HashMap<Object, Object>(properties));
    }

    String[][] getLanguageArray() {
        return LANGUAGES;
    }

    ArrayList getSessions() {
        ArrayList arrayList = new ArrayList(this.sessions.values());
        for (int i = 0; i < arrayList.size(); ++i) {
            WebSession webSession = (WebSession)arrayList.get(i);
            arrayList.set(i, webSession.getInfo());
        }
        return arrayList;
    }

    public String getType() {
        return "Web";
    }

    public String getName() {
        return "H2 Console Server";
    }

    void setAllowOthers(boolean bl) {
        this.allowOthers = bl;
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    void setSSL(boolean bl) {
        this.ssl = bl;
    }

    void setPort(int n) {
        this.port = n;
    }

    boolean getSSL() {
        return this.ssl;
    }

    public int getPort() {
        return this.port;
    }

    ConnectionInfo getSetting(String string) {
        return (ConnectionInfo)this.connInfoMap.get(string);
    }

    void updateSetting(ConnectionInfo connectionInfo) {
        this.connInfoMap.put(connectionInfo.name, connectionInfo);
        connectionInfo.lastAccess = ticker++;
    }

    void removeSetting(String string) {
        this.connInfoMap.remove(string);
    }

    private String getPropertiesFileName() {
        return FileUtils.getFileInUserHome(".h2.server.properties");
    }

    private Properties loadProperties() {
        String string = this.getPropertiesFileName();
        try {
            return SortedProperties.loadProperties(string);
        }
        catch (IOException iOException) {
            return new Properties();
        }
    }

    String[] getSettingNames() {
        ArrayList arrayList = this.getSettings();
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = ((ConnectionInfo)arrayList.get((int)i)).name;
        }
        return stringArray;
    }

    synchronized ArrayList getSettings() {
        ArrayList<ConnectionInfo> arrayList = new ArrayList<ConnectionInfo>();
        if (this.connInfoMap.size() == 0) {
            Properties properties = this.loadProperties();
            if (properties.size() == 0) {
                for (int i = 0; i < GENERIC.length; ++i) {
                    ConnectionInfo connectionInfo = new ConnectionInfo(GENERIC[i]);
                    arrayList.add(connectionInfo);
                    this.updateSetting(connectionInfo);
                }
            } else {
                String string;
                int n = 0;
                while ((string = properties.getProperty(String.valueOf(n))) != null) {
                    ConnectionInfo connectionInfo = new ConnectionInfo(string);
                    arrayList.add(connectionInfo);
                    this.updateSetting(connectionInfo);
                    ++n;
                }
            }
        } else {
            arrayList.addAll(this.connInfoMap.values());
        }
        this.sortConnectionInfo(arrayList);
        return arrayList;
    }

    private void sortConnectionInfo(ArrayList arrayList) {
        for (int i = 1; i < arrayList.size(); ++i) {
            int n;
            ConnectionInfo connectionInfo = (ConnectionInfo)arrayList.get(i);
            for (n = i - 1; n >= 0 && ((ConnectionInfo)arrayList.get((int)n)).lastAccess < connectionInfo.lastAccess; --n) {
                arrayList.set(n + 1, arrayList.get(n));
            }
            arrayList.set(n + 1, connectionInfo);
        }
    }

    synchronized void saveSettings() {
        try {
            SortedProperties sortedProperties = new SortedProperties();
            if (this.driverList != null) {
                sortedProperties.setProperty("drivers", this.driverList);
            }
            sortedProperties.setProperty("webPort", String.valueOf(this.port));
            sortedProperties.setProperty("webAllowOthers", String.valueOf(this.allowOthers));
            sortedProperties.setProperty("webSSL", String.valueOf(this.ssl));
            ArrayList arrayList = this.getSettings();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ConnectionInfo connectionInfo = (ConnectionInfo)arrayList.get(i);
                if (connectionInfo == null) continue;
                sortedProperties.setProperty(String.valueOf(n - i - 1), connectionInfo.getString());
            }
            OutputStream outputStream = FileUtils.openFileOutputStream(this.getPropertiesFileName(), false);
            sortedProperties.store(outputStream, "H2 Server Properties");
            outputStream.close();
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
        }
    }

    Connection getConnection(String string, String string2, String string3, String string4, DatabaseEventListener databaseEventListener) throws SQLException {
        string = string.trim();
        string2 = string2.trim();
        Driver.load();
        Properties properties = new Properties();
        properties.setProperty("user", string3.trim());
        properties.setProperty("password", string4);
        if (string2.startsWith("jdbc:h2:")) {
            if (this.ifExists) {
                string2 = string2 + ";IFEXISTS=TRUE";
            }
            properties.put("DATABASE_EVENT_LISTENER_OBJECT", databaseEventListener);
            return Driver.load().connect(string2, properties);
        }
        return JdbcUtils.getConnection(string, string2, properties);
    }

    void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    boolean getAllowScript() {
        return this.allowScript;
    }

    public String addSession(Connection connection) throws SQLException {
        WebSession webSession = this.createNewSession("local");
        webSession.setShutdownServerOnDisconnect();
        webSession.setConnection(connection);
        webSession.put("url", connection.getMetaData().getURL());
        String string = (String)webSession.get("sessionId");
        return this.url + "/frame.jsp?jsessionid=" + string;
    }

    String startTranslate(Map map) {
        if (this.translateThread != null) {
            this.translateThread.stopNow();
        }
        this.translateThread = new TranslateThread(map);
        this.translateThread.setDaemon(true);
        this.translateThread.start();
        return this.translateThread.getFileName();
    }

    private class TranslateThread
    extends Thread {
        private final File file = new File("translation.properties");
        private final Map translation;
        private volatile boolean stopNow;

        TranslateThread(Map map) {
            this.translation = map;
        }

        public String getFileName() {
            return this.file.getAbsolutePath();
        }

        public void stopNow() {
            this.stopNow = true;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            while (!this.stopNow) {
                try {
                    Closeable closeable;
                    SortedProperties sortedProperties = new SortedProperties();
                    if (this.file.exists()) {
                        closeable = FileUtils.openFileInputStream(this.file.getName());
                        sortedProperties.load((InputStream)closeable);
                        this.translation.putAll(sortedProperties);
                    } else {
                        closeable = FileUtils.openFileOutputStream(this.file.getName(), false);
                        sortedProperties.putAll((Map<?, ?>)this.translation);
                        sortedProperties.store((OutputStream)closeable, "Translation");
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    WebServer.this.traceError(exception);
                }
            }
        }
    }
}

