/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.RowIndex;
import org.h2.index.ScanCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Storage;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class ScanIndex
extends BaseIndex
implements RowIndex {
    private int firstFree = -1;
    private ObjectArray rows = new ObjectArray();
    private Storage storage;
    private TableData tableData;
    private int rowCountDiff;
    private HashMap sessionRowCount;
    private HashSet delta;
    private long rowCount;

    public ScanIndex(TableData tableData, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(tableData, n, tableData.getName() + "_TABLE_SCAN", indexColumnArray, indexType);
        if (this.database.isMultiVersion()) {
            this.sessionRowCount = new HashMap();
        }
        this.tableData = tableData;
        if (!this.database.isPersistent() || n < 0 || !indexType.getPersistent()) {
            return;
        }
        this.storage = this.database.getStorage(tableData, n, true);
        int n2 = this.storage.getRecordCount();
        this.rowCount = n2;
        tableData.setRowCount(n2);
        this.trace.info("open existing " + tableData.getName() + " rows: " + n2);
    }

    public void remove(Session session) throws SQLException {
        this.truncate(session);
        if (this.storage != null) {
            this.storage.truncate(session);
            this.database.removeStorage(this.storage.getId(), this.storage.getDiskFile());
        }
    }

    public void truncate(Session session) throws SQLException {
        if (this.storage == null) {
            this.rows = new ObjectArray();
            this.firstFree = -1;
        } else {
            this.storage.truncate(session);
        }
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        this.tableData.setRowCount(0L);
        this.rowCount = 0L;
        if (this.database.isMultiVersion()) {
            this.sessionRowCount.clear();
        }
    }

    public String getCreateSQL() {
        return null;
    }

    public void close(Session session) {
        if (this.storage != null) {
            this.storage = null;
        }
    }

    public Row getRow(Session session, int n) throws SQLException {
        if (this.storage != null) {
            return (Row)this.storage.getRecord(session, n);
        }
        return (Row)this.rows.get(n);
    }

    public void add(Session session, Row row) throws SQLException {
        int n;
        if (this.storage != null) {
            if (this.tableData.getContainsLargeObject()) {
                for (n = 0; n < row.getColumnCount(); ++n) {
                    Value value = row.getValue(n);
                    Value value2 = value.link(this.database, this.getId());
                    if (value2.isLinked()) {
                        session.unlinkAtCommitStop(value2);
                    }
                    if (value == value2) continue;
                    row.setValue(n, value2);
                }
            }
            this.storage.addRecord(session, row, -1);
        } else {
            if (this.firstFree == -1) {
                n = this.rows.size();
                row.setPos(n);
                this.rows.add(row);
            } else {
                n = this.firstFree;
                Row row2 = (Row)this.rows.get(n);
                this.firstFree = row2.getPos();
                row.setPos(n);
                this.rows.set(n, row);
            }
            row.setDeleted(false);
        }
        if (this.database.isMultiVersion()) {
            if (this.delta == null) {
                this.delta = new HashSet();
            }
            if ((n = (int)(this.delta.remove(row) ? 1 : 0)) == 0) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), 1);
        }
        ++this.rowCount;
    }

    public void commit(int n, Row row) {
        if (this.database.isMultiVersion()) {
            if (this.delta != null) {
                this.delta.remove(row);
            }
            this.incrementRowCount(row.getSessionId(), n == 1 ? 1 : -1);
        }
    }

    private void incrementRowCount(int n, int n2) {
        if (this.database.isMultiVersion()) {
            Integer n3 = ObjectUtils.getInteger(n);
            Integer n4 = (Integer)this.sessionRowCount.get(n3);
            int n5 = n4 == null ? 0 : n4;
            this.sessionRowCount.put(n3, ObjectUtils.getInteger(n5 + n2));
            this.rowCountDiff += n2;
        }
    }

    public void remove(Session session, Row row) throws SQLException {
        int n;
        if (this.storage != null) {
            this.storage.removeRecord(session, row.getPos());
            if (this.tableData.getContainsLargeObject()) {
                for (n = 0; n < row.getColumnCount(); ++n) {
                    Value value = row.getValue(n);
                    if (!value.isLinked()) continue;
                    session.unlinkAtCommit((ValueLob)value);
                }
            }
        } else if (!this.database.isMultiVersion() && this.rowCount == 1L) {
            this.rows = new ObjectArray();
            this.firstFree = -1;
        } else {
            Row row2 = new Row(null, 0);
            row2.setPos(this.firstFree);
            int n2 = row.getPos();
            this.rows.set(n2, row2);
            this.firstFree = n2;
        }
        if (this.database.isMultiVersion()) {
            row.setDeleted(true);
            if (this.delta == null) {
                this.delta = new HashSet();
            }
            if ((n = (int)(this.delta.remove(row) ? 1 : 0)) == 0) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), -1);
        }
        --this.rowCount;
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return new ScanCursor(session, this, this.database.isMultiVersion());
    }

    public double getCost(Session session, int[] nArray) {
        long l = this.tableData.getRowCountApproximation() + 1000L;
        if (this.storage != null) {
            l *= 10L;
        }
        return l;
    }

    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            Integer n = (Integer)this.sessionRowCount.get(ObjectUtils.getInteger(session.getId()));
            long l = n == null ? 0L : (long)n.intValue();
            l += this.rowCount;
            return l -= (long)this.rowCountDiff;
        }
        return this.rowCount;
    }

    Row getNextRow(Session session, Row row) throws SQLException {
        if (this.storage == null) {
            int n = row == null ? -1 : row.getPos();
            do {
                if (++n < this.rows.size()) continue;
                return null;
            } while ((row = (Row)this.rows.get(n)).isEmpty());
            return row;
        }
        int n = this.storage.getNext(row);
        if (n < 0) {
            return null;
        }
        return (Row)this.storage.getRecord(session, n);
    }

    public int getColumnIndex(Column column) {
        return -1;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("SCAN");
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("SCAN");
    }

    public Iterator getDelta() {
        return this.delta == null ? Collections.EMPTY_LIST.iterator() : this.delta.iterator();
    }

    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

