/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public abstract class SessionWithState
implements SessionInterface {
    protected ObjectArray sessionState;
    protected boolean sessionStateChanged;
    private boolean sessionStateUpdating;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recreateSessionState() throws SQLException {
        if (this.sessionState != null && this.sessionState.size() > 0) {
            this.sessionStateUpdating = true;
            try {
                for (int i = 0; i < this.sessionState.size(); ++i) {
                    String string = (String)this.sessionState.get(i);
                    CommandInterface commandInterface = this.prepareCommand(string, Integer.MAX_VALUE);
                    commandInterface.executeUpdate();
                }
            }
            finally {
                this.sessionStateUpdating = false;
                this.sessionStateChanged = false;
            }
        }
    }

    public void readSessionState() throws SQLException {
        if (!this.sessionStateChanged || this.sessionStateUpdating) {
            return;
        }
        this.sessionStateChanged = false;
        this.sessionState = new ObjectArray();
        CommandInterface commandInterface = this.prepareCommand("SELECT * FROM INFORMATION_SCHEMA.SESSION_STATE", Integer.MAX_VALUE);
        ResultInterface resultInterface = commandInterface.executeQuery(0, false);
        while (resultInterface.next()) {
            Value[] valueArray = resultInterface.currentRow();
            this.sessionState.add(valueArray[1].getString());
        }
    }
}

