/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Comparator;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.ObjectArray;

public abstract class CacheObject {
    public CacheObject previous;
    public CacheObject next;
    public CacheObject chained;
    public int cacheQueue;
    protected int blockCount;
    private int pos;
    private boolean changed;

    public abstract boolean canRemove();

    public static void sort(ObjectArray objectArray) {
        objectArray.sort(new CacheComparator());
    }

    public void setBlockCount(int n) {
        this.blockCount = n;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setPos(int n) {
        if (SysProperties.CHECK && (this.previous != null || this.next != null || this.chained != null)) {
            Message.throwInternalError("setPos too late");
        }
        this.pos = n;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public boolean isPinned() {
        return false;
    }

    public int getMemorySize() {
        return this.blockCount * 32;
    }

    static {
        new CacheComparator();
    }

    private static class CacheComparator
    implements Comparator {
        private CacheComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = ((CacheObject)object).getPos();
            return n2 == (n = ((CacheObject)object2).getPos()) ? 0 : (n2 < n ? -1 : 1);
        }
    }
}

