/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.message.Message;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;

class PageBtreeNode
extends PageBtree {
    private static final int CHILD_OFFSET_PAIR_LENGTH = 8;
    private static final int CHILD_OFFSET_PAIR_START = 15;
    private int[] childPageIds;
    private int rowCountStored = -1;
    private int rowCount = -1;

    PageBtreeNode(PageBtreeIndex pageBtreeIndex, int n, int n2, DataPage dataPage) {
        super(pageBtreeIndex, n, n2, dataPage);
    }

    void read() {
        this.data.setPos(5);
        this.entryCount = this.data.readShortInt();
        this.rowCount = this.rowCountStored = this.data.readInt();
        this.childPageIds = new int[this.entryCount + 1];
        this.childPageIds[this.entryCount] = this.data.readInt();
        this.rows = new SearchRow[this.entryCount];
        this.offsets = new int[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.childPageIds[i] = this.data.readInt();
            this.offsets[i] = this.data.readInt();
        }
        this.check();
    }

    private int addChild(int n, int n2, SearchRow searchRow) throws SQLException {
        int n3;
        int n4 = this.index.getRowSize(this.data, searchRow);
        int n5 = this.index.getPageStore().getPageSize();
        int n6 = n3 = this.entryCount == 0 ? n5 : this.offsets[this.entryCount - 1];
        if (this.entryCount > 0 && n3 - n4 < this.start + 8) {
            return this.entryCount / 2 + 1;
        }
        int n7 = n3 - n4;
        int[] nArray = new int[this.entryCount + 1];
        SearchRow[] searchRowArray = new SearchRow[this.entryCount + 1];
        int[] nArray2 = new int[this.entryCount + 2];
        if (this.childPageIds != null) {
            System.arraycopy(this.childPageIds, 0, nArray2, 0, n + 1);
        }
        if (this.entryCount > 0) {
            System.arraycopy(this.offsets, 0, nArray, 0, n);
            System.arraycopy(this.rows, 0, searchRowArray, 0, n);
            if (n < this.entryCount) {
                System.arraycopy(this.offsets, n, nArray, n + 1, this.entryCount - n);
                System.arraycopy(this.rows, n, searchRowArray, n + 1, this.entryCount - n);
                System.arraycopy(this.childPageIds, n, nArray2, n + 1, this.entryCount - n + 1);
            }
        }
        nArray[n] = n7;
        searchRowArray[n] = searchRow;
        nArray2[n + 1] = n2;
        this.offsets = nArray;
        this.rows = searchRowArray;
        this.childPageIds = nArray2;
        ++this.entryCount;
        return 0;
    }

    int addRow(SearchRow searchRow) throws SQLException {
        int n;
        PageBtree pageBtree;
        int n2;
        while ((n2 = (pageBtree = this.index.getPage(this.childPageIds[n = this.find(searchRow, false)])).addRow(searchRow)) != 0) {
            SearchRow searchRow2 = pageBtree.getRow(n2 - 1);
            PageBtree pageBtree2 = pageBtree.split(n2);
            this.index.getPageStore().updateRecord(pageBtree, true, pageBtree.data);
            this.index.getPageStore().updateRecord(pageBtree2, true, pageBtree2.data);
            n2 = this.addChild(n, pageBtree2.getPageId(), searchRow2);
            if (n2 != 0) {
                return n2 / 2;
            }
            this.index.getPageStore().updateRecord(this, true, this.data);
        }
        this.updateRowCount(1);
        return 0;
    }

    private void updateRowCount(int n) throws SQLException {
        if (this.rowCount != -1) {
            this.rowCount += n;
        }
        if (this.rowCountStored != -1) {
            this.rowCountStored = -1;
            this.index.getPageStore().updateRecord(this, true, this.data);
        }
    }

    PageBtree split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageBtreeNode pageBtreeNode = new PageBtreeNode(this.index, n2, this.parentPageId, this.index.getPageStore().createDataPage());
        int n3 = this.childPageIds[n];
        int n4 = n;
        while (n4 < this.entryCount) {
            pageBtreeNode.addChild(pageBtreeNode.entryCount, this.childPageIds[n + 1], this.rows[n]);
            this.removeChild(n);
        }
        n4 = this.childPageIds[n - 1];
        this.removeChild(n - 1);
        this.childPageIds[n - 1] = n4;
        pageBtreeNode.childPageIds[0] = n3;
        pageBtreeNode.remapChildren();
        return pageBtreeNode;
    }

    protected void remapChildren() throws SQLException {
        for (int i = 0; i < this.childPageIds.length; ++i) {
            int n = this.childPageIds[i];
            PageBtree pageBtree = this.index.getPage(n);
            pageBtree.setParentPageId(this.getPos());
            this.index.getPageStore().updateRecord(pageBtree, true, pageBtree.data);
        }
    }

    void init(PageBtree pageBtree, SearchRow searchRow, PageBtree pageBtree2) throws SQLException {
        this.entryCount = 0;
        this.childPageIds = new int[]{pageBtree.getPageId()};
        this.rows = new SearchRow[0];
        this.offsets = new int[0];
        this.addChild(0, pageBtree2.getPageId(), searchRow);
        this.check();
    }

    void find(PageBtreeCursor pageBtreeCursor, SearchRow searchRow, boolean bl) throws SQLException {
        int n = this.find(searchRow, bl);
        if (n > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.find(pageBtreeCursor, searchRow, bl);
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n]);
        pageBtree.find(pageBtreeCursor, searchRow, bl);
    }

    PageBtreeLeaf getFirstLeaf() throws SQLException {
        int n = this.childPageIds[0];
        return this.index.getPage(n).getFirstLeaf();
    }

    boolean remove(SearchRow searchRow) throws SQLException {
        int n = this.find(searchRow, false);
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n]);
        boolean bl = pageBtree.remove(searchRow);
        this.updateRowCount(-1);
        if (!bl) {
            return false;
        }
        this.index.getPageStore().freePage(pageBtree.getPageId());
        if (this.entryCount < 1) {
            return true;
        }
        this.removeChild(n);
        this.index.getPageStore().updateRecord(this, true, this.data);
        return false;
    }

    int getRowCount() throws SQLException {
        if (this.rowCount == -1) {
            int n = 0;
            for (int i = 0; i < this.childPageIds.length; ++i) {
                PageBtree pageBtree = this.index.getPage(this.childPageIds[i]);
                n += pageBtree.getRowCount();
            }
            this.rowCount = n;
        }
        return this.rowCount;
    }

    void setRowCountStored(int n) throws SQLException {
        this.rowCount = n;
        if (this.rowCountStored != n) {
            this.rowCountStored = n;
            this.index.getPageStore().updateRecord(this, true, this.data);
        }
    }

    private void check() {
        for (int i = 0; i < this.childPageIds.length; ++i) {
            if (this.childPageIds[i] != 0) continue;
            Message.throwInternalError();
        }
    }

    public int getByteCount(DataPage dataPage) throws SQLException {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.check();
        this.data.reset();
        this.data.writeInt(this.parentPageId);
        this.data.writeByte((byte)5);
        this.data.writeShortInt(this.entryCount);
        this.data.writeInt(this.rowCountStored);
        this.data.writeInt(this.childPageIds[this.entryCount]);
        for (int i = 0; i < this.entryCount; ++i) {
            this.data.writeInt(this.childPageIds[i]);
            this.data.writeInt(this.offsets[i]);
        }
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void removeChild(int n) throws SQLException {
        --this.entryCount;
        if (this.entryCount < 0) {
            Message.throwInternalError();
        }
        int[] nArray = new int[this.entryCount];
        SearchRow[] searchRowArray = new SearchRow[this.entryCount + 1];
        int[] nArray2 = new int[this.entryCount + 1];
        System.arraycopy(this.offsets, 0, nArray, 0, Math.min(this.entryCount, n));
        System.arraycopy(this.rows, 0, searchRowArray, 0, Math.min(this.entryCount, n));
        System.arraycopy(this.childPageIds, 0, nArray2, 0, n);
        if (this.entryCount > n) {
            System.arraycopy(this.offsets, n + 1, nArray, n, this.entryCount - n);
            System.arraycopy(this.rows, n + 1, searchRowArray, n, this.entryCount - n);
        }
        System.arraycopy(this.childPageIds, n + 1, nArray2, n, this.entryCount - n + 1);
        this.offsets = nArray;
        this.rows = searchRowArray;
        this.childPageIds = nArray2;
    }

    void nextPage(PageBtreeCursor pageBtreeCursor, SearchRow searchRow) throws SQLException {
        PageBtree pageBtree;
        int n = this.find(searchRow, true);
        if (n > this.entryCount) {
            if (this.parentPageId == 0) {
                pageBtreeCursor.setCurrent(null, 0);
                return;
            }
            pageBtree = (PageBtreeNode)this.index.getPage(this.parentPageId);
            ((PageBtreeNode)pageBtree).nextPage(pageBtreeCursor, this.getRow(this.entryCount - 1));
        }
        pageBtree = this.index.getPage(this.childPageIds[n]);
        PageBtreeLeaf pageBtreeLeaf = pageBtree.getFirstLeaf();
        pageBtreeCursor.setCurrent(pageBtreeLeaf, 0);
    }

    public String toString() {
        return "page[" + this.getPos() + "] btree node table:" + this.index.getId() + " entries:" + this.entryCount;
    }
}

