/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.util.BitField;

public class PageLog {
    private PageStore store;
    private BitField undo = new BitField();
    private int bufferPos;
    private int firstPage;
    private int nextPage;
    private DataPage data;
    private DataPage output;

    PageLog(PageStore pageStore, int n) {
        this.store = pageStore;
        this.firstPage = n;
        this.data = pageStore.createDataPage();
        this.output = pageStore.createDataPage();
    }

    private void prepareOutput() throws SQLException {
        this.output.reset();
        this.output.writeInt(0);
        this.output.writeByte((byte)5);
        this.output.writeInt(this.store.allocatePage());
    }

    private void undo() throws SQLException {
        int n = this.firstPage;
        while (n != 0) {
            this.data = this.store.readPage(this.firstPage);
            this.data.setPos(4);
        }
    }

    private void write(byte[] byArray, int n, int n2) {
        if (this.bufferPos + n2 > this.store.getPageSize()) {
            while (n2 > 0) {
                int n3 = Math.min(n2, this.store.getPageSize() - this.bufferPos);
                this.write(byArray, n, n3);
                n += n3;
                n2 -= n3;
            }
            return;
        }
        System.arraycopy(byArray, n, this.output.getBytes(), this.bufferPos, n2);
        this.bufferPos += n2;
    }
}

