/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;

public class DataPageBinary
extends DataPage {
    public DataPageBinary(DataHandler dataHandler, byte[] byArray) {
        super(dataHandler, byArray);
    }

    public void updateChecksum() {
        int n = this.handler.getChecksum(this.data, 0, this.pos - 2);
        this.data[this.pos - 2] = (byte)n;
    }

    public void check(int n) throws SQLException {
        int n2 = this.handler.getChecksum(this.data, 0, n - 2);
        if (this.data[n - 2] == (byte)n2) {
            return;
        }
        this.handler.handleInvalidChecksum();
    }

    public int getFillerLength() {
        return 2;
    }

    public void writeByte(byte by) {
        this.data[this.pos++] = by;
    }

    public int readByte() {
        return this.data[this.pos++];
    }

    public void writeInt(int n) {
        byte[] byArray = this.data;
        byArray[this.pos++] = (byte)(n >> 24);
        byArray[this.pos++] = (byte)(n >> 16);
        byArray[this.pos++] = (byte)(n >> 8);
        byArray[this.pos++] = (byte)n;
    }

    public void setInt(int n, int n2) {
        byte[] byArray = this.data;
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public int readInt() {
        byte[] byArray = this.data;
        return (byArray[this.pos++] << 24) + ((byArray[this.pos++] & 0xFF) << 16) + ((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF);
    }

    public void writeShortInt(int n) {
        byte[] byArray = this.data;
        byArray[this.pos++] = (byte)(n >> 8);
        byArray[this.pos++] = (byte)n;
    }

    public int readShortInt() {
        byte[] byArray = this.data;
        return ((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF);
    }

    private static int getStringLenUTF8(String string) {
        int n = 4;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0800') {
                n += 2;
                continue;
            }
            if (c != '\u0000' && c < '\u0080') continue;
            ++n;
        }
        return n2 + n;
    }

    private void writeStringUTF8(String string) {
        int n = string.length();
        this.checkCapacity(n * 3 + 4);
        int n2 = this.pos;
        byte[] byArray = this.data;
        byArray[n2++] = (byte)(n >> 24);
        byArray[n2++] = (byte)(n >> 16);
        byArray[n2++] = (byte)(n >> 8);
        byArray[n2++] = (byte)n;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u0000' && c < '\u0080') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                byArray[n2++] = (byte)(0xE0 | c >> 12);
                byArray[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c >> 6);
            byArray[n2++] = (byte)(0x80 | c & 0x3F);
        }
        this.pos = n2;
    }

    private String readStringUTF8() {
        byte[] byArray = this.data;
        int n = this.pos;
        int n2 = ((byArray[n++] & 0xFF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            cArray[i] = (n3 = byArray[n++] & 0xFF) < 128 ? (char)n3 : (n3 >= 224 ? (char)(((n3 & 0xF) << 12) + ((byArray[n++] & 0x3F) << 6) + (byArray[n++] & 0x3F)) : (char)(((n3 & 0x1F) << 6) + (byArray[n++] & 0x3F)));
        }
        this.pos = n;
        return new String(cArray);
    }

    public void writeString(String string) {
        this.writeStringUTF8(string);
    }

    public String readString() {
        return this.readStringUTF8();
    }

    public int getIntLen() {
        return 4;
    }

    public int getLongLen(long l) {
        return 8;
    }

    public int getStringLen(String string) {
        return DataPageBinary.getStringLenUTF8(string);
    }

    public void fill(int n) {
        if (this.pos > n) {
            this.pos = n;
        }
        this.checkCapacity(n - this.pos);
        this.pos = n;
    }
}

