/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.message.Message;
import org.h2.util.ObjectArray;
import org.h2.util.ValueHashMap;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

class AggregateData {
    private final int aggregateType;
    private final int dataType;
    private long count;
    private ValueHashMap distinctValues;
    private Value value;
    private double sum;
    private double vpn;
    private ObjectArray list;

    AggregateData(int n, int n2) {
        this.aggregateType = n;
        this.dataType = n2;
    }

    void add(Database database, boolean bl, Value value) throws SQLException {
        if (this.aggregateType == 13) {
            int n;
            ++this.count;
            if (this.distinctValues == null) {
                this.distinctValues = new ValueHashMap(database);
            }
            if ((n = this.distinctValues.size()) > 10000) {
                this.distinctValues = new ValueHashMap(database);
                this.sum += (double)n;
            }
            this.distinctValues.put(value, this);
            return;
        }
        if (this.aggregateType == 0) {
            ++this.count;
            return;
        }
        if (value == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        if (bl) {
            if (this.distinctValues == null) {
                this.distinctValues = new ValueHashMap(database);
            }
            this.distinctValues.put(value, this);
            return;
        }
        switch (this.aggregateType) {
            case 1: {
                return;
            }
            case 3: {
                if (this.value == null) {
                    this.value = value.convertTo(this.dataType);
                    break;
                }
                value = value.convertTo(this.value.getType());
                this.value = this.value.add(value);
                break;
            }
            case 6: {
                if (this.value == null) {
                    this.value = value.convertTo(DataType.getAddProofType(this.dataType));
                    break;
                }
                value = value.convertTo(this.value.getType());
                this.value = this.value.add(value);
                break;
            }
            case 4: {
                if (this.value != null && database.compare(value, this.value) >= 0) break;
                this.value = value;
                break;
            }
            case 5: {
                if (this.value != null && database.compare(value, this.value) <= 0) break;
                this.value = value;
                break;
            }
            case 2: {
                if (this.list == null) {
                    this.list = new ObjectArray();
                }
                this.list.add(value);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                double d = value.getDouble();
                if (this.count == 1L) {
                    this.sum = d;
                    this.vpn = 0.0;
                    break;
                }
                double d2 = this.sum - d * (double)(this.count - 1L);
                this.vpn += d2 * d2 / (double)this.count / (double)(this.count - 1L);
                this.sum += d;
                break;
            }
            case 12: {
                value = value.convertTo(1);
                if (this.value == null) {
                    this.value = value;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() != false && value.getBoolean() != false);
                break;
            }
            case 11: {
                value = value.convertTo(1);
                if (this.value == null) {
                    this.value = value;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() != false || value.getBoolean() != false);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.aggregateType);
            }
        }
    }

    ObjectArray getList() {
        return this.list;
    }

    Value getValue(Database database, boolean bl) throws SQLException {
        if (bl) {
            this.count = 0L;
            this.groupDistinct(database);
        }
        Value value = null;
        switch (this.aggregateType) {
            case 13: {
                int n = 0;
                if (this.count == 0L) {
                    n = 0;
                } else {
                    this.sum += (double)this.distinctValues.size();
                    this.sum = 100.0 * this.sum / (double)this.count;
                    n = (int)this.sum;
                    n = n <= 0 ? 1 : (n > 100 ? 100 : n);
                }
                value = ValueInt.get(n);
                break;
            }
            case 0: 
            case 1: {
                value = ValueLong.get(this.count);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                value = this.value;
                break;
            }
            case 6: {
                if (this.value == null) break;
                value = this.divide(this.value, this.count);
                break;
            }
            case 2: {
                return null;
            }
            case 7: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(Math.sqrt(this.vpn / (double)this.count));
                break;
            }
            case 8: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(Math.sqrt(this.vpn / (double)(this.count - 1L)));
                break;
            }
            case 9: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(this.vpn / (double)this.count);
                break;
            }
            case 10: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(this.vpn / (double)(this.count - 1L));
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.aggregateType);
            }
        }
        return value == null ? ValueNull.INSTANCE : value.convertTo(this.dataType);
    }

    private Value divide(Value value, long l) throws SQLException {
        if (l == 0L) {
            return ValueNull.INSTANCE;
        }
        int n = Value.getHigherOrder(value.getType(), 5);
        Value value2 = ValueLong.get(l).convertTo(n);
        value = value.convertTo(n).divide(value2);
        return value;
    }

    private void groupDistinct(Database database) throws SQLException {
        if (this.distinctValues == null) {
            return;
        }
        if (this.aggregateType == 1) {
            this.count = this.distinctValues.size();
        } else {
            this.count = 0L;
            ObjectArray objectArray = this.distinctValues.keys();
            for (int i = 0; i < objectArray.size(); ++i) {
                this.add(database, false, (Value)objectArray.get(i));
            }
        }
    }
}

