/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class TableFilter
implements ColumnResolver {
    private static final int BEFORE_FIRST = 0;
    private static final int FOUND = 1;
    private static final int AFTER_LAST = 2;
    private static final int NULL_ROW = 3;
    private final Table table;
    private final Select select;
    private String alias;
    private Session session;
    private Index index;
    private IndexColumn[] indexColumns;
    private Cursor cursor;
    private int scanCount;
    private boolean used;
    private final ObjectArray indexConditions = new ObjectArray();
    private Expression filterCondition;
    private Expression joinCondition;
    private SearchRow currentSearchRow;
    private Row current;
    private int state;
    private TableFilter join;
    private boolean outerJoin;
    private boolean foundOne;
    private Expression fullCondition;

    public TableFilter(Session session, Table table, String string, boolean bl, Select select) throws SQLException {
        this.session = session;
        this.table = table;
        this.alias = string;
        this.select = select;
        if (!bl) {
            session.getUser().checkRight(table, 1);
        }
    }

    public Select getSelect() {
        return this.select;
    }

    public Table getTable() {
        return this.table;
    }

    public void lock(Session session, boolean bl, boolean bl2) throws SQLException {
        this.table.lock(session, bl, bl2);
        if (this.join != null) {
            this.join.lock(session, bl, bl2);
        }
    }

    public PlanItem getBestPlanItem(Session session) throws SQLException {
        PlanItem planItem;
        if (this.indexConditions.size() == 0) {
            planItem = new PlanItem();
            planItem.setIndex(this.table.getScanIndex(session));
            planItem.cost = planItem.getIndex().getCost(session, null);
        } else {
            int n = this.table.getColumns().length;
            int[] nArray = new int[n];
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                int n2;
                IndexCondition indexCondition = (IndexCondition)this.indexConditions.get(i);
                if (!indexCondition.isEvaluatable()) continue;
                if (indexCondition.isAlwaysFalse()) {
                    nArray = null;
                    break;
                }
                int n3 = n2 = indexCondition.getColumn().getColumnId();
                nArray[n3] = nArray[n3] | indexCondition.getMask();
            }
            planItem = this.table.getBestPlanItem(session, nArray);
        }
        if (this.join != null) {
            this.setEvaluatable(this.join);
            planItem.setJoinPlan(this.join.getBestPlanItem(session));
            planItem.cost += planItem.cost * planItem.getJoinPlan().cost;
        }
        return planItem;
    }

    private void setEvaluatable(TableFilter tableFilter) {
        do {
            Expression expression;
            if ((expression = tableFilter.getJoinCondition()) == null) continue;
            expression.setEvaluatable(this, true);
        } while ((tableFilter = tableFilter.getJoin()) != null);
    }

    public void setPlanItem(PlanItem planItem) {
        this.setIndex(planItem.getIndex());
        if (this.join != null && planItem.getJoinPlan() != null) {
            this.join.setPlanItem(planItem.getJoinPlan());
        }
    }

    public void prepare() throws SQLException {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            Column column;
            IndexCondition indexCondition = (IndexCondition)this.indexConditions.get(i);
            if (indexCondition.isAlwaysFalse() || this.index.getColumnIndex(column = indexCondition.getColumn()) >= 0) continue;
            this.indexConditions.remove(i);
            --i;
        }
        if (this.join != null) {
            if (SysProperties.CHECK && this.join == this) {
                throw Message.getInternalError("self join");
            }
            this.join.prepare();
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(this.session);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimize(this.session);
        }
    }

    public void startQuery(Session session) {
        this.session = session;
        this.scanCount = 0;
        if (this.join != null) {
            this.join.startQuery(session);
        }
    }

    public void reset() {
        if (this.join != null) {
            this.join.reset();
        }
        this.state = 0;
        this.foundOne = false;
    }

    private Value getMax(Value value, Value value2, boolean bl) throws SQLException {
        if (value == null) {
            return value2;
        }
        if (value2 == null) {
            return value;
        }
        int n = value.compareTo(value2, this.session.getDatabase().getCompareMode());
        if (!bl) {
            n = -n;
        }
        return n > 0 ? value : value2;
    }

    public boolean next() throws SQLException {
        boolean bl = false;
        if (this.state == 2) {
            return false;
        }
        if (this.state == 0) {
            Row row = null;
            Row row2 = null;
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                Value value;
                IndexCondition indexCondition = (IndexCondition)this.indexConditions.get(i);
                if (indexCondition.isAlwaysFalse()) {
                    bl = true;
                    break;
                }
                Column column = indexCondition.getColumn();
                int n = column.getType();
                int n2 = column.getColumnId();
                Value value2 = indexCondition.getCurrentValue(this.session).convertTo(n);
                boolean bl2 = indexCondition.isStart();
                boolean bl3 = indexCondition.isEnd();
                IndexColumn indexColumn = this.indexColumns[n2];
                if (indexColumn != null && (indexColumn.sortType & 1) != 0) {
                    boolean bl4 = bl2;
                    bl2 = bl3;
                    bl3 = bl4;
                }
                if (bl2) {
                    Value value3;
                    if (row == null) {
                        row = this.table.getTemplateRow();
                        value3 = value2;
                    } else {
                        value3 = this.getMax(row.getValue(n2), value2, true);
                    }
                    row.setValue(n2, value3);
                }
                if (!bl3) continue;
                if (row2 == null) {
                    row2 = this.table.getTemplateRow();
                    value = value2;
                } else {
                    value = this.getMax(row2.getValue(n2), value2, false);
                }
                row2.setValue(n2, value);
            }
            if (!bl) {
                this.cursor = this.index.find(this.session, row, row2);
                if (this.join != null) {
                    this.join.reset();
                }
            }
        } else if (this.join != null && this.join.next()) {
            return true;
        }
        while (this.state != 3) {
            if (bl) {
                this.state = 2;
            } else {
                if ((++this.scanCount & 0xFFF) == 0) {
                    this.checkTimeout();
                }
                if (this.cursor.next()) {
                    this.currentSearchRow = this.cursor.getSearchRow();
                    this.current = null;
                    this.state = 1;
                } else {
                    this.state = 2;
                }
            }
            if (this.state == 2) {
                if (!this.outerJoin || this.foundOne) break;
                this.state = 3;
                this.current = this.table.getNullRow();
                this.currentSearchRow = this.current;
            }
            if (!this.isOk(this.filterCondition)) continue;
            boolean bl5 = this.isOk(this.joinCondition);
            if (this.state == 1) {
                if (!bl5) continue;
                this.foundOne = true;
            }
            if (this.join != null) {
                this.join.reset();
                if (!this.join.next()) continue;
            }
            if (this.state != 3 && !bl5) continue;
            return true;
        }
        this.state = 2;
        return false;
    }

    private void checkTimeout() throws SQLException {
        this.session.checkCanceled();
    }

    private boolean isOk(Expression expression) throws SQLException {
        if (expression == null) {
            return true;
        }
        return Boolean.TRUE.equals(expression.getBooleanValue(this.session));
    }

    public Row get() throws SQLException {
        if (this.current == null && this.currentSearchRow != null) {
            if (this.table.getClustered()) {
                this.current = this.table.getTemplateRow();
                for (int i = 0; i < this.currentSearchRow.getColumnCount(); ++i) {
                    this.current.setValue(i, this.currentSearchRow.getValue(i));
                }
            } else {
                this.current = this.cursor.get();
            }
        }
        return this.current;
    }

    public void set(Row row) {
        this.current = row;
        this.currentSearchRow = row;
    }

    public String getTableAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.table.getName();
    }

    public void addIndexCondition(IndexCondition indexCondition) {
        this.indexConditions.add(indexCondition);
    }

    public void addFilterCondition(Expression expression, boolean bl) {
        if (bl) {
            this.joinCondition = this.joinCondition == null ? expression : new ConditionAndOr(0, this.joinCondition, expression);
        } else {
            this.filterCondition = this.filterCondition == null ? expression : new ConditionAndOr(0, this.filterCondition, expression);
        }
    }

    public void addJoin(TableFilter tableFilter, boolean bl, Expression expression) throws SQLException {
        if (expression != null) {
            expression.mapColumns(this, 0);
        }
        if (this.join == null) {
            this.join = tableFilter;
            tableFilter.outerJoin = bl;
            if (expression != null) {
                tableFilter.mapAndAddFilter(expression);
            }
        } else {
            this.join.addJoin(tableFilter, bl, expression);
        }
    }

    private void mapAndAddFilter(Expression expression) throws SQLException {
        expression.mapColumns(this, 0);
        this.addFilterCondition(expression, true);
        expression.createIndexConditions(this.session, this);
        if (this.join != null) {
            this.join.mapAndAddFilter(expression);
        }
    }

    public TableFilter getJoin() {
        return this.join;
    }

    public boolean isJoinOuter() {
        return this.outerJoin;
    }

    public String getPlanSQL(boolean bl) {
        CharSequence charSequence;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            if (this.outerJoin) {
                stringBuffer.append("LEFT OUTER JOIN ");
            } else {
                stringBuffer.append("INNER JOIN ");
            }
        }
        stringBuffer.append(this.table.getSQL());
        if (this.alias != null) {
            stringBuffer.append(' ');
            stringBuffer.append(Parser.quoteIdentifier(this.alias));
        }
        if (this.index != null) {
            stringBuffer.append(" /* ");
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(this.index.getPlanSQL());
            if (this.indexConditions.size() > 0) {
                ((StringBuffer)charSequence).append(": ");
                for (int i = 0; i < this.indexConditions.size(); ++i) {
                    IndexCondition indexCondition = (IndexCondition)this.indexConditions.get(i);
                    if (i > 0) {
                        ((StringBuffer)charSequence).append(" AND ");
                    }
                    ((StringBuffer)charSequence).append(indexCondition.getSQL());
                }
            }
            String string = ((StringBuffer)charSequence).toString();
            string = StringUtils.quoteRemarkSQL(string);
            stringBuffer.append(string);
            stringBuffer.append(" */");
        }
        if (bl) {
            stringBuffer.append(" ON ");
            if (this.joinCondition == null) {
                stringBuffer.append("1=1");
            } else {
                stringBuffer.append(StringUtils.unEnclose(this.joinCondition.getSQL()));
            }
        }
        if (this.filterCondition != null) {
            stringBuffer.append(" /* WHERE ");
            charSequence = StringUtils.unEnclose(this.filterCondition.getSQL());
            charSequence = StringUtils.quoteRemarkSQL((String)charSequence);
            stringBuffer.append((String)charSequence);
            stringBuffer.append(" */");
        }
        return stringBuffer.toString();
    }

    void removeUnusableIndexConditions() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            IndexCondition indexCondition = (IndexCondition)this.indexConditions.get(i);
            if (indexCondition.isEvaluatable()) continue;
            this.indexConditions.remove(i--);
        }
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
        Column[] columnArray = this.table.getColumns();
        this.indexColumns = new IndexColumn[columnArray.length];
        IndexColumn[] indexColumnArray = index.getIndexColumns();
        if (indexColumnArray != null) {
            for (int i = 0; i < columnArray.length; ++i) {
                int n = index.getColumnIndex(columnArray[i]);
                if (n < 0) continue;
                this.indexColumns[i] = indexColumnArray[n];
            }
        }
    }

    public void setUsed(boolean bl) {
        this.used = bl;
    }

    public boolean getUsed() {
        return this.used;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public void removeJoin() {
        this.join = null;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void removeJoinCondition() {
        this.joinCondition = null;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void removeFilterCondition() {
        this.filterCondition = null;
    }

    public void setFullCondition(Expression expression) {
        this.fullCondition = expression;
        if (this.join != null) {
            this.join.setFullCondition(expression);
        }
    }

    void optimizeFullCondition(boolean bl) {
        if (this.fullCondition != null) {
            this.fullCondition.addFilterConditions(this, bl || this.outerJoin);
            if (this.join != null) {
                this.join.optimizeFullCondition(bl || this.outerJoin);
            }
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(tableFilter, bl);
        }
        if (this.joinCondition != null) {
            this.joinCondition.setEvaluatable(tableFilter, bl);
        }
        if (this.join != null) {
            this.join.setEvaluatable(tableFilter, bl);
        }
    }

    public String getSchemaName() {
        return this.table.getSchema().getName();
    }

    public Column[] getColumns() {
        return this.table.getColumns();
    }

    public Column[] getSystemColumns() {
        if (!this.session.getDatabase().getMode().systemColumns) {
            return null;
        }
        Column[] columnArray = new Column[3];
        columnArray[0] = new Column("oid", 4);
        columnArray[0].setTable(this.table, 0);
        columnArray[1] = new Column("ctid", 13);
        columnArray[1].setTable(this.table, 0);
        columnArray[2] = new Column("CTID", 13);
        columnArray[2].setTable(this.table, 0);
        return columnArray;
    }

    public Value getValue(Column column) throws SQLException {
        if (this.currentSearchRow == null) {
            return null;
        }
        int n = column.getColumnId();
        if (this.current == null) {
            Value value = this.currentSearchRow.getValue(n);
            if (value != null) {
                return value;
            }
            this.current = this.cursor.get();
        }
        return this.current.getValue(n);
    }

    public TableFilter getTableFilter() {
        return this;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public Expression optimize(ExpressionColumn expressionColumn, Column column) {
        return expressionColumn;
    }

    public String toString() {
        return this.alias != null ? this.alias : "" + this.table;
    }
}

