/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.RangeCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;

public class RangeIndex
extends BaseIndex {
    private RangeTable rangeTable;

    public RangeIndex(RangeTable rangeTable, IndexColumn[] indexColumnArray) {
        this.initBaseIndex(rangeTable, 0, "RANGE_INDEX", indexColumnArray, IndexType.createNonUnique(true));
        this.rangeTable = rangeTable;
    }

    public void close(Session session) {
    }

    public void add(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void remove(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        long l = this.rangeTable.getMin(session);
        long l2 = this.rangeTable.getMax(session);
        long l3 = Math.max(l, searchRow == null ? l : searchRow.getValue(0).getLong());
        long l4 = Math.min(l2, searchRow2 == null ? l2 : searchRow2.getValue(0).getLong());
        return new RangeCursor(l3, l4);
    }

    public double getCost(Session session, int[] nArray) {
        return 1.0;
    }

    public String getCreateSQL() {
        return null;
    }

    public void remove(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        long l = bl ? this.rangeTable.getMin(session) : this.rangeTable.getMax(session);
        return new RangeCursor(l, l);
    }
}

