/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.LinkedCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.TableLink;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class LinkedIndex
extends BaseIndex {
    private TableLink link;
    private String targetTableName;

    public LinkedIndex(TableLink tableLink, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(tableLink, n, null, indexColumnArray, indexType);
        this.link = tableLink;
        this.targetTableName = this.link.getQualifiedTable();
    }

    public String getCreateSQL() {
        return null;
    }

    public void close(Session session) throws SQLException {
    }

    private boolean isNull(Value value) {
        return value == null || value == ValueNull.INSTANCE;
    }

    public void add(Session session, Row row) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(this.targetTableName);
        stringBuffer.append(" VALUES(");
        int n = 0;
        for (int i = 0; i < row.getColumnCount(); ++i) {
            Value value = row.getValue(i);
            if (n > 0) {
                stringBuffer.append(',');
            }
            ++n;
            if (this.isNull(value)) {
                stringBuffer.append("NULL");
                continue;
            }
            stringBuffer.append('?');
        }
        stringBuffer.append(')');
        String string = stringBuffer.toString();
        try {
            PreparedStatement preparedStatement = this.link.getPreparedStatement(string);
            int n2 = 0;
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                if (value == null || value == ValueNull.INSTANCE) continue;
                value.set(preparedStatement, n2 + 1);
                ++n2;
            }
            preparedStatement.executeUpdate();
            ++this.rowCount;
        }
        catch (SQLException sQLException) {
            throw this.wrapException(string, sQLException);
        }
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; searchRow != null && n < searchRow.getColumnCount(); ++n) {
            object = searchRow.getValue(n);
            if (object == null) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(this.table.getColumn(n).getSQL());
            stringBuffer.append(">=?");
        }
        for (n = 0; searchRow2 != null && n < searchRow2.getColumnCount(); ++n) {
            object = searchRow2.getValue(n);
            if (object == null) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(this.table.getColumn(n).getSQL());
            stringBuffer.append("<=?");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, " WHERE ");
        }
        stringBuffer.insert(0, "SELECT * FROM " + this.targetTableName + " T");
        String string = stringBuffer.toString();
        try {
            Value value;
            int n2;
            object = this.link.getPreparedStatement(string);
            int n3 = 0;
            for (n2 = 0; searchRow != null && n2 < searchRow.getColumnCount(); ++n2) {
                value = searchRow.getValue(n2);
                if (value == null) continue;
                value.set((PreparedStatement)object, n3 + 1);
                ++n3;
            }
            for (n2 = 0; searchRow2 != null && n2 < searchRow2.getColumnCount(); ++n2) {
                value = searchRow2.getValue(n2);
                if (value == null) continue;
                value.set((PreparedStatement)object, n3 + 1);
                ++n3;
            }
            ResultSet resultSet = object.executeQuery();
            return new LinkedCursor(this.table, resultSet, session);
        }
        catch (SQLException sQLException) {
            throw this.wrapException(string, sQLException);
        }
    }

    public int getLookupCost(int n) {
        int n2 = 0;
        int n3 = 1;
        while ((n3 *= 10) <= n) {
            ++n2;
        }
        return n2 + 1;
    }

    public double getCost(Session session, int[] nArray) throws SQLException {
        return 100L + this.getCostRangeIndex(nArray, this.rowCount + 1000L);
    }

    public void remove(Session session) throws SQLException {
    }

    public void truncate(Session session) throws SQLException {
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void remove(Session session, Row row) throws SQLException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
        stringBuffer.append(this.targetTableName);
        stringBuffer.append(" WHERE ");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuffer.append("AND ");
            }
            stringBuffer.append(this.table.getColumn(i).getSQL());
            object = row.getValue(i);
            if (this.isNull((Value)object)) {
                stringBuffer.append(" IS NULL ");
                continue;
            }
            stringBuffer.append("=? ");
        }
        String string = stringBuffer.toString();
        try {
            int n;
            object = this.link.getPreparedStatement(string);
            int n2 = 0;
            for (n = 0; n < row.getColumnCount(); ++n) {
                Value value = row.getValue(n);
                if (this.isNull(value)) continue;
                value.set((PreparedStatement)object, n2 + 1);
                ++n2;
            }
            n = object.executeUpdate();
            this.rowCount -= (long)n;
        }
        catch (SQLException sQLException) {
            throw this.wrapException(string, sQLException);
        }
    }

    public void update(Session session, Row row, Row row2) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("UPDATE ");
        stringBuffer.append(this.targetTableName).append(" SET ");
        for (n = 0; n < row2.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.table.getColumn(n).getSQL()).append("=?");
        }
        stringBuffer.append(" WHERE ");
        for (n = 0; n < row.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuffer.append("AND ");
            }
            stringBuffer.append(this.table.getColumn(n).getSQL());
            Value value = row.getValue(n);
            if (this.isNull(value)) {
                stringBuffer.append(" IS NULL ");
                continue;
            }
            stringBuffer.append("=? ");
        }
        String string = stringBuffer.toString();
        try {
            int n2;
            int n3 = 1;
            PreparedStatement preparedStatement = this.link.getPreparedStatement(string);
            for (n2 = 0; n2 < row2.getColumnCount(); ++n2) {
                row2.getValue(n2).set(preparedStatement, n3);
                ++n3;
            }
            for (n2 = 0; n2 < row.getColumnCount(); ++n2) {
                Value value = row.getValue(n2);
                if (this.isNull(value)) continue;
                value.set(preparedStatement, n3);
                ++n3;
            }
            n2 = preparedStatement.executeUpdate();
            this.rowCount = this.rowCount + (long)n2 - (long)n2;
        }
        catch (SQLException sQLException) {
            throw this.wrapException(string, sQLException);
        }
    }

    private SQLException wrapException(String string, SQLException sQLException) {
        return Message.getSQLException(90111, new String[]{string, sQLException.toString()}, sQLException);
    }
}

