/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class CompareLike
extends Condition {
    private final CompareMode compareMode;
    private final boolean regexp;
    private Expression left;
    private Expression right;
    private Expression escape;
    private boolean isInit;
    private char[] pattern;
    private String patternString;
    private Pattern patternRegexp;
    private int[] types;
    private int patternLength;
    private static final int MATCH = 0;
    private static final int ONE = 1;
    private static final int ANY = 2;
    private boolean ignoreCase;

    public CompareLike(CompareMode compareMode, Expression expression, Expression expression2, Expression expression3, boolean bl) {
        this.compareMode = compareMode;
        this.regexp = bl;
        this.left = expression;
        this.right = expression2;
        this.escape = expression3;
    }

    public String getSQL() {
        String string;
        if (this.regexp) {
            string = this.left.getSQL() + " REGEXP " + this.right.getSQL();
        } else {
            string = this.left.getSQL() + " LIKE " + this.right.getSQL();
            if (this.escape != null) {
                string = string + " ESCAPE " + this.escape.getSQL();
            }
        }
        return "(" + string + ")";
    }

    public Expression optimize(Session session) throws SQLException {
        Value value;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.getType() == 14) {
            this.ignoreCase = true;
        }
        if (this.left.isValueSet() && (value = this.left.getValue(session)) == ValueNull.INSTANCE) {
            return ValueExpression.NULL;
        }
        if (this.escape != null) {
            this.escape = this.escape.optimize(session);
        }
        if (this.right.isValueSet() && (this.escape == null || this.escape.isValueSet())) {
            Value value2;
            if (this.left.isValueSet()) {
                return ValueExpression.get(this.getValue(session));
            }
            value = this.right.getValue(session);
            if (value == ValueNull.INSTANCE) {
                return ValueExpression.NULL;
            }
            Value value3 = value2 = this.escape == null ? null : this.escape.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                return ValueExpression.NULL;
            }
            String string = value.getString();
            this.initPattern(string, this.getEscapeChar(value2));
            if ("%".equals(string)) {
                return new Comparison(session, 7, this.left, null).optimize(session);
            }
            if (this.isFullMatch()) {
                ValueString valueString = ValueString.get(this.patternString);
                ValueExpression valueExpression = ValueExpression.get(valueString);
                return new Comparison(session, 0, this.left, valueExpression).optimize(session);
            }
            this.isInit = true;
        }
        return this;
    }

    private char getEscapeChar(Value value) throws SQLException {
        if (value == null) {
            return '\\';
        }
        String string = value.getString();
        char c = string == null || string.length() == 0 ? (char)'\\' : string.charAt(0);
        return c;
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) throws SQLException {
        Value value;
        if (this.regexp) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (!this.right.isValueSet()) {
            return;
        }
        if (this.escape != null && !this.escape.isValueSet()) {
            return;
        }
        String string = this.right.getValue(session).getString();
        Value value2 = value = this.escape == null ? null : this.escape.getValue(session);
        if (value == ValueNull.INSTANCE) {
            throw Message.getInternalError();
        }
        this.initPattern(string, this.getEscapeChar(value));
        if (this.patternLength <= 0 || this.types[0] != 0) {
            return;
        }
        int n = expressionColumn.getColumn().getType();
        if (n != 13 && n != 14 && n != 21) {
            return;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < this.patternLength && this.types[n2] == 0) {
            stringBuffer.append(this.pattern[n2++]);
        }
        String string2 = stringBuffer.toString();
        if (n2 == this.patternLength) {
            tableFilter.addIndexCondition(new IndexCondition(0, expressionColumn, ValueExpression.get(ValueString.get(string2))));
        } else if (string2.length() > 0) {
            tableFilter.addIndexCondition(new IndexCondition(1, expressionColumn, ValueExpression.get(ValueString.get(string2))));
            char c = string2.charAt(string2.length() - 1);
            for (int i = 1; i < 2000; ++i) {
                String string3 = string2.substring(0, string2.length() - 1) + (char)(c + i);
                if (this.compareMode.compareString(string2, string3, this.ignoreCase) != -1) continue;
                tableFilter.addIndexCondition(new IndexCondition(4, expressionColumn, ValueExpression.get(ValueString.get(string3))));
                break;
            }
        }
    }

    public Value getValue(Session session) throws SQLException {
        Object object;
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        if (!this.isInit) {
            Value value2;
            object = this.right.getValue(session);
            if (object == ValueNull.INSTANCE) {
                return object;
            }
            String string = ((Value)object).getString();
            Value value3 = value2 = this.escape == null ? null : this.escape.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            this.initPattern(string, this.getEscapeChar(value2));
        }
        object = value.getString();
        boolean bl = this.regexp ? this.patternRegexp.matcher((CharSequence)object).find() : this.compareAt((String)object, 0, 0, ((String)object).length());
        return ValueBoolean.get(bl);
    }

    private boolean compare(String string, int n, int n2) {
        return this.compareMode.equalsChars(this.patternString, n, string, n2, this.ignoreCase);
    }

    private boolean compareAt(String string, int n, int n2, int n3) {
        while (n < this.patternLength) {
            int n4 = this.types[n];
            switch (n4) {
                case 0: {
                    if (n2 < n3 && this.compare(string, n, n2++)) break;
                    return false;
                }
                case 1: {
                    if (n2++ < n3) break;
                    return false;
                }
                case 2: {
                    if (++n >= this.patternLength) {
                        return true;
                    }
                    while (n2 < n3) {
                        if (this.compare(string, n, n2) && this.compareAt(string, n, n2, n3)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
                default: {
                    throw Message.getInternalError("type=" + n4);
                }
            }
            ++n;
        }
        return n2 == n3;
    }

    public boolean test(String string, String string2, char c) throws SQLException {
        this.initPattern(string, c);
        return this.compareAt(string2, 0, 0, string2.length());
    }

    private void initPattern(String string, char c) throws SQLException {
        int n;
        if (this.regexp) {
            this.patternString = string;
            try {
                this.patternRegexp = this.ignoreCase ? Pattern.compile(string, 2) : Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw Message.getSQLException(22025, new String[]{string}, patternSyntaxException);
            }
            return;
        }
        this.patternLength = 0;
        if (string == null) {
            this.types = null;
            this.pattern = null;
            return;
        }
        int n2 = string.length();
        this.pattern = new char[n2];
        this.types = new int[n2];
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            int n3;
            char c2 = string.charAt(n);
            if (c == c2) {
                if (n >= n2 - 1) {
                    throw Message.getSQLException(22025, StringUtils.addAsterisk(string, n));
                }
                if ((c2 = string.charAt(++n)) != '_' && c2 != '%' && c2 != c) {
                    throw Message.getSQLException(22025, StringUtils.addAsterisk(string, n));
                }
                n3 = 0;
                bl = false;
            } else if (c2 == '%') {
                if (bl) continue;
                n3 = 2;
                bl = true;
            } else if (c2 == '_') {
                n3 = 1;
            } else {
                n3 = 0;
                bl = false;
            }
            this.types[this.patternLength] = n3;
            this.pattern[this.patternLength++] = c2;
        }
        for (n = 0; n < this.patternLength - 1; ++n) {
            if (this.types[n] != 2 || this.types[n + 1] != 1) continue;
            this.types[n] = 1;
            this.types[n + 1] = 2;
        }
        this.patternString = new String(this.pattern, 0, this.patternLength);
    }

    private boolean isFullMatch() {
        if (this.types == null) {
            return false;
        }
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        this.left.mapColumns(columnResolver, n);
        this.right.mapColumns(columnResolver, n);
        if (this.escape != null) {
            this.escape.mapColumns(columnResolver, n);
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
        if (this.escape != null) {
            this.escape.setEvaluatable(tableFilter, bl);
        }
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
        if (this.escape != null) {
            this.escape.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor) && (this.escape == null || this.escape.isEverything(expressionVisitor));
    }

    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 3;
    }
}

