/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;

public class AlterTableAlterColumn
extends SchemaCommand {
    public static final int NOT_NULL = 0;
    public static final int NULL = 1;
    public static final int DEFAULT = 2;
    public static final int CHANGE_TYPE = 3;
    public static final int ADD = 4;
    public static final int DROP = 5;
    public static final int SELECTIVITY = 6;
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private int type;
    private Expression defaultExpression;
    private Expression newSelectivity;
    private String addBefore;

    public AlterTableAlterColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setOldColumn(Column column) {
        this.oldColumn = column;
    }

    public void setAddBefore(String string) {
        this.addBefore = string;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkRight(this.table, 15);
        this.table.checkSupportAlter();
        this.table.lock(this.session, true, true);
        Sequence sequence = this.oldColumn == null ? null : this.oldColumn.getSequence();
        switch (this.type) {
            case 0: {
                if (!this.oldColumn.getNullable()) break;
                this.checkNoNullValues();
                this.oldColumn.setNullable(false);
                database.update(this.session, this.table);
                break;
            }
            case 1: {
                if (this.oldColumn.getNullable()) break;
                this.checkNullable();
                this.oldColumn.setNullable(true);
                database.update(this.session, this.table);
                break;
            }
            case 2: {
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, this.defaultExpression);
                this.removeSequence(this.session, sequence);
                database.update(this.session, this.table);
                break;
            }
            case 3: {
                this.checkNoViews();
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, null);
                this.oldColumn.setConvertNullToDefault(false);
                if (this.oldColumn.getNullable() && !this.newColumn.getNullable()) {
                    this.checkNoNullValues();
                } else if (!this.oldColumn.getNullable() && this.newColumn.getNullable()) {
                    this.checkNullable();
                }
                this.convertToIdentityIfRequired(this.newColumn);
                this.copyData();
                break;
            }
            case 4: {
                this.checkNoViews();
                this.convertToIdentityIfRequired(this.newColumn);
                this.copyData();
                break;
            }
            case 5: {
                this.checkNoViews();
                if (this.table.getColumns().length == 1) {
                    throw Message.getSQLException(90084, this.oldColumn.getSQL());
                }
                this.table.checkColumnIsNotReferenced(this.oldColumn);
                this.dropSingleColumnIndexes();
                this.copyData();
                break;
            }
            case 6: {
                int n = this.newSelectivity.optimize(this.session).getValue(this.session).getInt();
                this.oldColumn.setSelectivity(n);
                database.update(this.session, this.table);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    private void convertToIdentityIfRequired(Column column) throws SQLException {
        if (column.getAutoIncrement()) {
            column.setOriginalSQL("IDENTITY");
        }
    }

    private void removeSequence(Session session, Sequence sequence) throws SQLException {
        if (sequence != null) {
            this.table.removeSequence(session, sequence);
            sequence.setBelongsToTable(false);
            Database database = session.getDatabase();
            database.removeSchemaObject(session, sequence);
        }
    }

    private void checkNoViews() throws SQLException {
        ObjectArray objectArray = this.table.getChildren();
        for (int i = 0; i < objectArray.size(); ++i) {
            DbObject dbObject = (DbObject)objectArray.get(i);
            if (dbObject.getType() != 0) continue;
            throw Message.getSQLException(90122, new String[]{this.table.getName(), dbObject.getName()});
        }
    }

    private void copyData() throws SQLException {
        int n;
        DbObject dbObject;
        String string;
        Object object;
        boolean bl;
        Database database = this.session.getDatabase();
        String string2 = database.getTempTableName(this.session.getId());
        Column[] columnArray = this.table.getColumns();
        ObjectArray objectArray = new ObjectArray();
        for (bl = false; bl < columnArray.length; bl += 1) {
            Column column = columnArray[bl].getClone();
            objectArray.add(column);
        }
        if (this.type == 5) {
            bl = this.oldColumn.getColumnId();
            objectArray.remove(bl ? 1 : 0);
        } else if (this.type == 4) {
            bl = this.addBefore == null ? columnArray.length : this.table.getColumn(this.addBefore).getColumnId();
            objectArray.add(bl ? 1 : 0, this.newColumn);
        } else if (this.type == 3) {
            bl = this.oldColumn.getColumnId();
            objectArray.remove(bl ? 1 : 0);
            objectArray.add(bl ? 1 : 0, this.newColumn);
        }
        bl = this.table.isPersistent();
        int n2 = -1;
        TableData tableData = this.getSchema().createTable(string2, n2, objectArray, bl, false);
        tableData.setComment(this.table.getComment());
        this.execute(tableData.getCreateSQL(), true);
        tableData = (TableData)tableData.getSchema().getTableOrView(this.session, tableData.getName());
        ObjectArray objectArray2 = this.table.getChildren();
        ObjectArray objectArray3 = new ObjectArray();
        for (int i = 0; i < objectArray2.size(); ++i) {
            DbObject dbObject2 = (DbObject)objectArray2.get(i);
            if (dbObject2 instanceof Sequence || dbObject2 instanceof Index && (object = (Index)dbObject2).getIndexType().belongsToConstraint() || (object = dbObject2.getCreateSQL()) == null) continue;
            if (dbObject2.getType() == 0) {
                throw Message.getInternalError();
            }
            string = Parser.quoteIdentifier(string2 + "_" + dbObject2.getName());
            String string3 = null;
            if (dbObject2 instanceof ConstraintReferential && ((Constraint)(dbObject = (ConstraintReferential)dbObject2)).getTable() != this.table) {
                string3 = ((ConstraintReferential)dbObject).getCreateSQLForCopy(((Constraint)dbObject).getTable(), tableData, string, false);
            }
            if (string3 == null) {
                string3 = dbObject2.getCreateSQLForCopy(tableData, string);
            }
            if (string3 == null) continue;
            if (dbObject2 instanceof TriggerObject) {
                objectArray3.add(string3);
                continue;
            }
            this.execute(string3, true);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.size(); ++i) {
            object = (Column)objectArray.get(i);
            if (this.type == 4 && object == this.newColumn) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(((Column)object).getSQL());
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("INSERT INTO ");
        stringBuffer2.append(tableData.getSQL());
        stringBuffer2.append("(");
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append(") SELECT ");
        if (stringBuffer.length() == 0) {
            stringBuffer2.append("*");
        } else {
            stringBuffer2.append(stringBuffer);
        }
        stringBuffer2.append(" FROM ");
        stringBuffer2.append(this.table.getSQL());
        object = stringBuffer2.toString();
        tableData.setCheckForeignKeyConstraints(this.session, false, false);
        try {
            this.execute((String)object, false);
        }
        catch (SQLException sQLException) {
            this.unlinkSequences(tableData);
            this.execute("DROP TABLE " + tableData.getSQL(), true);
            throw sQLException;
        }
        tableData.setCheckForeignKeyConstraints(this.session, true, false);
        string = this.table.getName();
        this.table.setModified();
        for (n = 0; n < columnArray.length; ++n) {
            dbObject = columnArray[n].getSequence();
            if (dbObject == null) continue;
            this.table.removeSequence(this.session, (Sequence)dbObject);
            columnArray[n].setSequence(null);
        }
        for (n = 0; n < objectArray3.size(); ++n) {
            object = (String)objectArray3.get(n);
            this.execute((String)object, true);
        }
        this.execute("DROP TABLE " + this.table.getSQL(), true);
        database.renameSchemaObject(this.session, tableData, string);
        objectArray2 = tableData.getChildren();
        for (n = 0; n < objectArray2.size(); ++n) {
            String string4;
            dbObject = (DbObject)objectArray2.get(n);
            if (dbObject instanceof Sequence || (string4 = dbObject.getName()) == null || dbObject.getCreateSQL() == null || !string4.startsWith(string2 + "_")) continue;
            string4 = string4.substring(string2.length() + 1);
            database.renameSchemaObject(this.session, (SchemaObject)dbObject, string4);
        }
    }

    private void unlinkSequences(Table table) throws SQLException {
        Column[] columnArray = table.getColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            Sequence sequence = columnArray[i].getSequence();
            if (sequence == null) continue;
            table.removeSequence(this.session, sequence);
            columnArray[i].setSequence(null);
        }
    }

    private void execute(String string, boolean bl) throws SQLException {
        Prepared prepared = this.session.prepare(string);
        prepared.update();
        if (bl && this.session.getDatabase().isMultiVersion()) {
            this.session.commit(true);
        }
    }

    private void dropSingleColumnIndexes() throws SQLException {
        Database database = this.session.getDatabase();
        ObjectArray objectArray = this.table.getIndexes();
        for (int i = 0; i < objectArray.size(); ++i) {
            Index index = (Index)objectArray.get(i);
            if (index.getCreateSQL() == null) continue;
            boolean bl = false;
            Column[] columnArray = index.getColumns();
            for (int j = 0; j < columnArray.length; ++j) {
                if (columnArray[j] != this.oldColumn) continue;
                if (columnArray.length == 1) {
                    bl = true;
                    continue;
                }
                throw Message.getSQLException(90075, index.getSQL());
            }
            if (!bl) continue;
            database.removeSchemaObject(this.session, index);
            objectArray = this.table.getIndexes();
            i = -1;
        }
    }

    private void checkNullable() throws SQLException {
        ObjectArray objectArray = this.table.getIndexes();
        for (int i = 0; i < objectArray.size(); ++i) {
            IndexType indexType;
            Index index = (Index)objectArray.get(i);
            if (index.getColumnIndex(this.oldColumn) < 0 || !(indexType = index.getIndexType()).isPrimaryKey() && !indexType.isHash()) continue;
            throw Message.getSQLException(90075, index.getSQL());
        }
    }

    private void checkNoNullValues() throws SQLException {
        String string = "SELECT COUNT(*) FROM " + this.table.getSQL() + " WHERE " + this.oldColumn.getSQL() + " IS NULL";
        Prepared prepared = this.session.prepare(string);
        LocalResult localResult = prepared.query(0);
        localResult.next();
        if (localResult.currentRow()[0].getInt() > 0) {
            throw Message.getSQLException(90081, this.oldColumn.getSQL());
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setSelectivity(Expression expression) {
        this.newSelectivity = expression;
    }

    public void setDefaultExpression(Expression expression) {
        this.defaultExpression = expression;
    }

    public void setNewColumn(Column column) {
        this.newColumn = column;
    }
}

