/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.Message;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;

public class Engine {
    private static final Engine INSTANCE = new Engine();
    private static volatile long wrongPasswordDelay = SysProperties.DELAY_WRONG_PASSWORD_MIN;
    private static Object wrongPasswordSync = new Object();
    private final HashMap databases = new HashMap();

    private Engine() {
    }

    public static Engine getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session openSession(ConnectionInfo connectionInfo, boolean bl, String string) throws SQLException {
        String string2 = connectionInfo.getName();
        Database database = connectionInfo.isUnnamed() ? null : (Database)this.databases.get(string2);
        User user = null;
        boolean bl2 = false;
        if (database == null) {
            if (bl && !Database.exists(string2)) {
                throw Message.getSQLException(90013, string2);
            }
            database = new Database(string2, connectionInfo, string);
            bl2 = true;
            if (database.getAllUsers().size() == 0) {
                user = new User(database, database.allocateObjectId(false, true), connectionInfo.getUserName(), false);
                user.setAdmin(true);
                user.setUserPasswordHash(connectionInfo.getUserPasswordHash());
                database.setMasterUser(user);
            }
            if (!connectionInfo.isUnnamed()) {
                this.databases.put(string2, database);
            }
            database.opened();
        }
        Database database2 = database;
        synchronized (database2) {
            if (database.isClosing()) {
                return null;
            }
            if (user == null) {
                if (database.validateFilePasswordHash(string, connectionInfo.getFilePasswordHash()) && (user = database.findUser(connectionInfo.getUserName())) != null && !user.validateUserPasswordHash(connectionInfo.getUserPasswordHash())) {
                    user = null;
                }
                if (bl2 && (user == null || !user.getAdmin())) {
                    database.setEventListener(null);
                }
            }
            if (user == null) {
                database.removeSession(null);
                throw Message.getSQLException(8004);
            }
            this.checkClustering(connectionInfo, database);
            Session session = database.createUserSession(user);
            return session;
        }
    }

    public Session getSession(ConnectionInfo connectionInfo) throws SQLException {
        try {
            Session session = this.openSession(connectionInfo);
            Engine.validateUserAndPassword(true);
            return session;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 8004) {
                Engine.validateUserAndPassword(false);
            }
            throw sQLException;
        }
    }

    private synchronized Session openSession(ConnectionInfo connectionInfo) throws SQLException {
        Session session;
        boolean bl = connectionInfo.removeProperty("IFEXISTS", false);
        boolean bl2 = connectionInfo.removeProperty("IGNORE_UNKNOWN_SETTINGS", false);
        String string = connectionInfo.removeProperty("CIPHER", null);
        while ((session = this.openSession(connectionInfo, bl, string)) == null) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        String[] stringArray = connectionInfo.getKeys();
        session.setAllowLiterals(true);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = connectionInfo.getProperty(string2);
            try {
                CommandInterface commandInterface = session.prepareCommand("SET " + Parser.quoteIdentifier(string2) + " " + string3, Integer.MAX_VALUE);
                commandInterface.executeUpdate();
                continue;
            }
            catch (SQLException sQLException) {
                if (bl2) continue;
                session.close();
                throw sQLException;
            }
        }
        session.setAllowLiterals(false);
        session.commit(true);
        session.getDatabase().getTrace("session").info("connected #" + session.getId());
        return session;
    }

    private void checkClustering(ConnectionInfo connectionInfo, Database database) throws SQLException {
        String string = connectionInfo.getProperty(13, null);
        if ("''".equals(string)) {
            return;
        }
        String string2 = database.getCluster();
        if (!"''".equals(string2) && !StringUtils.equals(string, string2)) {
            if (string2.equals("''")) {
                throw Message.getSQLException(90093);
            }
            throw Message.getSQLException(90094, string2);
        }
    }

    public void close(String string) {
        this.databases.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateUserAndPassword(boolean bl) throws SQLException {
        int n = SysProperties.DELAY_WRONG_PASSWORD_MIN;
        if (bl) {
            long l = wrongPasswordDelay;
            if (l > (long)n && l > 0L) {
                Object object = wrongPasswordSync;
                synchronized (object) {
                    l = RandomUtils.nextInt((int)l);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    wrongPasswordDelay = n;
                }
            }
        } else {
            Object object = wrongPasswordSync;
            synchronized (object) {
                long l = wrongPasswordDelay;
                int n2 = SysProperties.DELAY_WRONG_PASSWORD_MAX;
                if (n2 <= 0) {
                    n2 = Integer.MAX_VALUE;
                }
                if ((wrongPasswordDelay += wrongPasswordDelay) > (long)n2 || wrongPasswordDelay < 0L) {
                    wrongPasswordDelay = n2;
                }
                if (n > 0) {
                    l += Math.abs(RandomUtils.getSecureLong() % 100L);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw Message.getSQLException(8004);
            }
        }
    }
}

