/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.util.ObjectUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueDouble
extends Value {
    public static final int PRECISION = 17;
    public static final int DISPLAY_SIZE = 24;
    private final double value;
    private static final double DOUBLE_ZERO = 0.0;
    private static final double DOUBLE_ONE = 1.0;
    private static final ValueDouble ZERO = new ValueDouble(0.0);
    private static final ValueDouble ONE = new ValueDouble(1.0);

    private ValueDouble(double d) {
        this.value = d;
    }

    public Value add(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.value + valueDouble.value);
    }

    public Value subtract(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.value - valueDouble.value);
    }

    public Value negate() {
        return ValueDouble.get(-this.value);
    }

    public Value multiply(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.value * valueDouble.value);
    }

    public Value divide(Value value) throws SQLException {
        ValueDouble valueDouble = (ValueDouble)value;
        if (valueDouble.value == 0.0) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueDouble.get(this.value / valueDouble.value);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 7;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueDouble valueDouble = (ValueDouble)value;
        if (this.value == valueDouble.value) {
            return 0;
        }
        return this.value > valueDouble.value ? 1 : -1;
    }

    public int getSignum() {
        return this.value == 0.0 ? 0 : (this.value < 0.0 ? -1 : 1);
    }

    public double getDouble() {
        return this.value;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 17L;
    }

    public int getScale() {
        return 0;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >> 32);
    }

    public Object getObject() {
        return ObjectUtils.getDouble(this.value);
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setDouble(n, this.value);
    }

    public static ValueDouble get(double d) {
        if (0.0 == d) {
            return ZERO;
        }
        if (1.0 == d) {
            return ONE;
        }
        return (ValueDouble)Value.cache(new ValueDouble(d));
    }

    public int getDisplaySize() {
        return 24;
    }

    public boolean equals(Object object) {
        return object instanceof ValueDouble && this.value == ((ValueDouble)object).value;
    }
}

