/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.util.ByteUtils;
import org.h2.util.IOUtils;
import org.h2.util.ResourceData;
import org.h2.util.StringUtils;

public class Resources {
    private static final HashMap FILES = new HashMap();
    static /* synthetic */ Class class$org$h2$util$Resources;

    private static boolean loadFromZip() {
        InputStream inputStream = (class$org$h2$util$Resources == null ? (class$org$h2$util$Resources = Resources.class$("org.h2.util.Resources")) : class$org$h2$util$Resources).getResourceAsStream("data.zip");
        if (inputStream == null) {
            return false;
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy(zipInputStream, byteArrayOutputStream);
                zipInputStream.closeEntry();
                FILES.put(string, byteArrayOutputStream.toByteArray());
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : null;
        String string2 = stringArray.length > 1 ? stringArray[1] : null;
        new Resources().run(string, string2);
    }

    void run(String string, String string2) throws Exception {
        if (string == null) {
            string = "bin";
        }
        if (string2 == null) {
            string2 = "src/main";
        }
        if (new File(string + "/org/h2/util").exists()) {
            String string3 = string + "/org/h2/util/ResourceData.java";
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string3)));
            printWriter.println("package org.h2.util;");
            printWriter.println("// Do not change this code manually");
            printWriter.println("// This code is generated by " + this.getClass().getName());
            printWriter.println("class ResourceData {");
            printWriter.println("    public static void load() {");
            this.generate(printWriter, string2 + "/org/h2/res", "org.h2");
            this.generate(printWriter, string2 + "/org/h2/server/web/res", "org.h2.server.web");
            printWriter.println("    }");
            printWriter.println("}");
            printWriter.close();
        }
    }

    void generate(PrintWriter printWriter, String string, String string2) throws Exception {
        File file = new File(string);
        String[] stringArray = file.list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (!file2.isFile() || stringArray[i].endsWith(".java")) continue;
            String string3 = "/" + string2.replace('.', '/') + "/res/" + file2.getName();
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray = IOUtils.readBytesAndClose(fileInputStream, 0);
            String string4 = ByteUtils.convertToBinString(byArray);
            printWriter.print("        Resources.add(" + StringUtils.quoteJavaString(string3) + ", ");
            printWriter.print("new String[]{");
            do {
                String string5;
                if (string4.length() < 65000) {
                    string5 = string4;
                    string4 = null;
                } else {
                    string5 = string4.substring(0, 65000);
                    string4 = string4.substring(65000);
                }
                printWriter.print(StringUtils.quoteJavaString(string5));
                printWriter.println(", ");
            } while (string4 != null);
            printWriter.println("});");
        }
    }

    static void add(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        FILES.put(string, ByteUtils.convertBinStringToBytes(stringBuffer.toString()));
    }

    public static byte[] get(String string) throws IOException {
        InputStream inputStream;
        Object object = FILES.size() == 0 ? (Object)((inputStream = (class$org$h2$util$Resources == null ? (class$org$h2$util$Resources = Resources.class$("org.h2.util.Resources")) : class$org$h2$util$Resources).getResourceAsStream(string)) == null ? null : IOUtils.readBytesAndClose(inputStream, 0)) : (byte[])FILES.get(string);
        return object == null ? new byte[]{} : object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (!Resources.loadFromZip()) {
            ResourceData.load();
        }
    }
}

