/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DiskFile;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.util.BitField;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;

public class Storage {
    public static final int ALLOCATE_POS = -1;
    private static final int FREE_LIST_SIZE = Math.max(1024, 256);
    private DiskFile file;
    private int recordCount;
    private RecordReader reader;
    private IntArray freeList = new IntArray();
    private IntArray pages = new IntArray();
    private int id;
    private Database database;
    private DataPage dummy;
    private int pageCheckIndex;

    public Storage(Database database, DiskFile diskFile, RecordReader recordReader, int n) {
        this.database = database;
        this.file = diskFile;
        this.reader = recordReader;
        this.id = n;
        this.dummy = DataPage.create((DataHandler)database, 0);
    }

    public RecordReader getRecordReader() {
        return this.reader;
    }

    void incrementRecordCount() {
        ++this.recordCount;
    }

    public Record getRecord(Session session, int n) throws SQLException {
        return this.file.getRecord(session, n, this.reader, this.id);
    }

    public Record getRecordIfStored(Session session, int n) throws SQLException {
        return this.file.getRecordIfStored(session, n, this.reader, this.id);
    }

    public int getNext(Record record) {
        int n;
        int n2;
        int n3 = -1;
        if (record == null) {
            if (this.pages.size() == 0) {
                return -1;
            }
            n3 = 0;
            n2 = this.pages.get(0);
            n = n2 * 64;
        } else {
            int n4 = record.getBlockCount();
            n2 = this.file.getPage(record.getPos());
            n = record.getPos() + n4;
        }
        Database database = this.database;
        synchronized (database) {
            BitField bitField = this.file.getUsed();
            while (true) {
                int n5;
                if (n2 != (n5 = this.file.getPage(n))) {
                    n3 = n3 < 0 ? this.pages.findNextValueIndex(n5) : ++n3;
                    if (n3 >= this.pages.size()) {
                        return -1;
                    }
                    n2 = this.pages.get(n3);
                    n = Math.max(n, 64 * n2);
                }
                if (bitField.get(n)) {
                    return n;
                }
                if (bitField.getLong(n) == 0L) {
                    n = MathUtils.roundUp(n + 1, 64);
                    continue;
                }
                ++n;
            }
        }
    }

    public void updateRecord(Session session, Record record) throws SQLException {
        record.setDeleted(false);
        this.file.updateRecord(session, record);
    }

    public void addRecord(Session session, Record record, int n) throws SQLException {
        record.setStorageId(this.id);
        int n2 = this.file.getRecordOverhead() + record.getByteCount(this.dummy);
        n2 = MathUtils.roundUp(n2, 128);
        record.setDeleted(false);
        int n3 = n2 / 128;
        if (n == -1) {
            n = this.allocate(n3);
        } else {
            this.file.setUsed(n, n3);
        }
        record.setPos(n);
        record.setBlockCount(n3);
        record.setChanged(true);
        ++this.recordCount;
        this.file.addRecord(session, record);
    }

    public void removeRecord(Session session, int n) throws SQLException {
        this.checkOnePage();
        Record record = this.getRecord(session, n);
        if (SysProperties.CHECK && record.getDeleted()) {
            throw Message.getInternalError("duplicate delete " + n);
        }
        record.setDeleted(true);
        int n2 = record.getBlockCount();
        this.file.uncommittedDelete(session);
        this.free(n, n2);
        --this.recordCount;
        this.file.removeRecord(session, n, record, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFreeAndMine(int n, int n2) {
        Database database = this.database;
        synchronized (database) {
            BitField bitField = this.file.getUsed();
            for (int i = n2 + n - 1; i >= n; --i) {
                if (this.file.getPageOwner(this.file.getPage(i)) == this.id && !bitField.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocate(int n) throws SQLException {
        if (this.freeList.size() > 0) {
            Database database = this.database;
            synchronized (database) {
                BitField bitField = this.file.getUsed();
                for (int i = 0; i < this.freeList.size(); ++i) {
                    int n2 = this.freeList.get(i);
                    if (bitField.get(n2)) {
                        this.freeList.remove(i--);
                        continue;
                    }
                    if (!this.isFreeAndMine(n2, n)) continue;
                    int n3 = n2;
                    this.freeList.remove(i--);
                    this.file.setUsed(n3, n);
                    return n3;
                }
            }
        }
        int n4 = this.file.allocate(this, n);
        this.file.setUsed(n4, n);
        return n4;
    }

    void free(int n, int n2) {
        this.file.free(n, n2);
        if (this.freeList.size() < FREE_LIST_SIZE) {
            this.freeList.add(n);
        }
    }

    public void delete(Session session) throws SQLException {
        this.truncate(session);
    }

    public int getId() {
        return this.id;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void truncate(Session session) throws SQLException {
        this.freeList = new IntArray();
        this.recordCount = 0;
        this.file.truncateStorage(session, this, this.pages);
    }

    public void setReader(RecordReader recordReader) {
        this.reader = recordReader;
    }

    public void flushRecord(Record record) throws SQLException {
        this.file.writeBack(record);
    }

    public void flushFile() throws SQLException {
        this.file.flush();
    }

    public int getRecordOverhead() {
        return this.file.getRecordOverhead();
    }

    public DiskFile getDiskFile() {
        return this.file;
    }

    public void setRecordCount(int n) {
        this.recordCount = n;
    }

    void addPage(int n) {
        this.pages.addValueSorted(n);
    }

    void removePage(int n) {
        this.pages.removeValue(n);
    }

    private void checkOnePage() throws SQLException {
        this.pageCheckIndex = (this.pageCheckIndex + 1) % this.pages.size();
        int n = this.pages.get(this.pageCheckIndex);
        if (!this.file.isPageFree(n) || this.file.getPageOwner(n) == this.id) {
            // empty if block
        }
    }
}

