/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.h2.Driver;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXid;
import org.h2.message.TraceObject;
import org.h2.util.ByteUtils;
import org.h2.util.JdbcConnectionListener;
import org.h2.util.JdbcUtils;

public class JdbcXAConnection
extends TraceObject
implements XAConnection,
XAResource,
JdbcConnectionListener {
    private JdbcDataSourceFactory factory;
    private String url;
    private String user;
    private String password;
    private JdbcConnection connSentinel;
    private JdbcConnection conn;
    private ArrayList listeners = new ArrayList();
    private Xid currentTransaction;
    private int currentTransactionId;
    private static int nextTransactionId;

    JdbcXAConnection(JdbcDataSourceFactory jdbcDataSourceFactory, int n, String string, String string2, String string3) throws SQLException {
        this.factory = jdbcDataSourceFactory;
        this.setTrace(jdbcDataSourceFactory.getTrace(), 13, n);
        this.url = string;
        this.user = string2;
        this.password = string3;
        this.connSentinel = this.openConnection();
        this.getConnection();
    }

    public XAResource getXAResource() throws SQLException {
        this.debugCodeCall("getXAResource");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.debugCodeCall("close");
        try {
            this.closeConnection(this.conn);
            this.closeConnection(this.connSentinel);
        }
        finally {
            this.conn = null;
            this.connSentinel = null;
        }
    }

    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        if (this.conn != null) {
            this.closeConnection(this.conn);
            this.conn = null;
        }
        this.conn = this.openConnection();
        this.conn.setJdbcConnectionListener(this);
        return this.conn;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.debugCode("addConnectionEventListener(listener);");
        this.listeners.add(connectionEventListener);
        if (this.conn != null) {
            this.conn.setJdbcConnectionListener(this);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.debugCode("removeConnectionEventListener(listener);");
        this.listeners.remove(connectionEventListener);
    }

    public void fatalErrorOccurred(JdbcConnection jdbcConnection, SQLException sQLException) throws SQLException {
        this.debugCode("fatalErrorOccurred(conn, e);");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(i);
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
        this.close();
    }

    public void closed(JdbcConnection jdbcConnection) {
        this.debugCode("closed(conn);");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(i);
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    public int getTransactionTimeout() throws XAException {
        this.debugCodeCall("getTransactionTimeout");
        return 0;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        this.debugCodeCall("setTransactionTimeout", n);
        return false;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        this.debugCode("isSameRM(xares);");
        return xAResource == this;
    }

    public Xid[] recover(int n) throws XAException {
        this.debugCodeCall("recover", this.quoteFlags(n));
        this.checkOpen();
        Statement statement = null;
        try {
            Xid[] xidArray;
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT ORDER BY TRANSACTION");
            ArrayList<JdbcXid> arrayList = new ArrayList<JdbcXid>();
            while (resultSet.next()) {
                xidArray = resultSet.getString("TRANSACTION");
                int n2 = this.getNextId(14);
                JdbcXid jdbcXid = new JdbcXid(this.factory, n2, (String)xidArray);
                arrayList.add(jdbcXid);
            }
            resultSet.close();
            xidArray = new Xid[arrayList.size()];
            arrayList.toArray(xidArray);
            Xid[] xidArray2 = xidArray;
            return xidArray2;
        }
        catch (SQLException sQLException) {
            this.getTrace().debug("throw XAException.XAER_RMERR", sQLException);
            throw new XAException(-3);
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this.debug()) {
            this.debugCode("prepare(" + this.quoteXid(xid) + ");");
        }
        this.checkOpen();
        if (!this.currentTransaction.equals(xid)) {
            this.getTrace().debug("throw XAException.XAER_INVAL");
            throw new XAException(-5);
        }
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            this.currentTransactionId = nextTransactionId++;
            statement.execute("PREPARE COMMIT TX_" + this.currentTransactionId);
        }
        catch (SQLException sQLException) {
            throw this.convertException(sQLException);
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
        this.getTrace().debug("return XA_OK");
        return 0;
    }

    public void forget(Xid xid) throws XAException {
        if (this.debug()) {
            this.debugCode("forget(" + this.quoteXid(xid) + ");");
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (this.debug()) {
            this.debugCode("rollback(" + this.quoteXid(xid) + ");");
        }
        try {
            this.conn.rollback();
        }
        catch (SQLException sQLException) {
            throw this.convertException(sQLException);
        }
        this.getTrace().debug("rolled back");
        this.currentTransaction = null;
    }

    public void end(Xid xid, int n) throws XAException {
        if (this.debug()) {
            this.debugCode("end(" + this.quoteXid(xid) + ", " + this.quoteFlags(n) + ");");
        }
        if (n == 0x2000000) {
            return;
        }
        if (!this.currentTransaction.equals(xid)) {
            this.getTrace().debug("throw XAException.XAER_OUTSIDE");
            throw new XAException(-9);
        }
    }

    public void start(Xid xid, int n) throws XAException {
        if (this.debug()) {
            this.debugCode("start(" + this.quoteXid(xid) + ", " + this.quoteFlags(n) + ");");
        }
        if (n == 0x8000000) {
            return;
        }
        if (this.currentTransaction != null) {
            this.getTrace().debug("throw XAException.XAER_NOTA");
            throw new XAException(-4);
        }
        try {
            this.conn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw this.convertException(sQLException);
        }
        this.getTrace().debug("currentTransaction=xid");
        this.currentTransaction = xid;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        Statement statement;
        block6: {
            if (this.debug()) {
                this.debugCode("commit(" + this.quoteXid(xid) + ", " + bl + ");");
            }
            statement = null;
            try {
                if (bl) {
                    this.conn.commit();
                    break block6;
                }
                statement = this.conn.createStatement();
                statement.execute("COMMIT TRANSACTION TX_" + this.currentTransactionId);
            }
            catch (SQLException sQLException) {
                try {
                    throw this.convertException(sQLException);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeSilently(statement);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeSilently(statement);
        this.getTrace().debug("committed");
        this.currentTransaction = null;
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.user;
    }

    private void closeConnection(JdbcConnection jdbcConnection) throws SQLException {
        if (jdbcConnection != null) {
            jdbcConnection.closeConnection();
        }
    }

    private JdbcConnection openConnection() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", this.user);
        properties.setProperty("password", this.password);
        JdbcConnection jdbcConnection = new JdbcConnection(this.url, properties);
        jdbcConnection.setJdbcConnectionListener(this);
        if (this.currentTransaction != null) {
            jdbcConnection.setAutoCommit(false);
        }
        return jdbcConnection;
    }

    private XAException convertException(SQLException sQLException) {
        if (this.debug()) {
            this.getTrace().debug("throw XAException(" + sQLException.getMessage() + ");");
        }
        return new XAException(sQLException.getMessage());
    }

    private String quoteXid(Xid xid) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"f:");
        stringBuffer.append(xid.getFormatId());
        stringBuffer.append(",bq:");
        stringBuffer.append(ByteUtils.convertBytesToString(xid.getBranchQualifier()));
        stringBuffer.append(",gx:");
        stringBuffer.append(ByteUtils.convertBytesToString(xid.getGlobalTransactionId()));
        stringBuffer.append(",c:");
        stringBuffer.append(xid.getClass().getName());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private String quoteFlags(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0x800000) != 0) {
            stringBuffer.append("|XAResource.TMENDRSCAN");
        }
        if ((n & 0x20000000) != 0) {
            stringBuffer.append("|XAResource.TMFAIL");
        }
        if ((n & 0x200000) != 0) {
            stringBuffer.append("|XAResource.TMJOIN");
        }
        if ((n & 0x40000000) != 0) {
            stringBuffer.append("|XAResource.TMONEPHASE");
        }
        if ((n & 0x8000000) != 0) {
            stringBuffer.append("|XAResource.TMRESUME");
        }
        if ((n & 0x1000000) != 0) {
            stringBuffer.append("|XAResource.TMSTARTRSCAN");
        }
        if ((n & 0x4000000) != 0) {
            stringBuffer.append("|XAResource.TMSUCCESS");
        }
        if ((n & 0x2000000) != 0) {
            stringBuffer.append("|XAResource.TMSUSPEND");
        }
        if ((n & 3) != 0) {
            stringBuffer.append("|XAResource.XA_RDONLY");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("|XAResource.TMNOFLAGS");
        }
        return stringBuffer.toString().substring(1);
    }

    private void checkOpen() throws XAException {
        if (this.conn == null) {
            this.getTrace().debug("conn==null");
            throw new XAException(-3);
        }
    }

    static {
        Driver.load();
    }
}

