/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

public class IndexType {
    private boolean isPrimaryKey;
    private boolean isPersistent;
    private boolean isUnique;
    private boolean isHash;
    private boolean isScan;
    private boolean belongsToConstraint;

    public static IndexType createPrimaryKey(boolean bl, boolean bl2) {
        IndexType indexType = new IndexType();
        indexType.isPrimaryKey = true;
        indexType.isPersistent = bl;
        indexType.isHash = bl2;
        indexType.isUnique = true;
        return indexType;
    }

    public static IndexType createUnique(boolean bl, boolean bl2) {
        IndexType indexType = new IndexType();
        indexType.isUnique = true;
        indexType.isPersistent = bl;
        indexType.isHash = bl2;
        return indexType;
    }

    public static IndexType createNonUnique(boolean bl) {
        IndexType indexType = new IndexType();
        indexType.isPersistent = bl;
        return indexType;
    }

    public static IndexType createScan(boolean bl) {
        IndexType indexType = new IndexType();
        indexType.isPersistent = bl;
        indexType.isScan = true;
        return indexType;
    }

    public void setBelongsToConstraint(boolean bl) {
        this.belongsToConstraint = bl;
    }

    public boolean belongsToConstraint() {
        return this.belongsToConstraint;
    }

    public boolean isHash() {
        return this.isHash;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isPrimaryKey) {
            stringBuffer.append("PRIMARY KEY");
            if (this.isHash) {
                stringBuffer.append(" HASH");
            }
        } else {
            if (this.isUnique) {
                stringBuffer.append("UNIQUE ");
            }
            if (this.isHash) {
                stringBuffer.append("HASH ");
            }
            stringBuffer.append("INDEX");
        }
        return stringBuffer.toString();
    }

    public boolean isScan() {
        return this.isScan;
    }
}

