/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class Parameter
extends Expression
implements ParameterInterface {
    private Value value;
    private int index;

    public Parameter(int n) {
        this.index = n;
    }

    public String getSQL() {
        return "?" + (this.index + 1);
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Value getParamValue() throws SQLException {
        if (this.value == null) {
            return ValueNull.INSTANCE;
        }
        return this.value;
    }

    public Value getValue(Session session) throws SQLException {
        return this.getParamValue();
    }

    public int getType() {
        return this.value == null ? -1 : this.value.getType();
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
    }

    public void checkMapped() {
    }

    public void checkSet() throws SQLException {
        if (this.value == null) {
            throw Message.getSQLException(90012, "#" + (this.index + 1));
        }
    }

    public Expression optimize(Session session) {
        return this;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isValueSet() {
        return this.value != null;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    public int getScale() {
        return this.value == null ? 0 : this.value.getScale();
    }

    public long getPrecision() {
        return this.value == null ? 0L : this.value.getPrecision();
    }

    public int getDisplaySize() {
        return this.value == null ? 0 : this.value.getDisplaySize();
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.type) {
            case 1: {
                return true;
            }
            case 2: 
            case 5: {
                return true;
            }
            case 0: {
                return this.value != null;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        throw Message.getInternalError("type=" + expressionVisitor.type);
    }

    public int getCost() {
        return 0;
    }

    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }
}

