/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionInSelect
extends Condition {
    private Database database;
    private Expression left;
    private Query query;
    private boolean all;
    private int compareType;
    private int queryLevel;

    public ConditionInSelect(Database database, Expression expression, Query query, boolean bl, int n) {
        this.database = database;
        this.left = expression;
        this.query = query;
        this.all = bl;
        this.compareType = n;
    }

    public Value getValue(Session session) throws SQLException {
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        this.query.setSession(session);
        LocalResult localResult = this.query.query(0);
        session.addTemporaryResult(localResult);
        boolean bl = false;
        boolean bl2 = this.all;
        while (localResult.next()) {
            boolean bl3;
            Value value2 = localResult.currentRow()[0];
            if (value2 == ValueNull.INSTANCE) {
                bl3 = false;
                bl = true;
            } else {
                bl3 = Comparison.compareNotNull(this.database, value, value2, this.compareType);
            }
            if (!bl3 && this.all) {
                bl2 = false;
                break;
            }
            if (!bl3 || this.all) continue;
            bl2 = true;
            break;
        }
        if (!bl2 && bl) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl2);
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        this.left.mapColumns(columnResolver, n);
        this.query.mapColumns(columnResolver, n + 1);
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    public Expression optimize(Session session) throws SQLException {
        this.left = this.left.optimize(session);
        if (this.left == ValueExpression.NULL) {
            return this.left;
        }
        this.query.prepare();
        if (this.query.getColumnCount() != 1) {
            throw Message.getSQLException(90052);
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.query.setEvaluatable(tableFilter, bl);
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.left.getSQL());
        stringBuffer.append(" IN(");
        stringBuffer.append(this.query.getPlanSQL());
        stringBuffer.append("))");
        return stringBuffer.toString();
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.query.isEverything(expressionVisitor);
    }

    public int getCost() {
        return this.left.getCost() + 10 + (int)(10.0 * this.query.getCost());
    }

    public Expression optimizeInJoin(Session session, Select select) throws SQLException {
        if (this.all || this.compareType != 0) {
            return this;
        }
        if (!this.query.isEverything(3)) {
            return this;
        }
        String string = this.query.getFirstColumnAlias(session);
        this.query.setDistinct(true);
        if (string == null) {
            return this;
        }
        TableView tableView = TableView.createTempView(session, session.getUser(), this.query);
        TableFilter tableFilter = new TableFilter(session, tableView, tableView.getName(), false, select);
        select.addTableFilter(tableFilter, true);
        ExpressionColumn expressionColumn = new ExpressionColumn(session.getDatabase(), null, tableView.getName(), string);
        Comparison comparison = new Comparison(session, 0, this.left, expressionColumn);
        comparison.mapColumns(tableFilter, 0);
        tableFilter.addFilterCondition(comparison, true);
        return ValueExpression.get(ValueBoolean.get(true));
    }
}

