/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constant;

public class SysProperties {
    public static final String H2_MAX_QUERY_TIMEOUT = "h2.maxQueryTimeout";
    public static final String H2_LOG_DELETE_DELAY = "h2.logDeleteDelay";
    public static final String H2_COLLATOR_CACHE_SIZE = "h2.collatorCacheSize";
    public static final String FILE_ENCODING = SysProperties.getStringSetting("file.encoding", "Cp1252");
    public static final String FILE_SEPARATOR = SysProperties.getStringSetting("file.separator", "/");
    public static final String LINE_SEPARATOR = SysProperties.getStringSetting("line.separator", "\n");
    public static final String USER_HOME = SysProperties.getStringSetting("user.home", "");
    public static final boolean ALIAS_COLUMN_NAME = SysProperties.getBooleanSetting("h2.aliasColumnName", false);
    public static final boolean ALLOW_BIG_DECIMAL_EXTENSIONS = SysProperties.getBooleanSetting("h2.allowBigDecimalExtensions", false);
    public static final String ALLOWED_CLASSES = SysProperties.getStringSetting("h2.allowedClasses", "*");
    public static final boolean ENABLE_ANONYMOUS_SSL = SysProperties.getBooleanSetting("h2.enableAnonymousSSL", true);
    public static final String BIND_ADDRESS = SysProperties.getStringSetting("h2.bindAddress", null);
    public static final int CACHE_SIZE_DEFAULT = SysProperties.getIntSetting("h2.cacheSizeDefault", 16384);
    public static final int CACHE_SIZE_INDEX_SHIFT = SysProperties.getIntSetting("h2.cacheSizeIndexShift", 3);
    public static final int CACHE_SIZE_INDEX_DEFAULT = CACHE_SIZE_DEFAULT >> CACHE_SIZE_INDEX_SHIFT;
    public static final boolean CHECK = SysProperties.getBooleanSetting("h2.check", true);
    public static final boolean CHECK2 = SysProperties.getBooleanSetting("h2.check2", false);
    public static final String CLIENT_TRACE_DIRECTORY = SysProperties.getStringSetting("h2.clientTraceDirectory", "trace.db/");
    public static final int DEFAULT_MAX_OPERATION_MEMORY = SysProperties.getIntSetting("h2.defaultMaxOperationMemory", 100000);
    public static final int DATASOURCE_TRACE_LEVEL = SysProperties.getIntSetting("h2.dataSourceTraceLevel", 1);
    public static final int DEFAULT_MAX_MEMORY_UNDO = SysProperties.getIntSetting("h2.defaultMaxMemoryUndo", 100000);
    public static final int DEFAULT_LOCK_MODE = SysProperties.getIntSetting("h2.defaultLockMode", 3);
    public static final int DELAY_WRONG_PASSWORD_MIN = SysProperties.getIntSetting("h2.delayWrongPasswordMin", 250);
    public static final int DELAY_WRONG_PASSWORD_MAX = SysProperties.getIntSetting("h2.delayWrongPasswordMax", 4000);
    public static final int EMERGENCY_SPACE_INITIAL = SysProperties.getIntSetting("h2.emergencySpaceInitial", 262144);
    public static final int EMERGENCY_SPACE_MIN = SysProperties.getIntSetting("h2.emergencySpaceMin", 65536);
    public static boolean lobCloseBetweenReads = SysProperties.getBooleanSetting("h2.lobCloseBetweenReads", false);
    public static final boolean LOB_FILES_IN_DIRECTORIES = SysProperties.getBooleanSetting("h2.lobFilesInDirectories", false);
    public static final int LOB_FILES_PER_DIRECTORY = SysProperties.getIntSetting("h2.lobFilesPerDirectory", 256);
    public static final boolean LOG_ALL_ERRORS = SysProperties.getBooleanSetting("h2.logAllErrors", false);
    public static final String LOG_ALL_ERRORS_FILE = SysProperties.getStringSetting("h2.logAllErrorsFile", "h2errors.txt");
    public static final int MAX_FILE_RETRY = Math.max(1, SysProperties.getIntSetting("h2.maxFileRetry", 16));
    public static final int MAX_MEMORY_ROWS_DISTINCT = SysProperties.getIntSetting("h2.maxMemoryRowsDistinct", Integer.MAX_VALUE);
    public static final int MAX_QUERY_TIMEOUT = SysProperties.getIntSetting("h2.maxQueryTimeout", 0);
    public static final int MIN_COLUMN_NAME_MAP = SysProperties.getIntSetting("h2.minColumnNameMap", 3);
    public static final int MIN_WRITE_DELAY = SysProperties.getIntSetting("h2.minWriteDelay", 5);
    public static final boolean OBJECT_CACHE = SysProperties.getBooleanSetting("h2.objectCache", true);
    public static final int OBJECT_CACHE_MAX_PER_ELEMENT_SIZE = SysProperties.getIntSetting("h2.objectCacheMaxPerElementSize", 4096);
    public static final int OBJECT_CACHE_SIZE = SysProperties.getIntSetting("h2.objectCacheSize", 1024);
    public static final boolean OLD_COMMAND_LINE_OPTIONS = SysProperties.getBooleanSetting("h2.oldCommandLineOptions", true);
    public static final boolean OPTIMIZE_DROP_DEPENDENCIES = SysProperties.getBooleanSetting("h2.optimizeDropDependencies", true);
    public static final boolean OPTIMIZE_DISTINCT = SysProperties.getBooleanSetting("h2.optimizeDistinct", true);
    public static final boolean OPTIMIZE_EVALUATABLE_SUBQUERIES = SysProperties.getBooleanSetting("h2.optimizeEvaluatableSubqueries", true);
    public static final boolean OPTIMIZE_GROUP_SORTED = SysProperties.getBooleanSetting("h2.optimizeGroupSorted", false);
    public static final boolean OPTIMIZE_IN = SysProperties.getBooleanSetting("h2.optimizeIn", true);
    public static final boolean OPTIMIZE_IN_JOIN = SysProperties.getBooleanSetting("h2.optimizeInJoin", false);
    public static final boolean OPTIMIZE_MIN_MAX = SysProperties.getBooleanSetting("h2.optimizeMinMax", true);
    public static final boolean OPTIMIZE_SUBQUERY_CACHE = SysProperties.getBooleanSetting("h2.optimizeSubqueryCache", true);
    public static final boolean OPTIMIZE_NOT = SysProperties.getBooleanSetting("h2.optimizeNot", true);
    public static final boolean OPTIMIZE_TWO_EQUALS = SysProperties.getBooleanSetting("h2.optimizeTwoEquals", true);
    public static final boolean OVERFLOW_EXCEPTIONS = SysProperties.getBooleanSetting("h2.overflowExceptions", true);
    public static final boolean RECOMPILE_ALWAYS = SysProperties.getBooleanSetting("h2.recompileAlways", false);
    public static final int REDO_BUFFER_SIZE = SysProperties.getIntSetting("h2.redoBufferSize", 262144);
    public static final int REUSE_SPACE_AFTER = SysProperties.getIntSetting("h2.reuseSpaceAfter", 32);
    public static final boolean REUSE_SPACE_QUICKLY = SysProperties.getBooleanSetting("h2.reuseSpaceQuickly", true);
    public static boolean runFinalize = SysProperties.getBooleanSetting("h2.runFinalize", true);
    public static String scriptDirectory = SysProperties.getStringSetting("h2.scriptDirectory", "");
    public static final int SERVER_CACHED_OBJECTS = SysProperties.getIntSetting("h2.serverCachedObjects", 64);
    public static final int SERVER_RESULT_SET_FETCH_SIZE = SysProperties.getIntSetting("h2.serverResultSetFetchSize", 100);
    public static final boolean SORT_NULLS_HIGH = SysProperties.getBooleanSetting("h2.sortNullsHigh", false);
    public static final boolean TRACE_IO = SysProperties.getBooleanSetting("h2.traceIO", false);
    public static final int LARGE_RESULT_BUFFER_SIZE = SysProperties.getIntSetting("h2.largeResultBufferSize", 4096);
    public static final int COLLATOR_CACHE_SIZE = SysProperties.getCollatorCacheSize();
    private static String baseDir = SysProperties.getStringSetting("h2.baseDir", null);

    private static boolean getBooleanSetting(String string, boolean bl) {
        String string2 = SysProperties.getProperty(string);
        if (string2 != null) {
            try {
                return Boolean.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }

    private static String getProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static String getStringSetting(String string, String string2) {
        String string3 = SysProperties.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    public static int getIntSetting(String string, int n) {
        String string2 = SysProperties.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static void setBaseDir(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        baseDir = string;
    }

    public static String getBaseDir() {
        return baseDir;
    }

    public static int getMaxQueryTimeout() {
        return SysProperties.getIntSetting(H2_MAX_QUERY_TIMEOUT, 0);
    }

    public static int getLogFileDeleteDelay() {
        return SysProperties.getIntSetting(H2_LOG_DELETE_DELAY, 0);
    }

    public static int getCollatorCacheSize() {
        return SysProperties.getIntSetting(H2_COLLATOR_CACHE_SIZE, 32000);
    }
}

