/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.server.web.ConnectionInfo;
import org.h2.util.ClassUtils;
import org.h2.util.FileUtils;
import org.h2.util.JdbcDriverUtils;
import org.h2.util.JdbcUtils;

public class Shell {
    private Connection conn;
    private Statement stat;
    private PrintStream out = System.out;
    private boolean listMode;
    private int maxColumnSize = 100;
    private char boxVertical = (char)124;

    public static void main(String[] args) throws SQLException {
        new Shell().run(args);
    }

    private void showUsage() {
        this.out.println("An interactive command line database tool.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-url <url>]       The database URL\n" + " [-user <user>]     The user name\n" + " [-password <pwd>]  The password\n" + " [-driver <class>]  The JDBC driver class to use (not required in most cases)");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    private void run(String[] args) throws SQLException {
        String url = null;
        String user = "";
        String password = "";
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-url")) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                password = args[++i];
                continue;
            }
            if (args[i].equals("-driver")) {
                String driver = args[++i];
                try {
                    ClassUtils.loadUserClass(driver);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw Message.convert(e);
                }
            }
            this.out.println("Unsupported option: " + args[i]);
            this.showUsage();
            return;
        }
        if (url != null) {
            Driver.load();
            this.conn = DriverManager.getConnection(url, user, password);
            this.stat = this.conn.createStatement();
        }
        this.promptLoop();
    }

    private void showHelp() {
        this.out.println("Commands are case insensitive; SQL statements end with ';'");
        this.out.println("help or ?      Display this help");
        this.out.println("list           Toggle result list mode");
        this.out.println("maxwidth       Set maximum column width (default is 100)");
        this.out.println("show           List all tables");
        this.out.println("describe       Describe a table");
        this.out.println("quit or exit   Close the connection and exit");
        this.out.println();
    }

    private void promptLoop() {
        this.out.println();
        this.out.println("Welcome to H2 Shell " + Constants.getVersion());
        this.out.println("Exit with Ctrl+C");
        if (this.conn != null) {
            this.showHelp();
        }
        String statement = null;
        block12: while (true) {
            try {
                while (true) {
                    String upper;
                    if (this.conn == null) {
                        this.connect();
                        this.showHelp();
                    }
                    if (statement == null) {
                        this.out.print("sql> ");
                    } else {
                        this.out.print("...> ");
                    }
                    String line = this.readLine();
                    if (line == null) break block12;
                    if ((line = line.trim()).length() == 0) continue;
                    boolean end = line.endsWith(";");
                    if (end) {
                        line = line.substring(0, line.length() - 1).trim();
                    }
                    if ("EXIT".equals(upper = line.toUpperCase()) || "QUIT".equals(upper)) break block12;
                    if ("HELP".equals(upper) || "?".equals(upper)) {
                        this.showHelp();
                        continue;
                    }
                    if ("LIST".equals(upper)) {
                        this.listMode = !this.listMode;
                        this.out.println("Result list mode is now " + (this.listMode ? "on" : "off"));
                        continue;
                    }
                    if (upper.startsWith("DESCRIBE")) {
                        String tableName = upper.substring("DESCRIBE".length()).trim();
                        if (tableName.length() == 0) {
                            this.out.println("Usage: describe <table name>");
                            continue;
                        }
                        try {
                            PreparedStatement prep = this.conn.prepareStatement("SELECT CAST(COLUMN_NAME AS VARCHAR(32)) \"Column Name\", CAST(TYPE_NAME AS VARCHAR(14)) \"Type\", NUMERIC_PRECISION \"Precision\", CAST(IS_NULLABLE AS VARCHAR(8)) \"Nullable\", CAST(COLUMN_DEFAULT AS VARCHAR(20)) \"Default\" FROM INFORMATION_SCHEMA.COLUMNS WHERE UPPER(TABLE_NAME)=? ORDER BY ORDINAL_POSITION");
                            prep.setString(1, tableName.toUpperCase());
                            ResultSet rs = prep.executeQuery();
                            this.printResult(rs, false);
                            continue block12;
                        }
                        catch (SQLException e) {
                            this.out.println("Exception: " + e.toString());
                            e.printStackTrace();
                            continue;
                        }
                    }
                    if (upper.startsWith("SHOW")) {
                        try {
                            ResultSet rs = this.stat.executeQuery("SELECT CAST(TABLE_SCHEMA AS VARCHAR(32)) \"Schema\", TABLE_NAME \"Table Name\" FROM INFORMATION_SCHEMA.TABLES ORDER BY TABLE_SCHEMA, TABLE_NAME");
                            this.printResult(rs, false);
                            continue block12;
                        }
                        catch (SQLException e) {
                            this.out.println("Exception: " + e.toString());
                            e.printStackTrace();
                            continue;
                        }
                    }
                    if (upper.startsWith("MAXWIDTH")) {
                        upper = upper.substring("MAXWIDTH".length()).trim();
                        try {
                            this.maxColumnSize = Integer.parseInt(upper);
                        }
                        catch (Exception e) {
                            this.out.println("Usage: maxwidth <integer value>");
                        }
                        this.out.println("Maximum column width is now " + this.maxColumnSize);
                        continue;
                    }
                    statement = statement == null ? line : statement + " " + line;
                    if (!end) continue;
                    this.execute(statement, this.listMode);
                    statement = null;
                }
            }
            catch (SQLException e) {
                this.out.println("SQL Exception: " + e.getMessage());
                statement = null;
                continue;
            }
            catch (IOException e) {
                this.out.println(e.getMessage());
            }
            catch (Exception e) {
                this.out.println("Exception: " + e.toString());
                e.printStackTrace();
            }
            break;
        }
        if (this.conn != null) {
            try {
                this.conn.close();
                this.out.println("Connection closed");
            }
            catch (SQLException e) {
                this.out.println("SQL Exception:");
                e.printStackTrace();
            }
        }
    }

    private void connect() throws IOException, SQLException {
        String propertiesFileName = FileUtils.getFileInUserHome(".h2.server.properties");
        String url = "jdbc:h2:~/test";
        String user = "sa";
        String driver = null;
        try {
            String d;
            Properties prop = FileUtils.loadProperties(propertiesFileName);
            String data = null;
            int i = 0;
            while ((d = prop.getProperty(String.valueOf(i))) != null) {
                data = d;
                ++i;
            }
            if (data != null) {
                ConnectionInfo info = new ConnectionInfo(data);
                url = info.url;
                user = info.user;
                driver = info.driver;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.out.println("[Enter]   " + url);
        this.out.print("URL       ");
        url = this.readLine(url);
        if (driver == null) {
            driver = JdbcDriverUtils.getDriver(url);
        }
        if (driver != null) {
            this.out.println("[Enter]   " + driver);
        }
        this.out.print("Driver    ");
        driver = this.readLine(driver);
        this.out.println("[Enter]   " + user);
        this.out.print("User      ");
        user = this.readLine(user);
        this.out.println("[Enter]   Hide");
        this.out.print("Password  ");
        String password = this.readLine();
        if (password.length() == 0) {
            password = this.readPassword();
        }
        this.conn = JdbcUtils.getConnection(driver, url, user, password);
        this.stat = this.conn.createStatement();
        this.out.println("Connected");
    }

    private String readPassword() throws IOException {
        class PasswordHider
        extends Thread {
            volatile boolean stop;

            PasswordHider() {
            }

            public void run() {
                while (!this.stop) {
                    Shell.this.out.print("\b\b><");
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        PasswordHider thread = new PasswordHider();
        thread.start();
        this.out.print("Password  > ");
        String p = this.readLine();
        thread.stop = true;
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.out.print("\b\b");
        return p;
    }

    private String readLine(String defaultValue) throws IOException {
        String s = this.readLine();
        return s.length() == 0 ? defaultValue : s;
    }

    private String readLine() throws IOException {
        String line = new BufferedReader(new InputStreamReader(System.in)).readLine();
        if (line == null) {
            throw new IOException("Aborted");
        }
        return line;
    }

    private void execute(String sql, boolean listMode) throws SQLException {
        boolean result;
        long time = System.currentTimeMillis();
        try {
            result = this.stat.execute(sql);
        }
        catch (SQLException e) {
            this.out.println("Error: " + e.toString());
            return;
        }
        try {
            if (result) {
                ResultSet rs = this.stat.getResultSet();
                int rowCount = this.printResult(rs, listMode);
                time = System.currentTimeMillis() - time;
                this.out.println("(" + rowCount + (rowCount == 1 ? " row, " : " rows, ") + time + " ms)");
            } else {
                int updateCount = this.stat.getUpdateCount();
                time = System.currentTimeMillis() - time;
                this.out.println("(Update count: " + updateCount + ", " + time + " ms)");
            }
        }
        catch (SQLException e) {
            this.out.println("Error: " + e.toString());
            e.printStackTrace();
        }
    }

    private int printResult(ResultSet rs, boolean listMode) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int longest = 0;
        int len = meta.getColumnCount();
        String[] columns = new String[len];
        int[] columnSizes = new int[len];
        int total = 0;
        for (int i = 0; i < len; ++i) {
            String s = meta.getColumnLabel(i + 1);
            int l = s.length();
            if (!listMode) {
                l = Math.max(l, meta.getColumnDisplaySize(i + 1));
                l = Math.min(this.maxColumnSize, l);
            }
            if (s.length() > l) {
                s = s.substring(0, l);
            }
            columns[i] = s;
            columnSizes[i] = l;
            longest = Math.max(longest, l);
            total += l;
        }
        StringBuffer buff = new StringBuffer();
        if (!listMode) {
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    buff.append(this.boxVertical);
                }
                String s = columns[i];
                buff.append(s);
                if (i >= len - 1) continue;
                for (int j = s.length(); j < columnSizes[i]; ++j) {
                    buff.append(' ');
                }
            }
            this.out.println(buff.toString());
        }
        int rowCount = 0;
        while (rs.next()) {
            int i;
            ++rowCount;
            buff.setLength(0);
            if (listMode) {
                if (rowCount > 1) {
                    this.out.println();
                }
                for (i = 0; i < len; ++i) {
                    if (i > 0) {
                        buff.append('\n');
                    }
                    String label = columns[i];
                    buff.append(label);
                    for (int j = label.length(); j < longest; ++j) {
                        buff.append(' ');
                    }
                    buff.append(": ");
                    buff.append(rs.getString(i + 1));
                }
            } else {
                for (i = 0; i < len; ++i) {
                    String s;
                    if (i > 0) {
                        buff.append(this.boxVertical);
                    }
                    if ((s = rs.getString(i + 1)) == null) {
                        s = "null";
                    }
                    int m = columnSizes[i];
                    if (!listMode && s.length() > m) {
                        s = s.substring(0, m);
                    }
                    buff.append(s);
                    if (i >= len - 1) continue;
                    for (int j = s.length(); j < m; ++j) {
                        buff.append(' ');
                    }
                }
            }
            this.out.println(buff.toString());
        }
        if (rowCount == 0 && listMode) {
            for (int i = 0; i < len; ++i) {
                String label = columns[i];
                buff.append(label);
                buff.append('\n');
            }
            this.out.println(buff.toString());
        }
        return rowCount;
    }
}

