/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.server.ShutdownHandler;
import org.h2.tools.Server;
import org.h2.util.IOUtils;
import org.h2.util.StartBrowser;

public class Console
implements ActionListener,
MouseListener,
ShutdownHandler {
    private Font font;
    private Image icon16;
    private Image icon24;
    private Frame frame;
    private Button startBrowser;
    private static final int EXIT_ERROR = 1;
    private Server web;
    private Server tcp;
    private Server pg;
    private boolean isWindows;
    static /* synthetic */ Class class$org$h2$tools$Console;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$PopupMenu;
    static /* synthetic */ Class class$java$awt$event$MouseListener;

    public static void main(String[] args) throws Exception {
        int exitCode = new Console().run(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    private int run(String[] args) {
        this.isWindows = SysProperties.getStringSetting("os.name", "").startsWith("Windows");
        int exitCode = 0;
        try {
            this.web = Server.createWebServer(args);
            this.web.setShutdownHandler(this);
            this.web.start();
        }
        catch (SQLException e) {
            if (this.web == null) {
                e.printStackTrace();
            }
            System.out.println(this.web.getStatus());
        }
        try {
            this.tcp = Server.createTcpServer(args);
            this.tcp.start();
        }
        catch (SQLException e) {
            if (this.tcp == null) {
                e.printStackTrace();
            }
            System.out.println(this.tcp.getStatus());
        }
        try {
            this.pg = Server.createPgServer(args);
            this.pg.start();
        }
        catch (SQLException e) {
            if (this.pg == null) {
                e.printStackTrace();
            }
            System.out.println(this.pg.getStatus());
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.font = this.isWindows ? new Font("Dialog", 0, 11) : new Font("Dialog", 0, 12);
            try {
                this.icon16 = this.loadImage("/org/h2/res/h2.png");
                this.icon24 = this.loadImage("/org/h2/res/h2b.png");
                if (!this.createTrayIcon()) {
                    this.showWindow(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StartBrowser.openURL(this.web.getURL());
        if (!this.web.isRunning()) {
            exitCode = 1;
        }
        return exitCode;
    }

    private Image loadImage(String name) throws IOException {
        InputStream in = (class$org$h2$tools$Console == null ? (class$org$h2$tools$Console = Console.class$("org.h2.tools.Console")) : class$org$h2$tools$Console).getResourceAsStream(name);
        if (in != null) {
            byte[] imageData = IOUtils.readBytesAndClose(in, -1);
            return Toolkit.getDefaultToolkit().createImage(imageData);
        }
        return null;
    }

    public void shutdown() {
        this.stopAll();
    }

    private void stopAll() {
        if (this.web != null && this.web.isRunning()) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning()) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning()) {
            this.pg.stop();
            this.pg = null;
        }
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        System.exit(0);
    }

    private boolean createTrayIcon() {
        try {
            Boolean supported = (Boolean)Class.forName("java.awt.SystemTray").getMethod("isSupported", new Class[0]).invoke(null, new Object[0]);
            if (!supported.booleanValue()) {
                return false;
            }
            PopupMenu menuConsole = new PopupMenu();
            MenuItem itemConsole = new MenuItem("H2 Console");
            itemConsole.setActionCommand("console");
            itemConsole.addActionListener(this);
            itemConsole.setFont(this.font);
            menuConsole.add(itemConsole);
            MenuItem itemStatus = new MenuItem("Status");
            itemStatus.setActionCommand("status");
            itemStatus.addActionListener(this);
            itemStatus.setFont(this.font);
            menuConsole.add(itemStatus);
            MenuItem itemExit = new MenuItem("Exit");
            itemExit.setFont(this.font);
            itemExit.setActionCommand("exit");
            itemExit.addActionListener(this);
            menuConsole.add(itemExit);
            Object tray = Class.forName("java.awt.SystemTray").getMethod("getSystemTray", new Class[0]).invoke(null, new Object[0]);
            Dimension d = (Dimension)Class.forName("java.awt.SystemTray").getMethod("getTrayIconSize", new Class[0]).invoke(tray, new Object[0]);
            Image icon = d.width >= 24 && d.height >= 24 ? this.icon24 : this.icon16;
            Object trayIcon = Class.forName("java.awt.TrayIcon").getConstructor(class$java$awt$Image == null ? (class$java$awt$Image = Console.class$("java.awt.Image")) : class$java$awt$Image, class$java$lang$String == null ? (class$java$lang$String = Console.class$("java.lang.String")) : class$java$lang$String, class$java$awt$PopupMenu == null ? (class$java$awt$PopupMenu = Console.class$("java.awt.PopupMenu")) : class$java$awt$PopupMenu).newInstance(icon, "H2 Database Engine", menuConsole);
            trayIcon.getClass().getMethod("addMouseListener", class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = Console.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener).invoke(trayIcon, this);
            tray.getClass().getMethod("add", Class.forName("java.awt.TrayIcon")).invoke(tray, trayIcon);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void showWindow(final boolean exit) {
        this.frame = new Frame("H2 Console");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                if (exit) {
                    Console.this.stopAll();
                } else {
                    Console.this.frame.dispose();
                }
            }
        });
        if (this.icon16 != null) {
            this.frame.setIconImage(this.icon16);
        }
        this.frame.setResizable(false);
        this.frame.setBackground(SystemColor.control);
        GridBagLayout layout = new GridBagLayout();
        this.frame.setLayout(layout);
        Panel mainPanel = new Panel(layout);
        GridBagConstraints constraintsPanel = new GridBagConstraints();
        constraintsPanel.gridx = 0;
        constraintsPanel.weightx = 1.0;
        constraintsPanel.weighty = 1.0;
        constraintsPanel.fill = 1;
        constraintsPanel.insets = new Insets(0, 10, 0, 10);
        constraintsPanel.gridy = 0;
        GridBagConstraints constraintsButton = new GridBagConstraints();
        constraintsButton.gridx = 0;
        constraintsButton.gridwidth = 2;
        constraintsButton.insets = new Insets(10, 0, 0, 0);
        constraintsButton.gridy = 1;
        constraintsButton.anchor = 13;
        GridBagConstraints constraintsTextField = new GridBagConstraints();
        constraintsTextField.fill = 2;
        constraintsTextField.gridy = 0;
        constraintsTextField.weightx = 1.0;
        constraintsTextField.insets = new Insets(0, 5, 0, 0);
        constraintsTextField.gridx = 1;
        GridBagConstraints constraintsLabel = new GridBagConstraints();
        constraintsLabel.gridx = 0;
        constraintsLabel.gridy = 0;
        Label label = new Label("H2 Console URL:", 0);
        label.setFont(this.font);
        mainPanel.add((Component)label, constraintsLabel);
        TextField text = new TextField();
        text.setEditable(false);
        text.setFont(this.font);
        text.setText(this.web.getURL());
        if (this.isWindows) {
            text.setFocusable(false);
        }
        mainPanel.add((Component)text, constraintsTextField);
        this.startBrowser = new Button("Start Browser");
        this.startBrowser.setFocusable(false);
        this.startBrowser.setActionCommand("console");
        this.startBrowser.addActionListener(this);
        this.startBrowser.setFont(this.font);
        mainPanel.add((Component)this.startBrowser, constraintsButton);
        this.frame.add((Component)mainPanel, constraintsPanel);
        int width = 300;
        int height = 120;
        this.frame.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
        try {
            this.frame.setVisible(true);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private void startBrowser() {
        if (this.web != null) {
            StartBrowser.openURL(this.web.getURL());
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("exit".equals(command)) {
            this.stopAll();
        } else if ("console".equals(command)) {
            this.startBrowser();
        } else if ("status".equals(command)) {
            this.showWindow(false);
        } else if (this.startBrowser == e.getSource()) {
            this.startBrowser();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.startBrowser();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

