/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashSet;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BtreeIndex;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinearHashIndex;
import org.h2.index.MultiVersionIndex;
import org.h2.index.ScanIndex;
import org.h2.index.TreeIndex;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;

public class TableData
extends Table
implements RecordReader {
    private final boolean clustered;
    private ScanIndex scanIndex;
    private long rowCount;
    private Session lockExclusive;
    private HashSet lockShared = new HashSet();
    private Trace traceLock;
    private boolean globalTemporary;
    private final ObjectArray indexes = new ObjectArray();
    private long lastModificationId;
    private boolean containsLargeObject;

    public TableData(Schema schema, String tableName, int id, ObjectArray columns, boolean persistent, boolean clustered) throws SQLException {
        super(schema, id, tableName, persistent);
        Object[] cols = new Column[columns.size()];
        columns.toArray(cols);
        this.setColumns((Column[])cols);
        this.clustered = clustered;
        if (!clustered) {
            this.scanIndex = new ScanIndex(this, id, IndexColumn.wrap((Column[])cols), IndexType.createScan(persistent));
            this.indexes.add(this.scanIndex);
        }
        for (int i = 0; i < cols.length; ++i) {
            if (!DataType.isLargeObject(((Column)cols[i]).getType())) continue;
            this.containsLargeObject = true;
            this.memoryPerRow = -1;
        }
        this.traceLock = this.database.getTrace("lock");
    }

    public void close(Session session) throws SQLException {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Index index = (Index)this.indexes.get(i);
            index.close(session);
        }
    }

    public Row getRow(Session session, int key) throws SQLException {
        return this.scanIndex.getRow(session, key);
    }

    public void addRow(Session session, Row row) throws SQLException {
        int i = 0;
        this.lastModificationId = this.database.getNextModificationDataId();
        if (this.database.isMultiVersion()) {
            row.setSessionId(session.getId());
        }
        try {
            while (i < this.indexes.size()) {
                Index index = (Index)this.indexes.get(i);
                index.add(session, row);
                this.checkRowCount(session, index, 1);
                ++i;
            }
            ++this.rowCount;
        }
        catch (Throwable e) {
            while (--i >= 0) {
                Index index = (Index)this.indexes.get(i);
                index.remove(session, row);
                this.checkRowCount(session, index, 0);
            }
            throw Message.convert(e);
        }
    }

    private void checkRowCount(Session session, Index index, int offset) {
        long rc;
        if (SysProperties.CHECK && !this.database.isMultiVersion() && (rc = index.getRowCount(session)) != this.rowCount + (long)offset) {
            throw Message.getInternalError("rowCount expected " + (this.rowCount + (long)offset) + " got " + rc + " " + this.getName() + "." + index.getName());
        }
    }

    public Index getScanIndex(Session session) {
        return (Index)this.indexes.get(0);
    }

    public Index getUniqueIndex() {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Index idx = (Index)this.indexes.get(i);
            if (!idx.getIndexType().isUnique()) continue;
            return idx;
        }
        return null;
    }

    public ObjectArray getIndexes() {
        return this.indexes;
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, int headPos, String indexComment) throws SQLException {
        if (indexType.isPrimaryKey()) {
            for (int i = 0; i < cols.length; ++i) {
                Column column = cols[i].column;
                if (column.getNullable()) {
                    throw Message.getSQLException(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        Index index = this.isPersistent() && indexType.isPersistent() ? (indexType.isHash() ? new LinearHashIndex(session, this, indexId, indexName, cols, indexType) : new BtreeIndex(session, this, indexId, indexName, cols, indexType, headPos)) : (indexType.isHash() ? new HashIndex(this, indexId, indexName, cols, indexType) : new TreeIndex(this, indexId, indexName, cols, indexType));
        if (this.database.isMultiVersion()) {
            index = new MultiVersionIndex(index, this);
        }
        if (index.needRebuild() && this.rowCount > 0L) {
            try {
                long remaining;
                Index scan = this.getScanIndex(session);
                long total = remaining = scan.getRowCount(session);
                Cursor cursor = scan.find(session, null, null);
                long i = 0L;
                int bufferSize = 10000;
                ObjectArray buffer = new ObjectArray(bufferSize);
                while (cursor.next()) {
                    this.database.setProgress(1, this.getName(), MathUtils.convertLongToInt(i++), MathUtils.convertLongToInt(total));
                    Row row = cursor.get();
                    buffer.add(row);
                    if (buffer.size() >= bufferSize) {
                        this.addRowsToIndex(session, buffer, index);
                    }
                    --remaining;
                }
                this.addRowsToIndex(session, buffer, index);
                if (SysProperties.CHECK && remaining != 0L) {
                    throw Message.getInternalError("rowcount remaining=" + remaining + " " + this.getName());
                }
            }
            catch (SQLException e) {
                this.getSchema().freeUniqueName(indexName);
                index.remove(session);
                throw e;
            }
        }
        boolean temporary = this.getTemporary();
        index.setTemporary(temporary);
        if (index.getCreateSQL() != null) {
            index.setComment(indexComment);
            this.database.addSchemaObject(session, index);
            if (index.getIndexType().isPersistent() && !this.database.getReadOnly() && !this.database.getLog().containsInDoubtTransactions()) {
                this.database.update(session, index);
            }
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    public boolean canGetRowCount() {
        return true;
    }

    private void addRowsToIndex(Session session, ObjectArray list, Index index) throws SQLException {
        final Index idx = index;
        try {
            list.sort(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Row r1 = (Row)o1;
                    Row r2 = (Row)o2;
                    try {
                        return idx.compareRows(r1, r2);
                    }
                    catch (SQLException e) {
                        throw Message.convertToInternal(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
        for (int i = 0; i < list.size(); ++i) {
            Row row = (Row)list.get(i);
            index.add(session, row);
        }
        list.clear();
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            return this.getScanIndex(session).getRowCount(session);
        }
        return this.rowCount;
    }

    public void removeRow(Session session, Row row) throws SQLException {
        int i;
        this.lastModificationId = this.database.getNextModificationDataId();
        if (this.database.isMultiVersion()) {
            if (row.getDeleted()) {
                throw Message.getSQLException(90131, this.getName());
            }
            int old = row.getSessionId();
            int newId = session.getId();
            if (old == 0) {
                row.setSessionId(newId);
            } else if (old != newId) {
                throw Message.getSQLException(90131, this.getName());
            }
        }
        try {
            for (i = this.indexes.size() - 1; i >= 0; --i) {
                Index index = (Index)this.indexes.get(i);
                index.remove(session, row);
                this.checkRowCount(session, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable e) {
            while (++i < this.indexes.size()) {
                Index index = (Index)this.indexes.get(i);
                index.add(session, row);
                this.checkRowCount(session, index, 0);
            }
            throw Message.convert(e);
        }
    }

    public void truncate(Session session) throws SQLException {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            long rc;
            Index index = (Index)this.indexes.get(i);
            index.truncate(session);
            if (!SysProperties.CHECK || (rc = index.getRowCount(session)) == 0L) continue;
            throw Message.getInternalError("rowCount expected 0 got " + rc);
        }
        this.rowCount = 0L;
    }

    public boolean isLockExclusive(Session s) {
        return this.lockExclusive == s;
    }

    public void lock(Session session, boolean exclusive, boolean force) throws SQLException {
        int lockMode = this.database.getLockMode();
        if (lockMode == 0) {
            return;
        }
        long max = System.currentTimeMillis() + (long)session.getLockTimeout();
        if (!force && this.database.isMultiVersion()) {
            if (exclusive) {
                exclusive = false;
            } else {
                return;
            }
        }
        Database database = this.database;
        synchronized (database) {
            block5: while (true) {
                while (true) {
                    long now;
                    if (this.lockExclusive == session) {
                        return;
                    }
                    if (exclusive) {
                        if (this.lockExclusive == null) {
                            if (this.lockShared.isEmpty()) {
                                this.traceLock(session, exclusive, "added for");
                                session.addLock(this);
                                this.lockExclusive = session;
                                return;
                            }
                            if (this.lockShared.size() == 1 && this.lockShared.contains(session)) {
                                this.traceLock(session, exclusive, "add (upgraded) for ");
                                this.lockExclusive = session;
                                return;
                            }
                        }
                    } else if (this.lockExclusive == null) {
                        if (lockMode == 3 && !this.database.getMultiThreaded() && !this.database.isMultiVersion()) {
                            return;
                        }
                        if (!this.lockShared.contains(session)) {
                            this.traceLock(session, exclusive, "ok");
                            session.addLock(this);
                            this.lockShared.add(session);
                        }
                        return;
                    }
                    if ((now = System.currentTimeMillis()) >= max) {
                        this.traceLock(session, exclusive, "timeout after " + session.getLockTimeout());
                        throw Message.getSQLException(50200, this.getName());
                    }
                    try {
                        this.traceLock(session, exclusive, "waiting for");
                        if (this.database.getLockMode() == 2) {
                            for (int i = 0; i < 20; ++i) {
                                long free = Runtime.getRuntime().freeMemory();
                                System.gc();
                                long free2 = Runtime.getRuntime().freeMemory();
                                if (free == free2) break;
                            }
                        }
                        this.database.wait(max - now);
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private void traceLock(Session session, boolean exclusive, String s) {
        if (this.traceLock.debug()) {
            this.traceLock.debug(session.getId() + " " + (exclusive ? "exclusive write lock" : "shared read lock") + " " + s + " " + this.getName());
        }
    }

    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE ");
        if (this.getTemporary()) {
            if (this.globalTemporary) {
                buff.append("GLOBAL ");
            } else {
                buff.append("LOCAL ");
            }
            buff.append("TEMPORARY ");
        } else if (this.isPersistent()) {
            buff.append("CACHED ");
        } else {
            buff.append("MEMORY ");
        }
        buff.append("TABLE ");
        buff.append(this.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ");
            buff.append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append("(\n    ");
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            if (i > 0) {
                buff.append(",\n    ");
            }
            buff.append(column.getCreateSQL());
        }
        buff.append("\n)");
        return buff.toString();
    }

    public boolean isLockedExclusively() {
        return this.lockExclusive != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Session s) {
        if (this.database != null) {
            this.traceLock(s, this.lockExclusive == s, "unlock");
            if (this.lockExclusive == s) {
                this.lockExclusive = null;
            }
            if (this.lockShared.size() > 0) {
                this.lockShared.remove(s);
            }
            Database database = this.database;
            synchronized (database) {
                if (this.database.getSessionCount() > 1) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public Record read(Session session, DataPage s) throws SQLException {
        int len = s.readInt();
        Value[] data = new Value[len];
        for (int i = 0; i < len; ++i) {
            data[i] = s.readValue();
        }
        Row row = new Row(data, this.memoryPerRow);
        return row;
    }

    public void setRowCount(int count) {
        this.rowCount = count;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = (Index)this.indexes.get(1);
            if (index.getName() == null) continue;
            this.database.removeSchemaObject(session, index);
        }
        if (SysProperties.CHECK) {
            ObjectArray list = this.database.getAllSchemaObjects(1);
            for (int i = 0; i < list.size(); ++i) {
                Index index = (Index)list.get(i);
                if (index.getTable() != this) continue;
                throw Message.getInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.scanIndex = null;
        this.lockExclusive = null;
        this.lockShared = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
    }

    public void checkSupportAlter() throws SQLException {
    }

    public boolean canTruncate() {
        ObjectArray constraints = this.getConstraints();
        for (int i = 0; constraints != null && i < constraints.size(); ++i) {
            ConstraintReferential ref;
            Constraint c = (Constraint)constraints.get(i);
            if (!c.getConstraintType().equals("REFERENTIAL") || (ref = (ConstraintReferential)c).getRefTable() != this) continue;
            return false;
        }
        return true;
    }

    public String getTableType() {
        return "TABLE";
    }

    public void setGlobalTemporary(boolean globalTemporary) {
        this.globalTemporary = globalTemporary;
    }

    public boolean getGlobalTemporary() {
        return this.globalTemporary;
    }

    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }
}

