/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.schema.Constant;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.table.TableLink;
import org.h2.util.ObjectArray;

public class Schema
extends DbObjectBase {
    private User owner;
    private boolean system;
    private HashMap tablesAndViews = new HashMap();
    private HashMap indexes = new HashMap();
    private HashMap sequences = new HashMap();
    private HashMap triggers = new HashMap();
    private HashMap constraints = new HashMap();
    private HashMap constants = new HashMap();
    private HashSet temporaryUniqueNames = new HashSet();

    public Schema(Database database, int id, String schemaName, User owner, boolean system) {
        super(database, id, schemaName, "schema");
        this.owner = owner;
        this.system = system;
    }

    public boolean canDrop() {
        return !this.getName().equals("INFORMATION_SCHEMA") && !this.getName().equals("PUBLIC");
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.getInternalError();
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE SCHEMA ");
        buff.append(this.getSQL());
        buff.append(" AUTHORIZATION ");
        buff.append(this.owner.getSQL());
        return buff.toString();
    }

    public int getType() {
        return 10;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        SchemaObject obj;
        while (this.triggers != null && this.triggers.size() > 0) {
            obj = (TriggerObject)this.triggers.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            obj = (Constraint)this.constraints.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.tablesAndViews != null && this.tablesAndViews.size() > 0) {
            obj = (Table)this.tablesAndViews.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.indexes != null && this.indexes.size() > 0) {
            obj = (Index)this.indexes.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.sequences != null && this.sequences.size() > 0) {
            obj = (Sequence)this.sequences.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.constants != null && this.constants.size() > 0) {
            obj = (Constant)this.constants.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        this.database.removeMeta(session, this.getId());
        this.owner = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
    }

    public User getOwner() {
        return this.owner;
    }

    private HashMap getMap(int type) {
        switch (type) {
            case 0: {
                return this.tablesAndViews;
            }
            case 3: {
                return this.sequences;
            }
            case 1: {
                return this.indexes;
            }
            case 4: {
                return this.triggers;
            }
            case 5: {
                return this.constraints;
            }
            case 11: {
                return this.constants;
            }
        }
        throw Message.getInternalError("type=" + type);
    }

    public void add(SchemaObject obj) throws SQLException {
        if (SysProperties.CHECK && obj.getSchema() != this) {
            throw Message.getInternalError("wrong schema");
        }
        String name = obj.getName();
        HashMap map = this.getMap(obj.getType());
        if (SysProperties.CHECK && map.get(name) != null) {
            throw Message.getInternalError("object already exists");
        }
        map.put(name, obj);
        this.freeUniqueName(name);
    }

    public void rename(SchemaObject obj, String newName) throws SQLException {
        int type = obj.getType();
        HashMap map = this.getMap(type);
        if (SysProperties.CHECK) {
            if (!map.containsKey(obj.getName())) {
                throw Message.getInternalError("not found: " + obj.getName());
            }
            if (obj.getName().equals(newName) || map.containsKey(newName)) {
                throw Message.getInternalError("object already exists: " + newName);
            }
        }
        map.remove(obj.getName());
        this.freeUniqueName(obj.getName());
        obj.rename(newName);
        map.put(newName, obj);
        this.freeUniqueName(newName);
    }

    public Table findTableOrView(Session session, String name) {
        Table table = (Table)this.tablesAndViews.get(name);
        if (table == null && session != null) {
            table = session.findLocalTempTable(name);
        }
        return table;
    }

    public Index findIndex(String name) {
        return (Index)this.indexes.get(name);
    }

    public TriggerObject findTrigger(String name) {
        return (TriggerObject)this.triggers.get(name);
    }

    public Sequence findSequence(String sequenceName) {
        return (Sequence)this.sequences.get(sequenceName);
    }

    public Constraint findConstraint(String constraintName) {
        return (Constraint)this.constraints.get(constraintName);
    }

    public Constant findConstant(String constantName) {
        return (Constant)this.constants.get(constantName);
    }

    public void freeUniqueName(String name) {
        if (name != null) {
            this.temporaryUniqueNames.remove(name);
        }
    }

    private String getUniqueName(DbObject obj, HashMap map, String prefix) {
        int i;
        String hash = Integer.toHexString(obj.getName().hashCode()).toUpperCase();
        String name = null;
        for (i = 1; i < hash.length() && (map.containsKey(name = prefix + hash.substring(0, i)) || this.temporaryUniqueNames.contains(name)); ++i) {
            name = null;
        }
        if (name == null) {
            prefix = prefix + hash + "_";
            i = 0;
            while (map.containsKey(name = prefix + i) || this.temporaryUniqueNames.contains(name)) {
                ++i;
            }
        }
        this.temporaryUniqueNames.add(name);
        return name;
    }

    public String getUniqueConstraintName(DbObject obj) {
        return this.getUniqueName(obj, this.constraints, "CONSTRAINT_");
    }

    public String getUniqueIndexName(DbObject obj, String prefix) {
        return this.getUniqueName(obj, this.indexes, prefix);
    }

    public Table getTableOrView(Session session, String name) throws SQLException {
        Table table = (Table)this.tablesAndViews.get(name);
        if (table == null && session != null) {
            table = session.findLocalTempTable(name);
        }
        if (table == null) {
            throw Message.getSQLException(42102, name);
        }
        return table;
    }

    public Index getIndex(String name) throws SQLException {
        Index index = (Index)this.indexes.get(name);
        if (index == null) {
            throw Message.getSQLException(42112, name);
        }
        return index;
    }

    public Constraint getConstraint(String name) throws SQLException {
        Constraint constraint = (Constraint)this.constraints.get(name);
        if (constraint == null) {
            throw Message.getSQLException(90057, name);
        }
        return constraint;
    }

    public Constant getConstant(Session session, String constantName) throws SQLException {
        Constant constant = (Constant)this.constants.get(constantName);
        if (constant == null) {
            throw Message.getSQLException(90115, constantName);
        }
        return constant;
    }

    public Sequence getSequence(String sequenceName) throws SQLException {
        Sequence sequence = (Sequence)this.sequences.get(sequenceName);
        if (sequence == null) {
            throw Message.getSQLException(90036, sequenceName);
        }
        return sequence;
    }

    public ObjectArray getAll(int type) {
        HashMap map = this.getMap(type);
        return new ObjectArray(map.values());
    }

    public void remove(Session session, SchemaObject obj) throws SQLException {
        String objName = obj.getName();
        HashMap map = this.getMap(obj.getType());
        if (SysProperties.CHECK && !map.containsKey(objName)) {
            throw Message.getInternalError("not found: " + objName);
        }
        map.remove(objName);
        this.freeUniqueName(objName);
    }

    public TableData createTable(String tempName, int id, ObjectArray newColumns, boolean persistent, boolean clustered) throws SQLException {
        return new TableData(this, tempName, id, newColumns, persistent, clustered);
    }

    public TableLink createTableLink(int id, String tableName, String driver, String url, String user, String password, String originalTable, boolean emitUpdates, boolean force) throws SQLException {
        return new TableLink(this, id, tableName, driver, url, user, password, originalTable, emitUpdates, force);
    }
}

