/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BtreeIndex;
import org.h2.index.BtreePage;
import org.h2.index.BtreePosition;
import org.h2.index.Cursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class BtreeCursor
implements Cursor {
    private BtreeIndex index;
    private BtreePosition top;
    private SearchRow currentSearchRow;
    private Row currentRow;
    private boolean first;
    private SearchRow last;
    private Session session;

    BtreeCursor(Session session, BtreeIndex index, SearchRow last) {
        this.session = session;
        this.index = index;
        this.last = last;
        this.first = true;
    }

    Session getSession() {
        return this.session;
    }

    void setStackPosition(int position) {
        this.top.position = position;
    }

    void push(BtreePage page, int position) {
        if (SysProperties.CHECK && this.top != null && this.top.page == page) {
            throw Message.getInternalError();
        }
        this.top = new BtreePosition(page, position, this.top);
    }

    BtreePosition pop() {
        BtreePosition t = this.top;
        if (t == null) {
            return null;
        }
        this.top = this.top.next;
        return t;
    }

    void setCurrentRow(SearchRow searchRow) throws SQLException {
        this.currentSearchRow = searchRow;
        this.currentRow = null;
    }

    public Row get() throws SQLException {
        if (this.currentRow == null && this.currentSearchRow != null) {
            this.currentRow = this.index.getRow(this.session, this.currentSearchRow.getPos());
        }
        return this.currentRow;
    }

    public SearchRow getSearchRow() throws SQLException {
        return this.currentSearchRow;
    }

    public int getPos() {
        return this.currentSearchRow.getPos();
    }

    public boolean next() throws SQLException {
        if (this.first) {
            this.first = false;
        } else {
            this.top.page.next(this, this.top.position);
            if (this.currentSearchRow != null && this.last != null && this.index.compareRows(this.currentSearchRow, this.last) > 0) {
                this.currentSearchRow = null;
                this.currentRow = null;
            }
        }
        return this.currentSearchRow != null;
    }
}

