/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.dml.Optimizer;
import org.h2.command.dml.Query;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Alias;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.Wildcard;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public class Select
extends Query {
    private TableFilter topTableFilter;
    private ObjectArray filters = new ObjectArray();
    private ObjectArray topFilters = new ObjectArray();
    private ObjectArray expressions;
    private Expression having;
    private Expression condition;
    private int visibleColumnCount;
    private int distinctColumnCount;
    private ObjectArray orderList;
    private ObjectArray group;
    private int[] groupIndex;
    private boolean[] groupByExpression;
    private boolean distinct;
    private HashMap currentGroup;
    private int havingIndex;
    private boolean isGroupQuery;
    private boolean isForUpdate;
    private double cost;
    private boolean isQuickQuery;
    private boolean isDistinctQuery;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean sortUsingIndex;
    private SortOrder sort;

    public Select(Session session) {
        super(session);
    }

    public void addTableFilter(TableFilter filter, boolean isTop) {
        this.filters.add(filter);
        if (isTop) {
            this.topFilters.add(filter);
        }
    }

    public ObjectArray getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ObjectArray expressions) {
        this.expressions = expressions;
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setGroupBy(ObjectArray group) {
        this.group = group;
    }

    public HashMap getCurrentGroup() {
        return this.currentGroup;
    }

    public void setOrder(ObjectArray order) {
        this.orderList = order;
    }

    public void addCondition(Expression cond) {
        this.condition = this.condition == null ? cond : new ConditionAndOr(0, cond, this.condition);
    }

    private void queryGroup(int columnCount, LocalResult result) throws SQLException {
        ValueHashMap groups = new ValueHashMap(this.session.getDatabase());
        int rowNumber = 0;
        this.setCurrentRowNumber(0);
        ValueArray defaultGroup = ValueArray.get(new Value[0]);
        while (this.topTableFilter.next()) {
            Expression expr;
            ValueArray key;
            this.checkCancelled();
            this.setCurrentRowNumber(rowNumber + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            ++rowNumber;
            if (this.groupIndex == null) {
                key = defaultGroup;
            } else {
                Value[] keyValues = new Value[this.groupIndex.length];
                for (int i = 0; i < this.groupIndex.length; ++i) {
                    int idx = this.groupIndex[i];
                    expr = (Expression)this.expressions.get(idx);
                    keyValues[i] = expr.getValue(this.session);
                }
                key = ValueArray.get(keyValues);
            }
            HashMap values = (HashMap)groups.get(key);
            if (values == null) {
                values = new HashMap();
                groups.put(key, values);
            }
            this.currentGroup = values;
            int len = columnCount;
            for (int i = 0; i < len; ++i) {
                if (this.groupByExpression != null && this.groupByExpression[i]) continue;
                expr = (Expression)this.expressions.get(i);
                expr.updateAggregate(this.session);
            }
            if (this.sampleSize <= 0 || rowNumber < this.sampleSize) continue;
            break;
        }
        if (this.groupIndex == null && groups.size() == 0) {
            groups.put(defaultGroup, new HashMap());
        }
        ObjectArray keys = groups.keys();
        for (int i = 0; i < keys.size(); ++i) {
            Value v;
            int j;
            ValueArray key = (ValueArray)keys.get(i);
            this.currentGroup = (HashMap)groups.get(key);
            Value[] keyValues = key.getList();
            Value[] row = new Value[columnCount];
            for (j = 0; this.groupIndex != null && j < this.groupIndex.length; ++j) {
                row[this.groupIndex[j]] = keyValues[j];
            }
            for (j = 0; j < columnCount; ++j) {
                if (this.groupByExpression != null && this.groupByExpression[j]) continue;
                Expression expr = (Expression)this.expressions.get(j);
                row[j] = expr.getValue(this.session);
            }
            if (this.havingIndex > 0 && ((v = row[this.havingIndex]) == ValueNull.INSTANCE || !Boolean.TRUE.equals(v.getBoolean()))) continue;
            if (columnCount != this.distinctColumnCount) {
                Value[] r2 = new Value[this.distinctColumnCount];
                System.arraycopy(row, 0, r2, 0, this.distinctColumnCount);
                row = r2;
            }
            result.addRow(row);
        }
    }

    private Index getSortIndex() throws SQLException {
        if (this.sort == null) {
            return null;
        }
        int[] indexes = this.sort.getIndexes();
        ObjectArray sortColumns = new ObjectArray();
        for (int i = 0; i < indexes.length; ++i) {
            int idx = indexes[i];
            if (idx < 0 || idx >= this.expressions.size()) {
                throw Message.getInvalidValueException("" + (idx + 1), "ORDER BY");
            }
            Expression expr = (Expression)this.expressions.get(idx);
            if ((expr = expr.getNonAliasExpression()).isConstant()) continue;
            if (!(expr instanceof ExpressionColumn)) {
                return null;
            }
            Column col = ((ExpressionColumn)expr).getColumn();
            if (col.getTable() != this.topTableFilter.getTable()) {
                return null;
            }
            sortColumns.add(col);
        }
        Object[] sortCols = new Column[sortColumns.size()];
        sortColumns.toArray(sortCols);
        int[] sortTypes = this.sort.getSortTypes();
        if (sortCols.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        ObjectArray list = this.topTableFilter.getTable().getIndexes();
        for (int i = 0; list != null && i < list.size(); ++i) {
            IndexColumn[] indexCols;
            Index index = (Index)list.get(i);
            if (index.getCreateSQL() == null || index.getIndexType().isHash() || (indexCols = index.getIndexColumns()).length < sortCols.length) continue;
            boolean ok = true;
            for (int j = 0; j < sortCols.length; ++j) {
                IndexColumn idxCol = indexCols[j];
                Object sortCol = sortCols[j];
                if (idxCol.column != sortCol) {
                    ok = false;
                    break;
                }
                if (idxCol.sortType == sortTypes[j]) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return index;
        }
        return null;
    }

    private void queryDistinct(int columnCount, LocalResult result, long limitRows) throws SQLException {
        if (limitRows != 0L && this.offset != null) {
            limitRows += (long)this.offset.getValue(this.session).getInt();
        }
        int rowNumber = 0;
        this.setCurrentRowNumber(0);
        Index index = this.topTableFilter.getIndex();
        SearchRow first = null;
        int columnIndex = index.getColumns()[0].getColumnId();
        do {
            this.checkCancelled();
            this.setCurrentRowNumber(rowNumber + 1);
            Cursor cursor = index.findNext(this.session, first, null);
            if (!cursor.next()) break;
            SearchRow found = cursor.getSearchRow();
            Value value = found.getValue(columnIndex);
            if (first == null) {
                first = this.topTableFilter.getTable().getTemplateSimpleRow(true);
            }
            first.setValue(columnIndex, value);
            Value[] row = new Value[]{value};
            result.addRow(row);
        } while ((this.sort != null && !this.sortUsingIndex || limitRows == 0L || (long)result.getRowCount() < limitRows) && (this.sampleSize <= 0 || ++rowNumber < this.sampleSize));
    }

    private void queryFlat(int columnCount, LocalResult result, long limitRows) throws SQLException {
        if (limitRows != 0L && this.offset != null) {
            limitRows += (long)this.offset.getValue(this.session).getInt();
        }
        int rowNumber = 0;
        this.setCurrentRowNumber(0);
        while (this.topTableFilter.next()) {
            this.checkCancelled();
            this.setCurrentRowNumber(rowNumber + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            Value[] row = new Value[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                Expression expr = (Expression)this.expressions.get(i);
                row[i] = expr.getValue(this.session);
            }
            result.addRow(row);
            if ((this.sort != null && !this.sortUsingIndex || limitRows == 0L || (long)result.getRowCount() < limitRows) && (this.sampleSize <= 0 || ++rowNumber < this.sampleSize)) continue;
            break;
        }
    }

    private void queryQuick(int columnCount, LocalResult result) throws SQLException {
        Value[] row = new Value[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Expression expr = (Expression)this.expressions.get(i);
            row[i] = expr.getValue(this.session);
        }
        result.addRow(row);
    }

    public LocalResult queryMeta() throws SQLException {
        LocalResult result = new LocalResult(this.session, this.expressions, this.visibleColumnCount);
        result.done();
        return result;
    }

    public LocalResult queryWithoutCache(int maxRows) throws SQLException {
        int limitRows = maxRows;
        if (this.limit != null) {
            int l = this.limit.getValue(this.session).getInt();
            limitRows = limitRows == 0 ? l : Math.min(l, limitRows);
        }
        int columnCount = this.expressions.size();
        LocalResult result = new LocalResult(this.session, this.expressions, this.visibleColumnCount);
        if (!this.sortUsingIndex) {
            result.setSortOrder(this.sort);
        }
        if (this.distinct && !this.isDistinctQuery) {
            result.setDistinct();
        }
        this.topTableFilter.startQuery(this.session);
        this.topTableFilter.reset();
        this.topTableFilter.lock(this.session, this.isForUpdate, this.isForUpdate);
        if (this.isQuickQuery) {
            this.queryQuick(columnCount, result);
        } else if (this.isGroupQuery) {
            this.queryGroup(columnCount, result);
        } else if (this.isDistinctQuery) {
            this.queryDistinct(columnCount, result, limitRows);
        } else {
            this.queryFlat(columnCount, result, limitRows);
        }
        if (this.offset != null) {
            result.setOffset(this.offset.getValue(this.session).getInt());
        }
        if (limitRows != 0) {
            result.setLimit(limitRows);
        }
        result.done();
        return result;
    }

    private void expandColumnList() throws SQLException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            int j;
            Expression expr = (Expression)this.expressions.get(i);
            if (!expr.isWildcard()) continue;
            String tableAlias = expr.getTableAlias();
            if (tableAlias == null) {
                int temp = i;
                this.expressions.remove(i);
                for (j = 0; j < this.filters.size(); ++j) {
                    TableFilter filter = (TableFilter)this.filters.get(j);
                    Wildcard c2 = new Wildcard(filter.getTable().getSchema().getName(), filter.getTableAlias());
                    this.expressions.add(i++, c2);
                }
                i = temp - 1;
                continue;
            }
            TableFilter filter = null;
            for (j = 0; j < this.filters.size(); ++j) {
                TableFilter f = (TableFilter)this.filters.get(j);
                if (!tableAlias.equals(f.getTableAlias())) continue;
                filter = f;
                break;
            }
            if (filter == null) {
                throw Message.getSQLException(42102, tableAlias);
            }
            Table t = filter.getTable();
            String alias = filter.getTableAlias();
            this.expressions.remove(i);
            Column[] columns = t.getColumns();
            for (int j2 = 0; j2 < columns.length; ++j2) {
                Column c = columns[j2];
                ExpressionColumn ec = new ExpressionColumn(this.session.getDatabase(), null, alias, c.getName());
                this.expressions.add(i++, ec);
            }
            --i;
        }
    }

    public void init() throws SQLException {
        String sql;
        Expression expr;
        int i;
        ObjectArray expressionSQL;
        if (SysProperties.CHECK && this.checkInit) {
            throw Message.getInternalError();
        }
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.orderList != null || this.group != null) {
            expressionSQL = new ObjectArray();
            for (i = 0; i < this.expressions.size(); ++i) {
                expr = (Expression)this.expressions.get(i);
                expr = expr.getNonAliasExpression();
                sql = expr.getSQL();
                expressionSQL.add(sql);
            }
        } else {
            expressionSQL = null;
        }
        if (this.orderList != null) {
            this.initOrder(this.expressions, expressionSQL, this.orderList, this.visibleColumnCount, this.distinct);
        }
        this.distinctColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        if (this.group != null) {
            this.groupIndex = new int[this.group.size()];
            for (i = 0; i < this.group.size(); ++i) {
                expr = (Expression)this.group.get(i);
                sql = expr.getSQL();
                int found = -1;
                for (int j = 0; j < expressionSQL.size(); ++j) {
                    String s2 = (String)expressionSQL.get(j);
                    if (!s2.equals(sql)) continue;
                    found = j;
                    break;
                }
                if (found < 0) {
                    int index;
                    this.groupIndex[i] = index = this.expressions.size();
                    this.expressions.add(expr);
                    continue;
                }
                this.groupIndex[i] = found;
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            for (i = 0; i < this.groupIndex.length; ++i) {
                this.groupByExpression[this.groupIndex[i]] = true;
            }
            this.group = null;
        }
        for (i = 0; i < this.filters.size(); ++i) {
            TableFilter f = (TableFilter)this.filters.get(i);
            for (int j = 0; j < this.expressions.size(); ++j) {
                Expression expr2 = (Expression)this.expressions.get(j);
                expr2.mapColumns(f, 0);
            }
            if (this.condition == null) continue;
            this.condition.mapColumns(f, 0);
        }
        this.checkInit = true;
    }

    public void prepare() throws SQLException {
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            throw Message.getInternalError("not initialized");
        }
        if (this.orderList != null) {
            this.sort = this.prepareOrder(this.expressions, this.orderList);
            this.orderList = null;
        }
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = (Expression)this.expressions.get(i);
            this.expressions.set(i, e.optimize(this.session));
        }
        if (this.condition != null) {
            this.condition = this.condition.optimize(this.session);
            if (SysProperties.OPTIMIZE_IN_JOIN) {
                this.condition = this.condition.optimizeInJoin(this.session, this);
            }
            for (int j = 0; j < this.filters.size(); ++j) {
                TableFilter f = (TableFilter)this.filters.get(j);
                this.condition.createIndexConditions(this.session, f);
            }
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.filters.size() == 1 && this.condition == null) {
            ExpressionVisitor optimizable = ExpressionVisitor.get(1);
            optimizable.table = ((TableFilter)this.filters.get(0)).getTable();
            this.isQuickQuery = this.isEverything(optimizable);
        }
        this.cost = this.preparePlan();
        if (SysProperties.OPTIMIZE_DISTINCT && this.distinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expr = (Expression)this.expressions.get(0);
            if ((expr = expr.getNonAliasExpression()) instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)expr).getColumn();
                int selectivity = column.getSelectivity();
                Index columnIndex = this.topTableFilter.getTable().getIndexForColumn(column, true);
                if (columnIndex != null && selectivity != 50 && selectivity < 20) {
                    IndexType type;
                    boolean ascending = columnIndex.getIndexColumns()[0].sortType == 0;
                    Index current = this.topTableFilter.getIndex();
                    if (!(!columnIndex.canFindNext() || !ascending || current != null && !current.getIndexType().isScan() && columnIndex != current || (type = columnIndex.getIndexType()).isHash() || type.isUnique() && columnIndex.getColumns().length <= 1)) {
                        this.topTableFilter.setIndex(columnIndex);
                        this.isDistinctQuery = true;
                    }
                }
            }
        }
        if (this.sort != null && !this.isQuickQuery && !this.isGroupQuery) {
            Index index = this.getSortIndex();
            Index current = this.topTableFilter.getIndex();
            if (index != null && (current.getIndexType().isScan() || current == index)) {
                this.topTableFilter.setIndex(index);
                if (!this.distinct || this.isDistinctQuery) {
                    this.sortUsingIndex = true;
                }
            }
        }
        this.isPrepared = true;
    }

    public double getCost() {
        return this.cost;
    }

    public HashSet getTables() {
        HashSet<Table> set = new HashSet<Table>();
        for (int i = 0; i < this.filters.size(); ++i) {
            TableFilter filter = (TableFilter)this.filters.get(i);
            set.add(filter.getTable());
        }
        return set;
    }

    private double preparePlan() throws SQLException {
        Object[] topArray = new TableFilter[this.topFilters.size()];
        this.topFilters.toArray(topArray);
        for (int i = 0; i < topArray.length; ++i) {
            ((TableFilter)topArray[i]).setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer((TableFilter[])topArray, this.condition, this.session);
        optimizer.optimize();
        this.topTableFilter = optimizer.getTopFilter();
        double cost = optimizer.getCost();
        for (TableFilter f = this.topTableFilter; f != null; f = f.getJoin()) {
            Expression on;
            f.setEvaluatable(f, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(f, true);
            }
            if ((on = f.getJoinCondition()) != null && !on.isEverything(3)) {
                if (f.isJoinOuter()) {
                    throw Message.getSQLException(90136, on.getSQL());
                }
                f.removeJoinCondition();
                on = on.optimize(this.session);
                this.addCondition(on);
            }
            if ((on = f.getFilterCondition()) != null && !on.isEverything(3)) {
                f.removeFilterCondition();
                this.addCondition(on);
            }
            for (int i = 0; i < this.expressions.size(); ++i) {
                Expression e = (Expression)this.expressions.get(i);
                e.setEvaluatable(f, true);
            }
        }
        this.topTableFilter.prepare();
        return cost;
    }

    public String getPlanSQL() {
        if (this.topTableFilter == null) {
            return this.sql;
        }
        StringBuffer buff = new StringBuffer();
        Object[] exprList = new Expression[this.expressions.size()];
        this.expressions.toArray(exprList);
        buff.append("SELECT ");
        if (this.distinct) {
            buff.append("DISTINCT ");
        }
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            Object expr = exprList[i];
            buff.append(((Expression)expr).getSQL());
        }
        buff.append("\nFROM ");
        TableFilter filter = this.topTableFilter;
        boolean join = false;
        int id = 0;
        do {
            if (id > 0) {
                buff.append("\n");
            }
            buff.append(filter.getPlanSQL(join));
            ++id;
            join = true;
        } while ((filter = filter.getJoin()) != null);
        if (this.condition != null) {
            buff.append("\nWHERE " + StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.groupIndex != null) {
            buff.append("\nGROUP BY ");
            for (int i = 0; i < this.groupIndex.length; ++i) {
                Object g = exprList[this.groupIndex[i]];
                g = ((Expression)g).getNonAliasExpression();
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(StringUtils.unEnclose(((Expression)g).getSQL()));
            }
        }
        if (this.having != null) {
            Expression h = this.having;
            buff.append("\nHAVING " + StringUtils.unEnclose(h.getSQL()));
        } else if (this.havingIndex >= 0) {
            Object h = exprList[this.havingIndex];
            buff.append("\nHAVING " + StringUtils.unEnclose(((Expression)h).getSQL()));
        }
        if (this.sort != null) {
            buff.append("\nORDER BY ");
            buff.append(this.sort.getSQL((Expression[])exprList, this.visibleColumnCount));
        }
        if (this.limit != null) {
            buff.append("\nLIMIT ");
            buff.append(StringUtils.unEnclose(this.limit.getSQL()));
            if (this.offset != null) {
                buff.append(" OFFSET ");
                buff.append(StringUtils.unEnclose(this.offset.getSQL()));
            }
        }
        if (this.isForUpdate) {
            buff.append("\nFOR UPDATE");
        }
        if (this.isQuickQuery) {
            buff.append("\n/* direct lookup */");
        }
        if (this.isDistinctQuery) {
            buff.append("\n/* distinct */");
        }
        return buff.toString();
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public void setHaving(Expression having) {
        this.having = having;
    }

    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    public ObjectArray getExpressions() {
        return this.expressions;
    }

    public void setForUpdate(boolean b) {
        this.isForUpdate = b;
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = (Expression)this.expressions.get(i);
            e.mapColumns(resolver, level);
        }
        if (this.condition != null) {
            this.condition.mapColumns(resolver, level);
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = (Expression)this.expressions.get(i);
            e.setEvaluatable(tableFilter, b);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, b);
        }
    }

    public boolean isQuickQuery() {
        return this.isQuickQuery;
    }

    public void addGlobalCondition(Parameter param, int columnId, int comparisonType) throws SQLException {
        this.addParameter(param);
        Expression col = (Expression)this.expressions.get(columnId);
        col = col.getNonAliasExpression();
        Expression comp = new Comparison(this.session, comparisonType, col, param);
        comp = ((Expression)comp).optimize(this.session);
        boolean addToCondition = true;
        if (this.isGroupQuery) {
            addToCondition = false;
            for (int i = 0; this.groupIndex != null && i < this.groupIndex.length; ++i) {
                if (this.groupIndex[i] != columnId) continue;
                addToCondition = true;
                break;
            }
            if (!addToCondition) {
                if (this.havingIndex >= 0) {
                    this.having = (Expression)this.expressions.get(this.havingIndex);
                }
                this.having = this.having == null ? comp : new ConditionAndOr(0, this.having, comp);
            }
        }
        if (addToCondition) {
            this.condition = this.condition == null ? comp : new ConditionAndOr(0, this.condition, comp);
        }
    }

    public void updateAggregate(Session session) throws SQLException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = (Expression)this.expressions.get(i);
            e.updateAggregate(session);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(session);
        }
        if (this.having != null) {
            this.having.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.type) {
            case 4: {
                int i;
                for (i = 0; i < this.filters.size(); ++i) {
                    TableFilter f = (TableFilter)this.filters.get(i);
                    long m = f.getTable().getMaxDataModificationId();
                    visitor.addDataModificationId(m);
                }
                break;
            }
            case 3: {
                if (SysProperties.OPTIMIZE_EVALUATABLE_SUBQUERIES) break;
                return false;
            }
            case 7: {
                int i;
                for (i = 0; i < this.filters.size(); ++i) {
                    TableFilter filter = (TableFilter)this.filters.get(i);
                    Table table = filter.getTable();
                    visitor.addDependency(table);
                    table.addDependencies(visitor.getDependencies());
                }
                break;
            }
        }
        visitor.queryLevel(1);
        boolean result = true;
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression e = (Expression)this.expressions.get(i);
            if (e.isEverything(visitor)) continue;
            result = false;
            break;
        }
        if (result && this.condition != null && !this.condition.isEverything(visitor)) {
            result = false;
        }
        if (result && this.having != null && !this.having.isEverything(visitor)) {
            result = false;
        }
        visitor.queryLevel(-1);
        return result;
    }

    public boolean isReadOnly() {
        return this.isEverything(5);
    }

    public String getFirstColumnAlias(Session session) {
        if (SysProperties.CHECK && this.visibleColumnCount > 1) {
            throw Message.getInternalError("" + this.visibleColumnCount);
        }
        Expression expr = (Expression)this.expressions.get(0);
        if (expr instanceof Alias) {
            return expr.getAlias();
        }
        expr = new Alias(expr, session.getNextTempViewName() + "_X");
        this.expressions.set(0, expr);
        return expr.getAlias();
    }
}

