/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.h2.command.Parser;
import org.h2.command.dml.ScriptBase;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.Database;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.AutoCloseInputStream;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueString;

public class ScriptCommand
extends ScriptBase {
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private boolean simple;
    private LocalResult result;
    private byte[] lineSeparator;
    private byte[] buffer;
    private boolean tempLobTableCreated;
    private int nextLobId;
    private int lobBlockSize = 4096;
    private static final String TEMP_LOB_FILENAME = "system_temp_lob.db";

    public ScriptCommand(Session session) {
        super(session);
    }

    public boolean isQuery() {
        return true;
    }

    public void setData(boolean data) {
        this.data = data;
    }

    public void setPasswords(boolean passwords) {
        this.passwords = passwords;
    }

    public void setSettings(boolean settings) {
        this.settings = settings;
    }

    public void setLobBlockSize(long blockSize) {
        this.lobBlockSize = MathUtils.convertLongToInt(blockSize);
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public LocalResult queryMeta() throws SQLException {
        LocalResult result = this.createResult();
        result.done();
        return result;
    }

    private LocalResult createResult() {
        ObjectArray cols = new ObjectArray();
        cols.add(new ExpressionColumn(this.session.getDatabase(), new Column("SCRIPT", 13)));
        return new LocalResult(this.session, cols, 1);
    }

    public LocalResult query(int maxrows) throws SQLException {
        this.session.getUser().checkAdmin();
        this.reset();
        try {
            int i;
            int i2;
            this.result = this.createResult();
            this.deleteStore();
            this.openOutput();
            if (this.out != null) {
                this.buffer = new byte[4096];
            }
            Database db = this.session.getDatabase();
            if (this.settings) {
                ObjectArray settings = db.getAllSettings();
                for (i2 = 0; i2 < settings.size(); ++i2) {
                    Setting setting = (Setting)settings.get(i2);
                    if (setting.getName().equals(SetTypes.getTypeName(34))) continue;
                    this.add(setting.getCreateSQL(), false);
                }
            }
            if (this.out != null) {
                this.add("", true);
            }
            ObjectArray users = db.getAllUsers();
            for (i2 = 0; i2 < users.size(); ++i2) {
                User user = (User)users.get(i2);
                this.add(user.getCreateSQL(this.passwords, true), false);
            }
            ObjectArray roles = db.getAllRoles();
            for (int i3 = 0; i3 < roles.size(); ++i3) {
                Role role = (Role)roles.get(i3);
                this.add(role.getCreateSQL(), false);
            }
            ObjectArray schemas = db.getAllSchemas();
            for (int i4 = 0; i4 < schemas.size(); ++i4) {
                Schema schema = (Schema)schemas.get(i4);
                this.add(schema.getCreateSQL(), false);
            }
            ObjectArray datatypes = db.getAllUserDataTypes();
            for (int i5 = 0; i5 < datatypes.size(); ++i5) {
                UserDataType datatype = (UserDataType)datatypes.get(i5);
                if (this.drop) {
                    this.add(datatype.getDropSQL(), false);
                }
                this.add(datatype.getCreateSQL(), false);
            }
            ObjectArray constants = db.getAllSchemaObjects(11);
            for (int i6 = 0; i6 < constants.size(); ++i6) {
                Constant constant = (Constant)constants.get(i6);
                this.add(constant.getCreateSQL(), false);
            }
            ObjectArray functionAliases = db.getAllFunctionAliases();
            for (int i7 = 0; i7 < functionAliases.size(); ++i7) {
                FunctionAlias alias = (FunctionAlias)functionAliases.get(i7);
                if (this.drop) {
                    this.add(alias.getDropSQL(), false);
                }
                this.add(alias.getCreateSQL(), false);
            }
            ObjectArray aggregates = db.getAllAggregates();
            for (int i8 = 0; i8 < aggregates.size(); ++i8) {
                UserAggregate agg = (UserAggregate)aggregates.get(i8);
                if (this.drop) {
                    this.add(agg.getDropSQL(), false);
                }
                this.add(agg.getCreateSQL(), false);
            }
            ObjectArray tables = db.getAllSchemaObjects(0);
            tables.sort(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Table t1 = (Table)o1;
                    Table t2 = (Table)o2;
                    return t1.getId() - t2.getId();
                }
            });
            for (int i9 = 0; i9 < tables.size(); ++i9) {
                Table table = (Table)tables.get(i9);
                table.lock(this.session, false, false);
                String sql = table.getCreateSQL();
                if (sql == null || !this.drop) continue;
                this.add(table.getDropSQL(), false);
            }
            ObjectArray sequences = db.getAllSchemaObjects(3);
            for (i = 0; i < sequences.size(); ++i) {
                Sequence sequence = (Sequence)sequences.get(i);
                if (this.drop) {
                    this.add(sequence.getDropSQL(), false);
                }
                this.add(sequence.getCreateSQL(), false);
            }
            for (i = 0; i < tables.size(); ++i) {
                Table table = (Table)tables.get(i);
                table.lock(this.session, false, false);
                String sql = table.getCreateSQL();
                if (sql == null) continue;
                String tableType = table.getTableType();
                this.add(sql, false);
                if ("TABLE".equals(tableType)) {
                    if (table.canGetRowCount()) {
                        String rowcount = "-- " + table.getRowCount(this.session) + " = SELECT COUNT(*) FROM " + table.getSQL();
                        this.add(rowcount, false);
                    }
                    if (this.data) {
                        PlanItem plan = table.getBestPlanItem(this.session, null);
                        Index index = plan.getIndex();
                        Cursor cursor = index.find(this.session, null, null);
                        Column[] columns = table.getColumns();
                        StringBuffer buff = new StringBuffer();
                        buff.append("INSERT INTO ");
                        buff.append(table.getSQL());
                        buff.append('(');
                        for (int j = 0; j < columns.length; ++j) {
                            if (j > 0) {
                                buff.append(", ");
                            }
                            buff.append(Parser.quoteIdentifier(columns[j].getName()));
                        }
                        buff.append(") VALUES");
                        if (!this.simple) {
                            buff.append('\n');
                        }
                        buff.append('(');
                        String ins = buff.toString();
                        buff = null;
                        while (cursor.next()) {
                            Row row = cursor.get();
                            if (buff == null) {
                                buff = new StringBuffer(ins);
                            } else {
                                buff.append(",\n(");
                            }
                            for (int j = 0; j < row.getColumnCount(); ++j) {
                                Value v;
                                if (j > 0) {
                                    buff.append(", ");
                                }
                                if ((v = row.getValue(j)).getPrecision() > (long)this.lobBlockSize) {
                                    int id;
                                    if (v.getType() == 16) {
                                        id = this.writeLobStream((ValueLob)v);
                                        buff.append("SYSTEM_COMBINE_CLOB(" + id + ")");
                                        continue;
                                    }
                                    if (v.getType() == 15) {
                                        id = this.writeLobStream((ValueLob)v);
                                        buff.append("SYSTEM_COMBINE_BLOB(" + id + ")");
                                        continue;
                                    }
                                    buff.append(v.getSQL());
                                    continue;
                                }
                                buff.append(v.getSQL());
                            }
                            buff.append(")");
                            if (!this.simple && buff.length() <= 4096) continue;
                            this.add(buff.toString(), true);
                            buff = null;
                        }
                        if (buff != null) {
                            this.add(buff.toString(), true);
                        }
                    }
                }
                ObjectArray indexes = table.getIndexes();
                for (int j = 0; indexes != null && j < indexes.size(); ++j) {
                    Index index = (Index)indexes.get(j);
                    if (index.getIndexType().belongsToConstraint()) continue;
                    this.add(index.getCreateSQL(), false);
                }
            }
            if (this.tempLobTableCreated) {
                this.add("DROP TABLE IF EXISTS SYSTEM_LOB_STREAM", true);
                this.add("CALL SYSTEM_COMBINE_BLOB(-1)", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB", true);
                this.tempLobTableCreated = false;
            }
            ObjectArray constraints = db.getAllSchemaObjects(5);
            constraints.sort(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Constraint c1 = (Constraint)o1;
                    Constraint c2 = (Constraint)o2;
                    return c1.compareTo(c2);
                }
            });
            for (int i10 = 0; i10 < constraints.size(); ++i10) {
                Constraint constraint = (Constraint)constraints.get(i10);
                this.add(constraint.getCreateSQLWithoutIndexes(), false);
            }
            ObjectArray triggers = db.getAllSchemaObjects(4);
            for (int i11 = 0; i11 < triggers.size(); ++i11) {
                TriggerObject trigger = (TriggerObject)triggers.get(i11);
                this.add(trigger.getCreateSQL(), false);
            }
            ObjectArray rights = db.getAllRights();
            for (int i12 = 0; i12 < rights.size(); ++i12) {
                Right right = (Right)rights.get(i12);
                this.add(right.getCreateSQL(), false);
            }
            ObjectArray comments = db.getAllComments();
            for (int i13 = 0; i13 < comments.size(); ++i13) {
                Comment comment = (Comment)comments.get(i13);
                this.add(comment.getCreateSQL(), false);
            }
            this.closeIO();
        }
        catch (IOException e) {
            throw Message.convertIOException(e, this.fileName);
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        LocalResult r = this.result;
        this.reset();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLobStream(ValueLob v) throws IOException, SQLException {
        if (!this.tempLobTableCreated) {
            this.add("CREATE TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT, PART INT, CDATA VARCHAR, BDATA BINARY, PRIMARY KEY(ID, PART))", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR \"" + this.getClass().getName() + ".combineClob\"", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR \"" + this.getClass().getName() + ".combineBlob\"", true);
            this.tempLobTableCreated = true;
        }
        int id = this.nextLobId++;
        block2 : switch (v.getType()) {
            case 15: {
                byte[] bytes = new byte[this.lobBlockSize];
                InputStream in = v.getInputStream();
                try {
                    int i = 0;
                    while (true) {
                        StringBuffer buff = new StringBuffer(this.lobBlockSize * 2);
                        buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + id + ", " + i + ", NULL, '");
                        int len = IOUtils.readFully(in, bytes, 0, this.lobBlockSize);
                        if (len <= 0) {
                            break block2;
                        }
                        buff.append(ByteUtils.convertBytesToString(bytes, len));
                        buff.append("')");
                        String sql = buff.toString();
                        this.add(sql, true);
                        ++i;
                    }
                }
                finally {
                    IOUtils.closeSilently(in);
                }
            }
            case 16: {
                char[] chars = new char[this.lobBlockSize];
                Reader in = v.getReader();
                try {
                    int i = 0;
                    while (true) {
                        StringBuffer buff = new StringBuffer(this.lobBlockSize * 2);
                        buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + id + ", " + i + ", ");
                        int len = IOUtils.readFully(in, chars, this.lobBlockSize);
                        if (len < 0) {
                            break block2;
                        }
                        buff.append(StringUtils.quoteStringSQL(new String(chars, 0, len)));
                        buff.append(", NULL)");
                        String sql = buff.toString();
                        this.add(sql, true);
                        ++i;
                    }
                }
                finally {
                    IOUtils.closeSilently(in);
                }
            }
            default: {
                throw Message.getInternalError("type:" + v.getType());
            }
        }
        return id;
    }

    public static InputStream combineBlob(Connection conn, int id) throws SQLException, IOException {
        if (id < 0) {
            FileUtils.delete(TEMP_LOB_FILENAME);
            return null;
        }
        ResultSet rs = ScriptCommand.getLobStream(conn, "BDATA", id);
        OutputStream out = FileUtils.openFileOutputStream(TEMP_LOB_FILENAME, false);
        while (rs.next()) {
            InputStream in = rs.getBinaryStream(1);
            IOUtils.copyAndCloseInput(in, out);
        }
        out.close();
        ScriptCommand.deleteLobStream(conn, id);
        return ScriptCommand.openAutoCloseInput();
    }

    public static Reader combineClob(Connection conn, int id) throws SQLException, IOException {
        ResultSet rs = ScriptCommand.getLobStream(conn, "CDATA", id);
        Writer out = FileUtils.openFileWriter(TEMP_LOB_FILENAME, false);
        while (rs.next()) {
            BufferedReader in = new BufferedReader(rs.getCharacterStream(1));
            IOUtils.copyAndCloseInput(in, out);
        }
        out.close();
        ScriptCommand.deleteLobStream(conn, id);
        return IOUtils.getReader(ScriptCommand.openAutoCloseInput());
    }

    private static ResultSet getLobStream(Connection conn, String column, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT " + column + " FROM SYSTEM_LOB_STREAM WHERE ID=? ORDER BY PART");
        prep.setInt(1, id);
        return prep.executeQuery();
    }

    private static void deleteLobStream(Connection conn, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("DELETE FROM SYSTEM_LOB_STREAM WHERE ID=?");
        prep.setInt(1, id);
        prep.execute();
    }

    private static InputStream openAutoCloseInput() throws IOException {
        InputStream in = FileUtils.openFileInputStream(TEMP_LOB_FILENAME);
        in = new BufferedInputStream(in);
        return new AutoCloseInputStream(in);
    }

    private void reset() throws SQLException {
        this.result = null;
        this.buffer = null;
        this.lineSeparator = StringUtils.utf8Encode(SysProperties.LINE_SEPARATOR);
    }

    private void add(String s, boolean insert) throws SQLException, IOException {
        if (s == null) {
            return;
        }
        s = s + ";";
        if (this.out != null) {
            byte[] buff = StringUtils.utf8Encode(s);
            int len = MathUtils.roundUp(buff.length + this.lineSeparator.length, 16);
            this.buffer = ByteUtils.copy(buff, this.buffer);
            if (len > this.buffer.length) {
                this.buffer = new byte[len];
            }
            System.arraycopy(buff, 0, this.buffer, 0, buff.length);
            for (int i = buff.length; i < len - this.lineSeparator.length; ++i) {
                this.buffer[i] = 32;
            }
            int j = 0;
            int i = len - this.lineSeparator.length;
            while (i < len) {
                this.buffer[i] = this.lineSeparator[j];
                ++i;
                ++j;
            }
            this.out.write(this.buffer, 0, len);
            if (!insert) {
                Value[] row = new Value[]{ValueString.get(s)};
                this.result.addRow(row);
            }
        } else {
            Value[] row = new Value[]{ValueString.get(s)};
            this.result.addRow(row);
        }
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }
}

