/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.Message;

public class CreateRole
extends DefineCommand {
    private String roleName;
    private boolean ifNotExists;

    public CreateRole(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setRoleName(String name) {
        this.roleName = name;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (db.findUser(this.roleName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90033, this.roleName);
        }
        if (db.findRole(this.roleName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90069, this.roleName);
        }
        int id = this.getObjectId(false, true);
        Role role = new Role(db, id, this.roleName, false);
        db.addDatabaseObject(this.session, role);
        return 0;
    }
}

