/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class PgTcpRedirect {
    public static void main(String[] args) throws Exception {
        new PgTcpRedirect().loop(args);
    }

    void loop(String[] args) throws Exception {
        int portServer = 5432;
        int portClient = 5433;
        for (int i = 0; i < args.length; ++i) {
            if ("-client".equals(args[i])) {
                portClient = Integer.parseInt(args[++i]);
                continue;
            }
            if (!"-server".equals(args[i])) continue;
            portServer = Integer.parseInt(args[++i]);
        }
        ServerSocket listener = new ServerSocket(portClient);
        while (true) {
            Socket client = listener.accept();
            Socket server = new Socket("localhost", portServer);
            TcpRedirectThread c = new TcpRedirectThread(client, server, true);
            TcpRedirectThread s = new TcpRedirectThread(server, client, false);
            new Thread(c).start();
            new Thread(s).start();
        }
    }

    private synchronized void printData(byte[] buffer, int len) {
    }

    private class TcpRedirectThread
    implements Runnable {
        private Socket read;
        private Socket write;
        private int state;
        private boolean client;
        private static final int STATE_INIT_CLIENT = 0;
        private static final int STATE_REGULAR = 1;

        TcpRedirectThread(Socket read, Socket write, boolean client) {
            this.read = read;
            this.write = write;
            this.client = client;
            this.state = client ? 0 : 1;
        }

        String readStringNull(InputStream in) throws IOException {
            int x;
            StringBuffer buff = new StringBuffer();
            while ((x = in.read()) > 0) {
                buff.append((char)x);
            }
            return buff.toString();
        }

        private void println(String s) {
        }

        private boolean processClient(InputStream inStream, OutputStream outStream) throws IOException {
            DataInputStream dataIn = new DataInputStream(inStream);
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(buff);
            if (this.state == 0) {
                this.state = 1;
                int len = dataIn.readInt();
                dataOut.writeInt(len);
                byte[] data = new byte[len -= 4];
                dataIn.readFully(data, 0, len);
                dataOut.write(data);
                dataIn = new DataInputStream(new ByteArrayInputStream(data, 0, len));
                int version = dataIn.readInt();
                if (version == 80877102) {
                    this.println("CancelRequest");
                    this.println(" pid: " + dataIn.readInt());
                    this.println(" key: " + dataIn.readInt());
                } else if (version == 80877103) {
                    this.println("SSLRequest");
                } else {
                    String param;
                    this.println("StartupMessage");
                    this.println(" version " + version + " (" + (version >> 16) + "." + (version & 0xFF) + ")");
                    while ((param = this.readStringNull(dataIn)).length() != 0) {
                        String value = this.readStringNull(dataIn);
                        this.println(" param " + param + "=" + value);
                    }
                }
            } else {
                int x = dataIn.read();
                if (x < 0) {
                    this.println("end");
                    return false;
                }
                dataOut.write(x);
                int len = dataIn.readInt();
                dataOut.writeInt(len);
                byte[] data = new byte[len -= 4];
                dataIn.readFully(data, 0, len);
                dataOut.write(data);
                dataIn = new DataInputStream(new ByteArrayInputStream(data, 0, len));
                switch (x) {
                    case 66: {
                        this.println("Bind");
                        this.println(" destPortal: " + this.readStringNull(dataIn));
                        this.println(" prepName: " + this.readStringNull(dataIn));
                        int formatCodesCount = dataIn.readShort();
                        for (int i = 0; i < formatCodesCount; ++i) {
                            this.println(" formatCode[" + i + "]=" + dataIn.readShort());
                        }
                        int paramCount = dataIn.readShort();
                        for (int i = 0; i < paramCount; ++i) {
                            int paramLen = dataIn.readInt();
                            this.println(" length[" + i + "]=" + paramLen);
                            byte[] d2 = new byte[paramLen];
                            dataIn.readFully(d2);
                        }
                        int resultCodeCount = dataIn.readShort();
                        for (int i = 0; i < resultCodeCount; ++i) {
                            this.println(" resultCodeCount[" + i + "]=" + dataIn.readShort());
                        }
                        break;
                    }
                    case 67: {
                        this.println("Close");
                        this.println(" type: (S:prepared statement, P:portal): " + dataIn.read());
                        break;
                    }
                    case 100: {
                        this.println("CopyData");
                        break;
                    }
                    case 99: {
                        this.println("CopyDone");
                        break;
                    }
                    case 102: {
                        this.println("CopyFail");
                        this.println(" message: " + this.readStringNull(dataIn));
                        break;
                    }
                    case 68: {
                        this.println("Describe");
                        this.println(" type (S=prepared statement, P=portal): " + (char)dataIn.readByte());
                        this.println(" name: " + this.readStringNull(dataIn));
                        break;
                    }
                    case 69: {
                        this.println("Execute");
                        this.println(" name: " + this.readStringNull(dataIn));
                        this.println(" maxRows: " + dataIn.readShort());
                        break;
                    }
                    case 72: {
                        this.println("Flush");
                        break;
                    }
                    case 70: {
                        this.println("FunctionCall");
                        this.println(" objectId:" + dataIn.readInt());
                        int columns = dataIn.readShort();
                        for (int i = 0; i < columns; ++i) {
                            this.println(" formatCode[" + i + "]: " + dataIn.readShort());
                        }
                        int count = dataIn.readShort();
                        for (int i = 0; i < count; ++i) {
                            int l = dataIn.readInt();
                            this.println(" len[" + i + "]: " + l);
                            if (l < 0) continue;
                            for (int j = 0; j < l; ++j) {
                                dataIn.readByte();
                            }
                        }
                        this.println(" resultFormat: " + dataIn.readShort());
                        break;
                    }
                    case 80: {
                        this.println("Parse");
                        this.println(" name:" + this.readStringNull(dataIn));
                        this.println(" query:" + this.readStringNull(dataIn));
                        int count = dataIn.readShort();
                        for (int i = 0; i < count; ++i) {
                            this.println(" [" + i + "]: " + dataIn.readInt());
                        }
                        break;
                    }
                    case 112: {
                        this.println("PasswordMessage");
                        this.println(" password: " + this.readStringNull(dataIn));
                        break;
                    }
                    case 81: {
                        this.println("Query");
                        this.println(" sql : " + this.readStringNull(dataIn));
                        break;
                    }
                    case 83: {
                        this.println("Sync");
                        break;
                    }
                    case 88: {
                        this.println("Terminate");
                        break;
                    }
                    default: {
                        this.println("############## UNSUPPORTED: " + (char)x);
                    }
                }
            }
            dataOut.flush();
            byte[] buffer = buff.toByteArray();
            PgTcpRedirect.this.printData(buffer, buffer.length);
            try {
                outStream.write(buffer, 0, buffer.length);
                outStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        private boolean processServer(InputStream inStream, OutputStream outStream) throws IOException {
            DataInputStream dataIn = new DataInputStream(inStream);
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(buff);
            int x = dataIn.read();
            if (x < 0) {
                this.println("end");
                return false;
            }
            dataOut.write(x);
            int len = dataIn.readInt();
            dataOut.writeInt(len);
            byte[] data = new byte[len -= 4];
            dataIn.readFully(data, 0, len);
            dataOut.write(data);
            dataIn = new DataInputStream(new ByteArrayInputStream(data, 0, len));
            switch (x) {
                case 82: {
                    this.println("Authentication");
                    int value = dataIn.readInt();
                    if (value == 0) {
                        this.println(" Ok");
                        break;
                    }
                    if (value == 2) {
                        this.println(" KerberosV5");
                        break;
                    }
                    if (value == 3) {
                        this.println(" CleartextPassword");
                        break;
                    }
                    if (value == 4) {
                        this.println(" CryptPassword");
                        byte b1 = dataIn.readByte();
                        byte b2 = dataIn.readByte();
                        this.println(" salt1=" + b1 + " salt2=" + b2);
                        break;
                    }
                    if (value == 5) {
                        this.println(" MD5Password");
                        byte b1 = dataIn.readByte();
                        byte b2 = dataIn.readByte();
                        byte b3 = dataIn.readByte();
                        byte b4 = dataIn.readByte();
                        this.println(" salt1=" + b1 + " salt2=" + b2 + " 3=" + b3 + " 4=" + b4);
                        break;
                    }
                    if (value != 6) break;
                    this.println(" SCMCredential");
                    break;
                }
                case 75: {
                    this.println("BackendKeyData");
                    this.println(" process ID " + dataIn.readInt());
                    this.println(" key " + dataIn.readInt());
                    break;
                }
                case 50: {
                    this.println("BindComplete");
                    break;
                }
                case 51: {
                    this.println("CloseComplete");
                    break;
                }
                case 67: {
                    this.println("CommandComplete");
                    this.println(" command tag: " + this.readStringNull(dataIn));
                    break;
                }
                case 100: {
                    this.println("CopyData");
                    break;
                }
                case 99: {
                    this.println("CopyDone");
                    break;
                }
                case 71: {
                    this.println("CopyInResponse");
                    this.println(" format: " + dataIn.readByte());
                    int columns = dataIn.readShort();
                    for (int i = 0; i < columns; ++i) {
                        this.println(" formatCode[" + i + "]: " + dataIn.readShort());
                    }
                    break;
                }
                case 72: {
                    this.println("CopyOutResponse");
                    this.println(" format: " + dataIn.readByte());
                    int columns = dataIn.readShort();
                    for (int i = 0; i < columns; ++i) {
                        this.println(" formatCode[" + i + "]: " + dataIn.readShort());
                    }
                    break;
                }
                case 68: {
                    this.println("DataRow");
                    int columns = dataIn.readShort();
                    this.println(" columns : " + columns);
                    for (int i = 0; i < columns; ++i) {
                        int l = dataIn.readInt();
                        if (l <= 0) continue;
                        for (int j = 0; j < l; ++j) {
                            dataIn.readByte();
                        }
                    }
                    break;
                }
                case 73: {
                    this.println("EmptyQueryResponse");
                    break;
                }
                case 69: {
                    byte fieldType;
                    this.println("ErrorResponse");
                    while ((fieldType = dataIn.readByte()) != 0) {
                        String msg = this.readStringNull(dataIn);
                        this.println(" fieldType: " + fieldType + " msg: " + msg);
                    }
                    break;
                }
                case 86: {
                    this.println("FunctionCallResponse");
                    int resultLen = dataIn.readInt();
                    this.println(" len: " + resultLen);
                    break;
                }
                case 110: {
                    this.println("NoData");
                    break;
                }
                case 78: {
                    byte fieldType;
                    this.println("NoticeResponse");
                    while ((fieldType = dataIn.readByte()) != 0) {
                        String msg = this.readStringNull(dataIn);
                        this.println(" fieldType: " + fieldType + " msg: " + msg);
                    }
                    break;
                }
                case 65: {
                    this.println("NotificationResponse");
                    this.println(" processID: " + dataIn.readInt());
                    this.println(" condition: " + this.readStringNull(dataIn));
                    this.println(" information: " + this.readStringNull(dataIn));
                    break;
                }
                case 116: {
                    this.println("ParameterDescription");
                    this.println(" processID: " + dataIn.readInt());
                    int count = dataIn.readShort();
                    for (int i = 0; i < count; ++i) {
                        this.println(" [" + i + "] objectId: " + dataIn.readInt());
                    }
                    break;
                }
                case 83: {
                    this.println("ParameterStatus");
                    this.println(" parameter " + this.readStringNull(dataIn) + " = " + this.readStringNull(dataIn));
                    break;
                }
                case 49: {
                    this.println("ParseComplete");
                    break;
                }
                case 115: {
                    this.println("ParseComplete");
                    break;
                }
                case 90: {
                    this.println("ReadyForQuery");
                    this.println(" status (I:idle, T:transaction, E:failed): " + (char)dataIn.readByte());
                    break;
                }
                case 84: {
                    this.println("RowDescription");
                    int columns = dataIn.readShort();
                    this.println(" columns : " + columns);
                    for (int i = 0; i < columns; ++i) {
                        this.println(" [" + i + "]");
                        this.println("  name:" + this.readStringNull(dataIn));
                        this.println("  tableId:" + dataIn.readInt());
                        this.println("  columnId:" + dataIn.readShort());
                        this.println("  dataTypeId:" + dataIn.readInt());
                        this.println("  dataTypeSize (pg_type.typlen):" + dataIn.readShort());
                        this.println("  modifier (pg_attribute.atttypmod):" + dataIn.readInt());
                        this.println("  format code:" + dataIn.readShort());
                    }
                    break;
                }
                default: {
                    this.println("############## UNSUPPORTED: " + (char)x);
                }
            }
            dataOut.flush();
            byte[] buffer = buff.toByteArray();
            PgTcpRedirect.this.printData(buffer, buffer.length);
            try {
                outStream.write(buffer, 0, buffer.length);
                outStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        public void run() {
            try {
                boolean more;
                OutputStream out = this.write.getOutputStream();
                InputStream in = this.read.getInputStream();
                do {
                    if (!this.client) continue;
                } while (more = this.client ? this.processClient(in, out) : this.processServer(in, out));
                try {
                    this.read.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    this.write.close();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

