/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;

public class DropSchema
extends DefineCommand {
    private String schemaName;
    private boolean ifExists;

    public DropSchema(Session session) {
        super(session);
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        Schema schema = db.findSchema(this.schemaName);
        if (schema == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90079, this.schemaName);
            }
        } else {
            if (!schema.canDrop()) {
                throw Message.getSQLException(90090, this.schemaName);
            }
            db.removeDatabaseObject(this.session, schema);
        }
        return 0;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }
}

