/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.FunctionCall;
import org.h2.index.FunctionIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class FunctionTable
extends Table {
    private final FunctionCall function;

    public FunctionTable(Schema schema, Session session, FunctionCall function) throws SQLException {
        super(schema, 0, function.getName(), false);
        this.function = function;
        function.optimize(session);
        int type = function.getType();
        if (type != 18) {
            throw Message.getSQLException(90000, function.getName());
        }
        int params = function.getParameterCount();
        Expression[] columnListArgs = new Expression[params];
        Expression[] args = function.getArgs();
        for (int i = 0; i < params; ++i) {
            args[i] = args[i].optimize(session);
            columnListArgs[i] = args[i];
        }
        ValueResultSet template = function.getValueForColumnList(session, columnListArgs);
        if (template == null) {
            throw Message.getSQLException(90000, function.getName());
        }
        ResultSet rs = template.getResultSet();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        Column[] cols = new Column[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            cols[i] = new Column(meta.getColumnName(i + 1), DataType.convertSQLTypeToValueType(meta.getColumnType(i + 1)), meta.getPrecision(i + 1), meta.getScale(i + 1), meta.getColumnDisplaySize(i + 1));
        }
        this.setColumns(cols);
    }

    public void lock(Session session, boolean exclusive, boolean force) throws SQLException {
    }

    public void close(Session session) throws SQLException {
    }

    public void unlock(Session s) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, int headPos, String comment) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean canDrop() {
        throw Message.getInternalError();
    }

    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public String getTableType() {
        throw Message.getInternalError();
    }

    public Index getScanIndex(Session session) throws SQLException {
        return new FunctionIndex(this, IndexColumn.wrap(this.columns), this.function);
    }

    public ObjectArray getIndexes() {
        return null;
    }

    public boolean canGetRowCount() {
        return false;
    }

    public long getRowCount(Session session) throws SQLException {
        throw Message.getInternalError();
    }

    public String getCreateSQL() {
        return null;
    }

    public String getDropSQL() {
        return null;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public LocalResult getResult(Session session) throws SQLException {
        this.function.optimize(session);
        Value v = this.function.getValue(session);
        if (v == ValueNull.INSTANCE) {
            return new LocalResult(0);
        }
        ValueResultSet value = (ValueResultSet)v;
        ResultSet rs = value.getResultSet();
        return LocalResult.read(session, rs, 0);
    }

    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    public Index getUniqueIndex() {
        return null;
    }

    public String getSQL() {
        return this.function.getSQL();
    }
}

