/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.StringUtils;

public class JdbcSavepoint
extends TraceObject
implements Savepoint {
    static final String SYSTEM_SAVEPOINT_PREFIX = "SYSTEM_SAVEPOINT_";
    private int savepointId;
    private String name;
    private JdbcConnection conn;

    JdbcSavepoint(JdbcConnection conn, int savepointId, String name, Trace trace, int id) {
        this.setTrace(trace, 6, id);
        this.conn = conn;
        this.savepointId = savepointId;
        this.name = name;
    }

    void release() {
        this.conn = null;
    }

    static String getName(String name, int id) {
        if (name != null) {
            return StringUtils.quoteJavaString(name);
        }
        return SYSTEM_SAVEPOINT_PREFIX + id;
    }

    void rollback() throws SQLException {
        this.checkValid();
        this.conn.prepareCommand("ROLLBACK TO SAVEPOINT " + JdbcSavepoint.getName(this.name, this.savepointId)).executeUpdate();
    }

    private void checkValid() throws SQLException {
        if (this.conn == null) {
            throw Message.getSQLException(90063, JdbcSavepoint.getName(this.name, this.savepointId));
        }
    }

    public int getSavepointId() throws SQLException {
        try {
            this.debugCodeCall("getSavepointId");
            this.checkValid();
            if (this.name != null) {
                throw Message.getSQLException(90065);
            }
            return this.savepointId;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getSavepointName() throws SQLException {
        try {
            this.debugCodeCall("getSavepointName");
            this.checkValid();
            if (this.name == null) {
                throw Message.getSQLException(90064);
            }
            return this.name;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": id=" + this.savepointId + " name=" + this.name;
    }
}

