/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.command.CommandRemote;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Constants;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.FileUtils;
import org.h2.util.NetUtils;
import org.h2.util.ObjectArray;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class SessionRemote
implements SessionInterface,
DataHandler {
    public static final int SESSION_PREPARE = 0;
    public static final int SESSION_CLOSE = 1;
    public static final int COMMAND_EXECUTE_QUERY = 2;
    public static final int COMMAND_EXECUTE_UPDATE = 3;
    public static final int COMMAND_CLOSE = 4;
    public static final int RESULT_FETCH_ROW = 5;
    public static final int RESULT_RESET = 6;
    public static final int RESULT_CLOSE = 7;
    public static final int COMMAND_COMMIT = 8;
    public static final int CHANGE_ID = 9;
    public static final int COMMAND_GET_META_DATA = 10;
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLOSED = 2;
    private TraceSystem traceSystem;
    private Trace trace;
    private ObjectArray transferList;
    private int nextId;
    private boolean autoCommit = true;
    private CommandInterface switchOffAutoCommit;
    private ConnectionInfo connectionInfo;
    private int objectId;
    private String databaseName;
    private String cipher;
    private byte[] fileEncryptionKey;
    private Object lobSyncObject = new Object();

    private Transfer initTransfer(ConnectionInfo ci, String db, String server) throws IOException, SQLException {
        Socket socket = NetUtils.createSocket(server, 9092, ci.isSSL());
        Transfer trans = new Transfer(this);
        trans.setSocket(socket);
        trans.init();
        trans.writeInt(4);
        trans.writeString(db);
        trans.writeString(ci.getOriginalURL());
        trans.writeString(ci.getUserName());
        trans.writeBytes(ci.getUserPasswordHash());
        trans.writeBytes(ci.getFilePasswordHash());
        String[] keys = ci.getKeys();
        trans.writeInt(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            trans.writeString(key).writeString(ci.getProperty(key));
        }
        try {
            this.done(trans);
        }
        catch (SQLException e) {
            trans.close();
            throw e;
        }
        this.autoCommit = true;
        return trans;
    }

    private void switchOffAutoCommitIfCluster() throws SQLException {
        if (this.autoCommit && this.transferList.size() > 1) {
            if (this.switchOffAutoCommit == null) {
                this.switchOffAutoCommit = this.prepareCommand("SET AUTOCOMMIT FALSE");
            }
            this.switchOffAutoCommit.executeUpdate();
            this.autoCommit = true;
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void autoCommitIfCluster() throws SQLException {
        if (this.autoCommit && this.transferList != null && this.transferList.size() > 1) {
            for (int i = 0; i < this.transferList.size(); ++i) {
                Transfer transfer = (Transfer)this.transferList.get(i);
                try {
                    this.traceOperation("COMMAND_COMMIT", 0);
                    transfer.writeInt(8);
                    this.done(transfer);
                    continue;
                }
                catch (IOException e) {
                    this.removeServer(i--);
                }
            }
        }
    }

    private String getTraceFilePrefix(String dbName) throws SQLException {
        String dir = SysProperties.CLIENT_TRACE_DIRECTORY;
        StringBuffer buff = new StringBuffer();
        buff.append(dir);
        for (int i = 0; i < dbName.length(); ++i) {
            char ch = dbName.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                buff.append(ch);
                continue;
            }
            buff.append('_');
        }
        return buff.toString();
    }

    public SessionRemote() {
    }

    public int getPowerOffCount() {
        return 0;
    }

    public void setPowerOffCount(int count) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public SessionInterface createSession(ConnectionInfo ci) throws SQLException {
        return new SessionRemote(ci);
    }

    private SessionRemote(ConnectionInfo ci) throws SQLException {
        this.connectionInfo = ci;
        this.connect();
    }

    private void connect() throws SQLException {
        int idx;
        ConnectionInfo ci = this.connectionInfo;
        String name = ci.getName();
        if (name.startsWith("//")) {
            name = name.substring("//".length());
        }
        if ((idx = name.indexOf(47)) < 0) {
            throw ci.getFormatException();
        }
        this.databaseName = name.substring(idx + 1);
        String server = name.substring(0, idx);
        this.traceSystem = new TraceSystem(null, false);
        try {
            String traceLevelSystemOut;
            String traceLevelFile = ci.getProperty(10, null);
            if (traceLevelFile != null) {
                int level = Integer.parseInt(traceLevelFile);
                String prefix = this.getTraceFilePrefix(this.databaseName);
                String file = FileUtils.createTempFile(prefix, ".trace.db", false, false);
                this.traceSystem.setFileName(file);
                this.traceSystem.setLevelFile(level);
            }
            if ((traceLevelSystemOut = ci.getProperty(9, null)) != null) {
                int level = Integer.parseInt(traceLevelSystemOut);
                this.traceSystem.setLevelSystemOut(level);
            }
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
        this.trace = this.traceSystem.getTrace("jdbc");
        this.transferList = new ObjectArray();
        String serverlist = null;
        if (server.indexOf(44) >= 0) {
            serverlist = StringUtils.quoteStringSQL(server);
            ci.setProperty("CLUSTER", serverlist);
        }
        this.cipher = ci.getProperty("CIPHER");
        if (this.cipher != null) {
            this.fileEncryptionKey = RandomUtils.getSecureBytes(32);
        }
        String[] servers = StringUtils.arraySplit(server, ',', true);
        int len = servers.length;
        this.transferList = new ObjectArray();
        boolean switchOffCluster = false;
        try {
            for (int i = 0; i < len; ++i) {
                try {
                    Transfer trans = this.initTransfer(ci, this.databaseName, servers[i]);
                    this.transferList.add(trans);
                    continue;
                }
                catch (IOException e) {
                    switchOffCluster = true;
                }
            }
            this.checkClosed();
            if (switchOffCluster) {
                this.switchOffCluster();
            }
            this.switchOffAutoCommitIfCluster();
        }
        catch (SQLException e) {
            this.traceSystem.close();
            throw e;
        }
    }

    private void switchOffCluster() throws SQLException {
        CommandInterface ci = this.prepareCommand("SET CLUSTER ''");
        ci.executeUpdate();
    }

    public void removeServer(int i) throws SQLException {
        this.transferList.remove(i);
        this.checkClosed();
        this.switchOffCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandInterface prepareCommand(String sql) throws SQLException {
        SessionRemote sessionRemote = this;
        synchronized (sessionRemote) {
            this.checkClosed();
            return new CommandRemote(this, this.transferList, sql);
        }
    }

    public void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw Message.getSQLException(90067);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.transferList != null) {
            SessionRemote sessionRemote = this;
            synchronized (sessionRemote) {
                for (int i = 0; i < this.transferList.size(); ++i) {
                    Transfer transfer = (Transfer)this.transferList.get(i);
                    try {
                        this.traceOperation("SESSION_CLOSE", 0);
                        transfer.writeInt(1);
                        this.done(transfer);
                        transfer.close();
                        continue;
                    }
                    catch (Exception e) {
                        this.trace.error("close", e);
                    }
                }
            }
            this.transferList = null;
        }
        this.traceSystem.close();
    }

    public Trace getTrace() {
        return this.traceSystem.getTrace("jdbc");
    }

    public int getNextId() {
        return this.nextId++;
    }

    public int getCurrentId() {
        return this.nextId;
    }

    public void done(Transfer transfer) throws SQLException, IOException {
        transfer.flush();
        int status = transfer.readInt();
        if (status == 0) {
            String sqlstate = transfer.readString();
            String message = transfer.readString();
            String sql = transfer.readString();
            int errorCode = transfer.readInt();
            String trace = transfer.readString();
            throw new JdbcSQLException(message, sql, sqlstate, errorCode, null, trace);
        }
        if (status == 2) {
            this.transferList = null;
        }
    }

    public boolean isClustered() {
        return this.transferList.size() > 1;
    }

    public boolean isClosed() {
        return this.transferList == null || this.transferList.size() == 0;
    }

    public void traceOperation(String operation, int id) {
        if (this.trace.debug()) {
            this.trace.debug(operation + " " + id);
        }
    }

    public int allocateObjectId(boolean needFresh, boolean dataFile) {
        return this.objectId++;
    }

    public void checkPowerOff() throws SQLException {
    }

    public void checkWritingAllowed() throws SQLException {
    }

    public int compareTypeSave(Value a, Value b) throws SQLException {
        throw Message.getInternalError();
    }

    public String createTempFile() throws SQLException {
        try {
            return FileUtils.createTempFile(this.databaseName, ".temp.db", true, false);
        }
        catch (IOException e) {
            throw Message.convertIOException(e, this.databaseName);
        }
    }

    public void freeUpDiskSpace() throws SQLException {
    }

    public int getChecksum(byte[] data, int start, int end) {
        return 0;
    }

    public String getDatabasePath() {
        return "";
    }

    public String getLobCompressionAlgorithm(int type) {
        return null;
    }

    public int getMaxLengthInplaceLob() {
        return 65536;
    }

    public boolean getTextStorage() {
        return false;
    }

    public void handleInvalidChecksum() throws SQLException {
        throw Message.getSQLException(90030, "wrong checksum");
    }

    public FileStore openFile(String name, String mode, boolean mustExist) throws SQLException {
        if (mustExist && !FileUtils.exists(name)) {
            throw Message.getSQLException(90030, name);
        }
        byte[] magic = Constants.MAGIC_FILE_HEADER.getBytes();
        FileStore store = this.cipher == null ? FileStore.open(this, name, mode, magic) : FileStore.open(this, name, mode, magic, this.cipher, this.fileEncryptionKey, 0);
        store.setCheckedWriting(false);
        try {
            store.init();
        }
        catch (SQLException e) {
            store.closeSilently();
            throw e;
        }
        return store;
    }

    public DataHandler getDataHandler() {
        return this;
    }

    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }
}

