/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.message.Message;
import org.h2.result.ResultDiskBuffer;
import org.h2.result.ResultInterface;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.util.ObjectArray;
import org.h2.util.ValueHashMap;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class LocalResult
implements ResultInterface {
    private int maxMemoryRows;
    private Session session;
    private int visibleColumnCount;
    private Expression[] expressions;
    private int rowId;
    private int rowCount;
    private ObjectArray rows;
    private SortOrder sort;
    private ValueHashMap distinctRows;
    private Value[] currentRow;
    private int[] displaySizes;
    private int offset;
    private int limit;
    private ResultDiskBuffer disk;
    private int diskOffset;
    private boolean isUpdateCount;
    private int updateCount;

    public static LocalResult read(Session session, ResultSet rs, int maxrows) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        ObjectArray cols = new ObjectArray();
        int[] types = new int[columnCount];
        Database db = session == null ? null : session.getDatabase();
        for (int i = 0; i < columnCount; ++i) {
            int type;
            String name = meta.getColumnLabel(i + 1);
            types[i] = type = DataType.convertSQLTypeToValueType(meta.getColumnType(i + 1));
            int precision = meta.getPrecision(i + 1);
            int scale = meta.getScale(i + 1);
            int displaySize = meta.getColumnDisplaySize(i + 1);
            Column col = new Column(name, type, precision, scale, displaySize);
            ExpressionColumn expr = new ExpressionColumn(db, null, col);
            cols.add(expr);
        }
        LocalResult result = new LocalResult(session, cols, columnCount);
        for (int i = 0; (maxrows == 0 || i < maxrows) && rs.next(); ++i) {
            Value[] list = new Value[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                list[j] = DataType.readValue(session, rs, j + 1, types[j]);
            }
            result.addRow(list);
        }
        result.done();
        return result;
    }

    public LocalResult(int updateCount) {
        this.isUpdateCount = true;
        this.updateCount = updateCount;
    }

    public LocalResult createShallowCopy(Session session) {
        if (this.disk == null && this.rows == null || this.rows.size() < this.rowCount) {
            return null;
        }
        LocalResult copy = new LocalResult(0);
        copy.maxMemoryRows = this.maxMemoryRows;
        copy.session = session;
        copy.visibleColumnCount = this.visibleColumnCount;
        copy.expressions = this.expressions;
        copy.rowId = -1;
        copy.rowCount = this.rowCount;
        copy.rows = this.rows;
        copy.sort = this.sort;
        copy.distinctRows = this.distinctRows;
        copy.currentRow = null;
        copy.displaySizes = this.displaySizes;
        copy.offset = 0;
        copy.limit = 0;
        copy.disk = this.disk;
        copy.diskOffset = this.diskOffset;
        copy.isUpdateCount = this.isUpdateCount;
        copy.updateCount = this.updateCount;
        return copy;
    }

    public boolean isUpdateCount() {
        return this.isUpdateCount;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public LocalResult(Session session, ObjectArray cols, int visibleColumnCount) {
        this.session = session;
        this.maxMemoryRows = session == null ? Integer.MAX_VALUE : session.getDatabase().getMaxMemoryRows();
        this.rows = new ObjectArray();
        this.visibleColumnCount = visibleColumnCount;
        this.rowId = -1;
        this.expressions = new Expression[cols.size()];
        cols.toArray(this.expressions);
        this.displaySizes = new int[cols.size()];
    }

    public void setSortOrder(SortOrder sort) {
        this.sort = sort;
    }

    public void setDistinct() {
        this.distinctRows = new ValueHashMap(this.session.getDatabase());
    }

    public void removeDistinct(Value[] values) throws SQLException {
        if (this.distinctRows == null) {
            throw Message.getInternalError();
        }
        ValueArray array = ValueArray.get(values);
        this.distinctRows.remove(array);
        this.rowCount = this.distinctRows.size();
    }

    public boolean containsDistinct(Value[] values) throws SQLException {
        if (this.distinctRows == null) {
            throw Message.getInternalError();
        }
        ValueArray array = ValueArray.get(values);
        return this.distinctRows.get(array) != null;
    }

    public void reset() throws SQLException {
        this.rowId = -1;
        if (this.disk != null) {
            this.disk.reset();
            if (this.diskOffset > 0) {
                for (int i = 0; i < this.diskOffset; ++i) {
                    this.disk.next();
                }
            }
        }
    }

    public Value[] currentRow() {
        return this.currentRow;
    }

    public boolean next() throws SQLException {
        if (this.rowId < this.rowCount) {
            ++this.rowId;
            if (this.rowId < this.rowCount) {
                this.currentRow = this.disk != null ? this.disk.next() : (Value[])this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    public int getRowId() {
        return this.rowId;
    }

    public void addRow(Value[] values) throws SQLException {
        if (!SysProperties.NEW_DISPLAY_SIZE) {
            for (int i = 0; i < values.length; ++i) {
                Value v = values[i];
                int size = v.getDisplaySize();
                this.displaySizes[i] = Math.max(this.displaySizes[i], size);
            }
        }
        if (this.distinctRows != null) {
            ValueArray array = ValueArray.get(values);
            this.distinctRows.put(array, values);
            this.rowCount = this.distinctRows.size();
            return;
        }
        this.rows.add(values);
        ++this.rowCount;
        if (this.rows.size() > this.maxMemoryRows && this.session.getDatabase().isPersistent()) {
            if (this.disk == null) {
                this.disk = new ResultDiskBuffer(this.session, this.sort, values.length);
            }
            this.addRowsToDisk();
        }
    }

    private void addRowsToDisk() throws SQLException {
        this.disk.addRows(this.rows);
        this.rows.clear();
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void done() throws SQLException {
        if (this.distinctRows != null) {
            this.rows = this.distinctRows.values();
            this.distinctRows = null;
        }
        if (this.disk != null) {
            this.addRowsToDisk();
            this.disk.done();
        } else if (this.sort != null) {
            this.sort.sort(this.rows);
        }
        this.applyOffset();
        this.applyLimit();
        this.reset();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    private void applyLimit() {
        if (this.limit <= 0) {
            return;
        }
        if (this.disk == null) {
            if (this.rows.size() > this.limit) {
                this.rows.removeRange(this.limit, this.rows.size());
                this.rowCount = this.limit;
            }
        } else if (this.limit < this.rowCount) {
            this.rowCount = this.limit;
        }
    }

    public void close() {
        if (this.disk != null) {
            this.disk.close();
            this.disk = null;
        }
    }

    public String getAlias(int i) {
        return this.expressions[i].getAlias();
    }

    public String getTableName(int i) {
        return this.expressions[i].getTableName();
    }

    public String getSchemaName(int i) {
        return this.expressions[i].getSchemaName();
    }

    public int getDisplaySize(int i) {
        if (SysProperties.NEW_DISPLAY_SIZE) {
            return this.expressions[i].getDisplaySize();
        }
        return this.displaySizes[i];
    }

    public String getColumnName(int i) {
        return this.expressions[i].getColumnName();
    }

    public int getColumnType(int i) {
        return this.expressions[i].getType();
    }

    public long getColumnPrecision(int i) {
        return this.expressions[i].getPrecision();
    }

    public int getNullable(int i) {
        return this.expressions[i].getNullable();
    }

    public boolean isAutoIncrement(int i) {
        return this.expressions[i].isAutoIncrement();
    }

    public int getColumnScale(int i) {
        return this.expressions[i].getScale();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    private void applyOffset() {
        if (this.offset <= 0) {
            return;
        }
        if (this.disk == null) {
            if (this.offset >= this.rows.size()) {
                this.rows.clear();
                this.rowCount = 0;
            } else {
                int remove = Math.min(this.offset, this.rows.size());
                this.rows.removeRange(0, remove);
                this.rowCount -= remove;
            }
        } else if (this.offset >= this.rowCount) {
            this.rowCount = 0;
        } else {
            this.diskOffset = this.offset;
            this.rowCount -= this.offset;
        }
    }

    public String toString() {
        return "columns: " + this.visibleColumnCount + " rows: " + this.rowCount + " pos: " + this.rowId;
    }
}

