/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.FunctionCall;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class JavaFunction
extends Expression
implements FunctionCall {
    private FunctionAlias functionAlias;
    private Expression[] args;

    public JavaFunction(FunctionAlias functionAlias, Expression[] args) {
        this.functionAlias = functionAlias;
        this.args = args;
    }

    public Value getValue(Session session) throws SQLException {
        return this.functionAlias.getValue(session, this.args);
    }

    public int getType() {
        return this.functionAlias.getDataType();
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].mapColumns(resolver, level);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            Expression e;
            this.args[i] = e = this.args[i].optimize(session);
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null) continue;
            e.setEvaluatable(tableFilter, b);
        }
    }

    public int getScale() {
        return 0;
    }

    public long getPrecision() {
        return 0L;
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append(Parser.quoteIdentifier(this.functionAlias.getName()));
        buff.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            Expression e = this.args[i];
            buff.append(e.getSQL());
        }
        buff.append(')');
        return buff.toString();
    }

    public void updateAggregate(Session session) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null) continue;
            e.updateAggregate(session);
        }
    }

    public FunctionAlias getFunctionAlias() {
        return this.functionAlias;
    }

    public String getName() {
        return this.functionAlias.getName();
    }

    public int getParameterCount() throws SQLException {
        return this.functionAlias.getParameterCount();
    }

    public ValueResultSet getValueForColumnList(Session session, Expression[] args) throws SQLException {
        Value v = this.functionAlias.getValue(session, args, true);
        return v == ValueNull.INSTANCE ? null : (ValueResultSet)v;
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        if (visitor.type == 2) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int cost = this.functionAlias.hasConnectionParam() ? 25 : 5;
        for (int i = 0; i < this.args.length; ++i) {
            cost += this.args[i].getCost();
        }
        return cost;
    }
}

