/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class DropIndex
extends SchemaCommand {
    private String indexName;
    private boolean ifExists;

    public DropIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        Index index = this.getSchema().findIndex(this.indexName);
        if (index == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(42112, this.indexName);
            }
        } else {
            Table table = index.getTable();
            ObjectArray constraints = table.getConstraints();
            for (int i = 0; constraints != null && i < constraints.size(); ++i) {
                Constraint cons = (Constraint)constraints.get(i);
                if (!cons.usesIndex(index)) continue;
                throw Message.getSQLException(90085, this.indexName);
            }
            this.session.getUser().checkRight(index.getTable(), 15);
            index.getTable().setModified();
            db.removeSchemaObject(this.session, index);
        }
        return 0;
    }
}

