/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;

public class Csv
implements SimpleRowSource {
    private String charset = StringUtils.getDefaultCharset();
    private int bufferSize = 8192;
    private String[] columnNames;
    private char fieldSeparatorRead = (char)44;
    private char commentLineStart = (char)35;
    private String fieldSeparatorWrite = ",";
    private String rowSeparatorWrite;
    private char fieldDelimiter = (char)34;
    private char escapeCharacter = (char)34;
    private String fileName;
    private Reader reader;
    private PrintWriter writer;
    private int back;
    private boolean endOfLine;
    private boolean endOfFile;

    public static Csv getInstance() {
        return new Csv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeResultSet(ResultSet rs) throws SQLException {
        try {
            int i;
            ResultSetMetaData meta = rs.getMetaData();
            int rows = 0;
            int columnCount = meta.getColumnCount();
            String[] row = new String[columnCount];
            for (i = 0; i < columnCount; ++i) {
                row[i] = meta.getColumnLabel(i + 1);
            }
            this.writeRow(row);
            while (rs.next()) {
                for (i = 0; i < columnCount; ++i) {
                    row[i] = rs.getString(i + 1);
                }
                this.writeRow(row);
                ++rows;
            }
            int n = rows;
            return n;
        }
        finally {
            this.close();
            JdbcUtils.closeSilently(rs);
        }
    }

    public int write(Writer writer, ResultSet rs) throws SQLException, IOException {
        this.writer = new PrintWriter(writer);
        return this.writeResultSet(rs);
    }

    public int write(String fileName, ResultSet rs, String charset) throws SQLException {
        this.init(fileName, charset);
        try {
            this.initWrite();
            return this.writeResultSet(rs);
        }
        catch (IOException e) {
            throw this.convertException("IOException writing " + fileName, e);
        }
    }

    public int write(Connection conn, String fileName, String sql, String charset) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery(sql);
        int rows = this.write(fileName, rs, charset);
        stat.close();
        return rows;
    }

    public ResultSet read(String fileName, String[] colNames, String charset) throws SQLException {
        this.init(fileName, charset);
        try {
            return this.readResultSet(colNames);
        }
        catch (IOException e) {
            throw this.convertException("IOException reading " + fileName, e);
        }
    }

    public ResultSet read(Reader reader, String[] colNames) throws SQLException, IOException {
        this.init(null, null);
        this.reader = reader;
        return this.readResultSet(colNames);
    }

    private ResultSet readResultSet(String[] colNames) throws SQLException, IOException {
        this.columnNames = colNames;
        this.initRead();
        SimpleResultSet result = new SimpleResultSet(this);
        this.makeColumnNamesUnique();
        for (int i = 0; i < this.columnNames.length; ++i) {
            result.addColumn(this.columnNames[i], 12, 255, 0);
        }
        return result;
    }

    private void makeColumnNamesUnique() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            String x = this.columnNames[i];
            if (x == null || x.length() == 0) {
                x = "C" + (i + 1);
            }
            for (int j = 0; j < i; ++j) {
                String y = this.columnNames[j];
                if (!x.equals(y)) continue;
                x = x + "1";
                j = -1;
            }
            this.columnNames[i] = x;
        }
    }

    private Csv() {
    }

    private void init(String fileName, String charset) {
        this.fileName = fileName;
        if (charset != null) {
            this.charset = charset;
        }
    }

    private void initWrite() throws IOException {
        if (this.writer == null) {
            try {
                OutputStream out = new FileOutputStream(this.fileName);
                out = new BufferedOutputStream(out, this.bufferSize);
                this.writer = new PrintWriter(new OutputStreamWriter(out, this.charset));
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
    }

    private void writeRow(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            String s;
            if (i > 0 && this.fieldSeparatorWrite != null) {
                this.writer.print(this.fieldSeparatorWrite);
            }
            if ((s = values[i]) == null) continue;
            if (this.escapeCharacter != '\u0000') {
                if (this.fieldDelimiter != '\u0000') {
                    this.writer.print(this.fieldDelimiter);
                }
                this.writer.print(this.escape(s));
                if (this.fieldDelimiter == '\u0000') continue;
                this.writer.print(this.fieldDelimiter);
                continue;
            }
            this.writer.print(s);
        }
        if (this.rowSeparatorWrite != null) {
            this.writer.print(this.rowSeparatorWrite);
        }
        this.writer.println();
    }

    private String escape(String data) {
        if (data.indexOf(this.fieldDelimiter) < 0 && (this.escapeCharacter == this.fieldDelimiter || data.indexOf(this.escapeCharacter) < 0)) {
            return data;
        }
        StringBuffer buff = new StringBuffer(data.length());
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == this.fieldDelimiter || ch == this.escapeCharacter) {
                buff.append(this.escapeCharacter);
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    private void initRead() throws IOException {
        if (this.reader == null) {
            try {
                InputStream in = FileUtils.openFileInputStream(this.fileName);
                in = new BufferedInputStream(in, this.bufferSize);
                this.reader = new InputStreamReader(in, this.charset);
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
        if (this.columnNames == null) {
            this.readHeader();
        }
    }

    private void readHeader() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        while (true) {
            String v;
            if ((v = this.readValue()) == null) {
                if (this.endOfLine) {
                    if (!this.endOfFile && list.size() <= 0) continue;
                    break;
                }
                list.add("COLUMN" + list.size());
                continue;
            }
            list.add(v);
        }
        this.columnNames = new String[list.size()];
        list.toArray(this.columnNames);
    }

    private void pushBack(int ch) {
        this.back = ch;
    }

    private int readChar() throws IOException {
        int ch = this.back;
        if (ch != -1) {
            this.back = -1;
            return ch;
        }
        if (this.endOfFile) {
            return -1;
        }
        ch = this.reader.read();
        if (ch < 0) {
            this.endOfFile = true;
            this.close();
        }
        return ch;
    }

    private String readValue() throws IOException {
        String value;
        block17: {
            int ch;
            this.endOfLine = false;
            value = null;
            do {
                if ((ch = this.readChar()) >= 0 && ch != 13 && ch != 10) continue;
                this.endOfLine = true;
                break block17;
            } while (ch <= 32);
            if (ch == this.fieldSeparatorRead) break block17;
            if (ch == this.commentLineStart) {
                while ((ch = this.readChar()) >= 0 && ch != 13 && ch != 10) {
                }
                this.endOfLine = true;
            } else if (ch == this.fieldDelimiter) {
                StringBuffer buff = new StringBuffer();
                boolean containsEscape = false;
                while (true) {
                    if ((ch = this.readChar()) < 0) {
                        return buff.toString();
                    }
                    if (ch == this.fieldDelimiter) {
                        ch = this.readChar();
                        if (ch == this.fieldDelimiter) {
                            buff.append((char)ch);
                            continue;
                        }
                        this.pushBack(ch);
                        break;
                    }
                    if (ch == this.escapeCharacter) {
                        buff.append((char)ch);
                        ch = this.readChar();
                        if (ch < 0) break;
                        containsEscape = true;
                        buff.append((char)ch);
                        continue;
                    }
                    buff.append((char)ch);
                }
                value = buff.toString();
                if (containsEscape) {
                    value = this.unEscape(value);
                }
                while ((ch = this.readChar()) >= 0) {
                    if (ch == 32 || ch == 9) continue;
                    if (ch == this.fieldSeparatorRead) break;
                    if (ch == 13 || ch == 10) {
                        this.pushBack(ch);
                        this.endOfLine = true;
                    } else {
                        this.pushBack(ch);
                    }
                    break;
                }
            } else {
                StringBuffer buff = new StringBuffer();
                buff.append((char)ch);
                while ((ch = this.readChar()) != this.fieldSeparatorRead) {
                    if (ch == 13 || ch == 10) {
                        this.pushBack(ch);
                        this.endOfLine = true;
                        break;
                    }
                    if (ch < 0) break;
                    buff.append((char)ch);
                }
                value = buff.toString().trim();
            }
        }
        return value;
    }

    private String unEscape(String s) {
        int idx;
        StringBuffer buff = new StringBuffer(s.length());
        int start = 0;
        while ((idx = s.indexOf(this.escapeCharacter, start)) >= 0) {
            buff.append(s.toCharArray(), start, idx);
            start = idx + 1;
        }
        buff.append(s.substring(start));
        return buff.toString();
    }

    /*
     * Unable to fully structure code
     */
    public Object[] readRow() throws SQLException {
        if (this.reader == null) {
            return null;
        }
        row = new String[this.columnNames.length];
        try {
            i = 0;
            while (true) {
                if ((v = this.readValue()) != null) ** GOTO lbl-1000
                if (this.endOfFile && i == 0) {
                    return null;
                }
                if (this.endOfLine) {
                    if (i != 0) break;
                    --i;
                } else if (i < row.length) {
                    row[i] = v;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw this.convertException("IOException reading from " + this.fileName, e);
        }
        return row;
    }

    private SQLException convertException(String message, Exception e) {
        SQLException s = new SQLException(message, "CSV");
        s.initCause(e);
        return s;
    }

    public void close() {
        IOUtils.closeSilently(this.reader);
        this.reader = null;
        IOUtils.closeSilently(this.writer);
        this.writer = null;
    }

    public void setFieldSeparatorWrite(String fieldSeparatorWrite) {
        this.fieldSeparatorWrite = fieldSeparatorWrite;
    }

    public void setFieldSeparatorRead(char fieldSeparatorRead) {
        this.fieldSeparatorRead = fieldSeparatorRead;
    }

    public void setRowSeparatorWrite(String rowSeparatorWrite) {
        this.rowSeparatorWrite = rowSeparatorWrite;
    }

    public void reset() throws SQLException {
        throw new SQLException("Method is not supported", "CSV");
    }
}

