/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;

public class JdbcSQLException
extends SQLException {
    private static final long serialVersionUID = -8200821788226954151L;
    private final String originalMessage;
    private final String sql;
    private final Throwable cause;
    private final String trace;

    public JdbcSQLException(String message, String sql, String state, int errorCode, Throwable cause, String trace) {
        super(JdbcSQLException.buildMessage(message, sql, state), state, errorCode);
        this.originalMessage = message;
        this.sql = sql;
        this.cause = cause;
        this.trace = trace;
        this.initCause(cause);
    }

    private static String buildMessage(String message, String sql, String state) {
        if (message == null) {
            message = "";
        }
        StringBuffer buff = new StringBuffer(message);
        if (sql != null) {
            buff.append("; SQL statement: ");
            buff.append(sql);
        }
        return message + " [" + state + "-" + 59 + "]";
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.getNextException() != null) {
            this.getNextException().printStackTrace();
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (s != null) {
            super.printStackTrace(s);
            if (this.getNextException() != null) {
                this.getNextException().printStackTrace(s);
            }
        }
    }

    public void printStackTrace(PrintStream s) {
        if (s != null) {
            super.printStackTrace(s);
            if (this.getNextException() != null) {
                this.getNextException().printStackTrace(s);
            }
        }
    }

    public Throwable getOriginalCause() {
        return this.cause;
    }

    public String getSQL() {
        return this.sql;
    }

    public String toString() {
        if (this.trace == null) {
            return super.toString();
        }
        return this.trace;
    }
}

