/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionCursor;
import org.h2.index.TreeIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;

public class MultiVersionIndex
implements Index {
    private final Index base;
    private final TreeIndex delta;
    private final TableData table;
    private final Object sync;

    public MultiVersionIndex(Index base, TableData table) throws SQLException {
        this.base = base;
        this.table = table;
        IndexType deltaIndexType = IndexType.createNonUnique(false);
        this.delta = new TreeIndex(table, -1, "DELTA", base.getColumns(), deltaIndexType);
        this.sync = base.getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session, Row row) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.base.add(session, row);
            this.removeIfExists(session, row);
            if (row.getSessionId() != 0) {
                this.delta.add(session, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session session) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.base.close(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor find(Session session, SearchRow first, SearchRow last) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            Cursor baseCursor = this.base.find(session, first, last);
            Cursor deltaCursor = this.delta.find(session, first, last);
            return new MultiVersionCursor(session, this, baseCursor, deltaCursor, this.sync);
        }
    }

    public boolean canGetFirstOrLast(boolean first) {
        return false;
    }

    public SearchRow findFirstOrLast(Session session, boolean first) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public double getCost(Session session, int[] masks) throws SQLException {
        return this.base.getCost(session, masks);
    }

    public boolean needRebuild() {
        return this.base.needRebuild();
    }

    private boolean removeIfExists(Session session, Row row) throws SQLException {
        Cursor c = this.delta.find(session, row, row);
        while (c.next()) {
            Row r = c.get();
            if (r.getPos() != row.getPos()) continue;
            this.delta.remove(session, row);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session, Row row) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.base.remove(session, row);
            if (!this.removeIfExists(session, row)) {
                this.delta.add(session, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.base.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(Session session) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.delta.truncate(session);
            this.base.truncate(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(int operation, Row row) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.removeIfExists(null, row);
        }
    }

    public int compareKeys(SearchRow rowData, SearchRow compare) {
        return this.base.compareKeys(rowData, compare);
    }

    public int compareRows(SearchRow rowData, SearchRow compare) throws SQLException {
        return this.base.compareRows(rowData, compare);
    }

    public int getColumnIndex(Column col) {
        return this.base.getColumnIndex(col);
    }

    public String getColumnListSQL() {
        return this.base.getColumnListSQL();
    }

    public Column[] getColumns() {
        return this.base.getColumns();
    }

    public long getCostRangeIndex(int[] masks, long rowCount) throws SQLException {
        return this.base.getCostRangeIndex(masks, rowCount);
    }

    public String getCreateSQL() {
        return this.base.getCreateSQL();
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.base.getCreateSQLForCopy(table, quotedName);
    }

    public String getDropSQL() {
        return this.base.getDropSQL();
    }

    public SQLException getDuplicateKeyException() {
        return this.base.getDuplicateKeyException();
    }

    public IndexType getIndexType() {
        return this.base.getIndexType();
    }

    public int getLookupCost(long rowCount) {
        return this.base.getLookupCost(rowCount);
    }

    public String getPlanSQL() {
        return this.base.getPlanSQL();
    }

    public long getRowCount(Session session) {
        return this.base.getRowCount(session);
    }

    public Table getTable() {
        return this.base.getTable();
    }

    public int getType() {
        return this.base.getType();
    }

    public boolean isNull(Row newRow) {
        return this.base.isNull(newRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildrenAndResources(Session session) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.table.removeIndex(this);
            this.remove(session);
        }
    }

    public String getSQL() {
        return this.base.getSQL();
    }

    public Schema getSchema() {
        return this.base.getSchema();
    }

    public void checkRename() throws SQLException {
        this.base.checkRename();
    }

    public ObjectArray getChildren() {
        return this.base.getChildren();
    }

    public String getComment() {
        return this.base.getComment();
    }

    public Database getDatabase() {
        return this.base.getDatabase();
    }

    public int getHeadPos() {
        return this.base.getHeadPos();
    }

    public int getId() {
        return this.base.getId();
    }

    public long getModificationId() {
        return this.base.getModificationId();
    }

    public String getName() {
        return this.base.getName();
    }

    public boolean getTemporary() {
        return this.base.getTemporary();
    }

    public void rename(String newName) throws SQLException {
        this.base.rename(newName);
    }

    public void setComment(String comment) {
        this.base.setComment(comment);
    }

    public void setModified() {
        this.base.setModified();
    }

    public void setTemporary(boolean temporary) {
        this.base.setTemporary(temporary);
    }
}

