/*
 * Decompiled with CFR 0.152.
 */
package snoozesoft.systray4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import snoozesoft.systray4j.SysTrayManager;
import snoozesoft.systray4j.SysTrayMenuEvent;
import snoozesoft.systray4j.SysTrayMenuListener;

public class SysTrayMenuIcon {
    private static String extension = ".unknown";
    private String actionCommand;
    protected File iconFile;
    private Vector listeners;

    public SysTrayMenuIcon(URL icon) {
        this(icon, "");
    }

    public SysTrayMenuIcon(URL icon, String actionCommand) {
        this.iconFile = icon != null ? this.createTempFile(icon) : new File("foo", "bar");
        this.actionCommand = actionCommand;
        this.listeners = new Vector();
    }

    public static String getExtension() {
        return extension;
    }

    public SysTrayMenuIcon(String iconFileName) {
        this(iconFileName, "");
    }

    public SysTrayMenuIcon(String iconFileName, String actionCommand) {
        if (!iconFileName.endsWith(extension)) {
            iconFileName = iconFileName + extension;
        }
        this.iconFile = new File(iconFileName);
        this.actionCommand = actionCommand;
        this.listeners = new Vector();
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public String getName() {
        return this.iconFile.getName();
    }

    public void addSysTrayMenuListener(SysTrayMenuListener listener) {
        this.listeners.add(listener);
    }

    public void removeSysTrayMenuListener(SysTrayMenuListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireIconLeftClicked() {
        SysTrayMenuListener listener = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            listener = (SysTrayMenuListener)this.listeners.elementAt(i);
            listener.iconLeftClicked(new SysTrayMenuEvent(this, this.actionCommand));
        }
    }

    protected void fireIconLeftDoubleClicked() {
        SysTrayMenuListener listener = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            listener = (SysTrayMenuListener)this.listeners.elementAt(i);
            listener.iconLeftDoubleClicked(new SysTrayMenuEvent(this, this.actionCommand));
        }
    }

    private File createTempFile(URL icon) {
        File file = null;
        byte[] buffer = new byte[2048];
        try {
            InputStream in = icon.openStream();
            file = File.createTempFile("st4j_icon_", extension);
            file.deleteOnExit();
            FileOutputStream out = new FileOutputStream(file);
            int read = in.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = in.read(buffer);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    static {
        if (SysTrayManager.isWindows) {
            extension = ".ico";
        } else if (SysTrayManager.isLinux) {
            extension = ".xpm";
        }
    }
}

