/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueDate
extends Value {
    public static final int PRECISION = 8;
    private Date value;

    private ValueDate(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.get(1);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        this.value = new Date(cal.getTime().getTime());
    }

    public static Date parseDate(String s) throws SQLException {
        return (Date)DataType.parseDateTime(s, 10, 90009);
    }

    public Date getDate() {
        return (Date)this.value.clone();
    }

    public String getSQL() {
        return "DATE '" + this.getString() + "'";
    }

    public int getType() {
        return 10;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueDate v = (ValueDate)o;
        int c = this.value.compareTo(v.value);
        return c == 0 ? 0 : (c < 0 ? -1 : 1);
    }

    public String getString() {
        return this.value.toString();
    }

    public long getPrecision() {
        return 8L;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object getObject() {
        return this.getDate();
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setDate(parameterIndex, this.value);
    }

    public static ValueDate get(Date date) {
        return (ValueDate)Value.cache(new ValueDate(date));
    }

    public int getDisplaySize() {
        return "2001-01-01".length();
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueDate && this.value.equals(((ValueDate)v).value);
    }
}

