/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.util.FileUtils;

public class TempFileDeleter {
    private static ReferenceQueue queue = new ReferenceQueue();
    private static HashMap refMap = new HashMap();

    public static synchronized Reference addFile(String fileName, Object file) {
        PhantomReference<Object> ref = new PhantomReference<Object>(file, queue);
        refMap.put(ref, fileName);
        TempFileDeleter.deleteUnused();
        return ref;
    }

    public static synchronized void deleteFile(Reference ref, String fileName) {
        if (ref != null) {
            String f2 = (String)refMap.remove(ref);
            if (Constants.CHECK && f2 != null && fileName != null && !f2.equals(fileName)) {
                throw Message.getInternalError("f2:" + f2 + " f:" + fileName);
            }
        }
        if (fileName != null && FileUtils.exists(fileName)) {
            try {
                FileUtils.delete(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TempFileDeleter.deleteUnused();
    }

    public static void deleteUnused() {
        Reference ref;
        while ((ref = queue.poll()) != null) {
            TempFileDeleter.deleteFile(ref, null);
        }
    }

    public static void stopAutoDelete(Reference ref, String fileName) {
        if (ref != null) {
            String f2 = (String)refMap.remove(ref);
            if (Constants.CHECK && (f2 == null || !f2.equals(fileName))) {
                throw Message.getInternalError("f2:" + f2 + " f:" + fileName);
            }
        }
        TempFileDeleter.deleteUnused();
    }
}

