/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.h2.util.ByteUtils;

public class RandomUtils {
    private static SecureRandom secureRandom;
    private static Random random;

    public static long getSecureLong() {
        if (secureRandom == null) {
            byte[] buff = SecureRandom.getSeed(8);
            return ByteUtils.readLong(buff, 0);
        }
        return secureRandom.nextLong();
    }

    public static byte[] getSecureBytes(int len) {
        if (secureRandom == null) {
            return SecureRandom.getSeed(len);
        }
        if (len <= 0) {
            len = 1;
        }
        byte[] buff = new byte[len];
        secureRandom.nextBytes(buff);
        return buff;
    }

    public static int nextInt(int max) {
        return random.nextInt(max);
    }

    static {
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
            random = new Random(secureRandom.nextLong());
        }
        catch (NoSuchAlgorithmException e) {
            random = new Random();
        }
    }
}

