/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.message.TraceSystem;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbContextRule;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebServerSession;

public class AppSession
extends WebServerSession {
    private static final int MAX_HISTORY = 1000;
    private ArrayList commandHistory = new ArrayList();
    private Connection conn;
    private DatabaseMetaData meta;
    private DbContents contents = new DbContents();
    private DbContextRule columnRule;
    private DbContextRule newAliasRule;
    private DbContextRule tableRule;
    private DbContextRule aliasRule;
    private DbContextRule columnAliasRule;
    private Bnf bnf;
    Statement executingStatement;
    ResultSet result;

    AppSession(WebServer server) {
        super(server);
    }

    public Bnf getBnf() {
        return this.bnf;
    }

    void loadBnf() {
        try {
            Bnf newBnf = Bnf.getInstance(null);
            this.columnRule = new DbContextRule(this.contents, 0);
            this.newAliasRule = new DbContextRule(this.contents, 3);
            this.aliasRule = new DbContextRule(this.contents, 2);
            this.tableRule = new DbContextRule(this.contents, 1);
            this.columnAliasRule = new DbContextRule(this.contents, 4);
            newBnf.updateTopic("columnName", this.columnRule);
            newBnf.updateTopic("newTableAlias", this.newAliasRule);
            newBnf.updateTopic("tableAlias", this.aliasRule);
            newBnf.updateTopic("columnAlias", this.columnAliasRule);
            newBnf.updateTopic("tableName", this.tableRule);
            newBnf.linkStatements();
            this.bnf = newBnf;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String getCommand(int id) {
        return (String)this.commandHistory.get(id);
    }

    void addCommand(String sql) {
        int idx;
        if (sql == null) {
            return;
        }
        if ((sql = sql.trim()).length() == 0) {
            return;
        }
        if (this.commandHistory.size() > 1000) {
            this.commandHistory.remove(0);
        }
        if ((idx = this.commandHistory.indexOf(sql)) >= 0) {
            this.commandHistory.remove(idx);
        }
        this.commandHistory.add(sql);
    }

    ArrayList getCommands() {
        return this.commandHistory;
    }

    public HashMap getInfo() {
        HashMap m = super.getInfo();
        try {
            m.put("url", this.conn == null ? "not connected" : this.conn.getMetaData().getURL());
            m.put("user", this.conn == null ? "-" : this.conn.getMetaData().getUserName());
            m.put("lastQuery", this.commandHistory.size() == 0 ? "" : this.commandHistory.get(0));
            m.put("executing", this.executingStatement == null ? "no" : "yes");
        }
        catch (SQLException e) {
            TraceSystem.traceThrowable(e);
        }
        return m;
    }

    void setConnection(Connection conn) throws SQLException {
        this.conn = conn;
        this.meta = conn == null ? null : conn.getMetaData();
        this.contents = new DbContents();
    }

    DatabaseMetaData getMetaData() {
        return this.meta;
    }

    Connection getConnection() {
        return this.conn;
    }

    public DbContents getContents() {
        return this.contents;
    }
}

