/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.h2.server.ftp.FileObject;
import org.h2.server.ftp.FtpData;
import org.h2.server.ftp.FtpServer;
import org.h2.util.StringUtils;

public class FtpControl
extends Thread {
    private static final String SERVER_NAME = "Small FTP Server";
    private FtpServer server;
    private Socket control;
    private FtpData data;
    private PrintWriter output;
    private String userName;
    private boolean connected;
    private boolean readonly;
    private String currentDir = "/";
    private String serverIpAddress;
    private boolean stop;
    private String renameFrom;
    private boolean replied;
    private long restart;

    public FtpControl(Socket control, FtpServer server, boolean stop) {
        this.server = server;
        this.control = control;
        this.stop = stop;
    }

    public void run() {
        block7: {
            try {
                this.output = new PrintWriter(new OutputStreamWriter(this.control.getOutputStream(), "UTF8"));
                if (this.stop) {
                    this.reply(421, "Too many users");
                    break block7;
                }
                this.reply(220, SERVER_NAME);
                this.serverIpAddress = this.control.getLocalAddress().getHostAddress().replace('.', ',');
                BufferedReader input = new BufferedReader(new InputStreamReader(this.control.getInputStream()));
                while (!this.stop) {
                    String command = null;
                    try {
                        command = input.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (command == null) break;
                    this.process(command);
                }
                if (this.data != null) {
                    this.data.close();
                }
            }
            catch (Throwable t) {
                this.server.logError(t);
            }
        }
        this.server.closeConnection();
    }

    private void process(String command) throws IOException {
        int idx = command.indexOf(32);
        String param = "";
        if (idx >= 0) {
            param = command.substring(idx).trim();
            command = command.substring(0, idx);
        }
        if ((command = StringUtils.toUpperEnglish(command)).length() == 0) {
            this.reply(506, "No command");
            return;
        }
        this.server.log(">" + command);
        this.replied = false;
        if (this.connected) {
            this.processConnected(command, param);
        }
        if (!this.replied) {
            if ("USER".equals(command)) {
                this.userName = param;
                this.reply(331, "Need password");
            } else if ("QUIT".equals(command)) {
                this.reply(221, "Bye");
                this.stop = true;
            } else if ("PASS".equals(command)) {
                if (this.userName == null) {
                    this.reply(332, "Need username");
                } else if (this.server.checkUserPassword(this.userName, param)) {
                    this.reply(230, "Ok");
                    this.readonly = false;
                    this.connected = true;
                } else if (this.server.checkUserPasswordReadOnly(this.userName, param)) {
                    this.reply(230, "Ok, readonly");
                    this.readonly = true;
                    this.connected = true;
                } else {
                    this.reply(431, "Wrong user/password");
                }
            } else if ("REIN".equals(command)) {
                this.userName = null;
                this.connected = false;
                this.currentDir = "/";
                this.reply(200, "Ok");
            } else if ("HELP".equals(command)) {
                this.reply(214, SERVER_NAME);
            }
        }
        if (!this.replied) {
            this.reply(506, "Invalid command");
        }
    }

    private void processConnected(String command, String param) throws IOException {
        switch (command.charAt(0)) {
            case 'C': {
                if ("CWD".equals(command)) {
                    FileObject file = this.server.getFile(param = this.getFileName(param));
                    if (file.exists() && file.isDirectory()) {
                        if (!param.endsWith("/")) {
                            param = param + "/";
                        }
                        this.currentDir = param;
                        this.reply(250, "Ok");
                        break;
                    }
                    this.reply(550, "Failed");
                    break;
                }
                if (!"CDUP".equals(command)) break;
                if (this.currentDir.length() > 1) {
                    int idx = this.currentDir.lastIndexOf("/", this.currentDir.length() - 2);
                    this.currentDir = this.currentDir.substring(0, idx + 1);
                    this.reply(250, "Ok");
                    break;
                }
                this.reply(550, "Failed");
                break;
            }
            case 'D': {
                if (!"DELE".equals(command)) break;
                FileObject file = this.server.getFile(this.getFileName(param));
                if (!this.readonly && file.exists() && file.isFile() && file.delete()) {
                    this.reply(250, "Ok");
                    break;
                }
                this.reply(500, "Delete failed");
                break;
            }
            case 'L': {
                if (!"LIST".equals(command)) break;
                this.processList(param, true);
                break;
            }
            case 'M': {
                if ("MKD".equals(command)) {
                    param = this.getFileName(param);
                    FileObject file = this.server.getFile(param);
                    if (!this.readonly && file.mkdirs()) {
                        this.reply(257, "\"" + param + "\" directory");
                        break;
                    }
                    this.reply(500, "Failed");
                    break;
                }
                if ("MODE".equals(command)) {
                    if ("S".equals(StringUtils.toUpperEnglish(param))) {
                        this.reply(200, "Ok");
                        break;
                    }
                    this.reply(504, "Invalid");
                    break;
                }
                if (!"MDTM".equals(command)) break;
                FileObject file = this.server.getFile(this.getFileName(param));
                if (file.exists() && file.isFile()) {
                    this.reply(213, this.server.formatLastModified(file));
                    break;
                }
                this.reply(550, "Failed");
                break;
            }
            case 'N': {
                if ("NLST".equals(command)) {
                    this.processList(param, false);
                    break;
                }
                if (!"NOOP".equals(command)) break;
                this.reply(200, "Ok");
                break;
            }
            case 'P': {
                if ("PWD".equals(command)) {
                    this.reply(257, "\"" + this.currentDir + "\" directory");
                    break;
                }
                if (!"PASV".equals(command)) break;
                ServerSocket dataSocket = this.server.createDataSocket();
                this.data = new FtpData(this.server, this.control.getInetAddress(), dataSocket);
                this.data.start();
                int port = dataSocket.getLocalPort();
                this.reply(227, "Passive Mode (" + this.serverIpAddress + "," + (port >> 8) + "," + (port & 0xFF) + ")");
                break;
            }
            case 'R': {
                if ("RNFR".equals(command)) {
                    FileObject file = this.server.getFile(param = this.getFileName(param));
                    if (file.exists()) {
                        this.renameFrom = param;
                        this.reply(350, "Ok");
                        break;
                    }
                    this.reply(450, "Not found");
                    break;
                }
                if ("RNTO".equals(command)) {
                    if (this.renameFrom == null) {
                        this.reply(503, "RNFR required");
                        break;
                    }
                    FileObject fileOld = this.server.getFile(this.renameFrom);
                    FileObject fileNew = this.server.getFile(this.getFileName(param));
                    if (!this.readonly && fileOld.renameTo(fileNew)) {
                        this.reply(250, "Ok");
                        break;
                    }
                    this.reply(550, "Failed");
                    break;
                }
                if ("RETR".equals(command)) {
                    FileObject file = this.server.getFile(this.getFileName(param));
                    if (file.exists() && file.isFile()) {
                        this.reply(150, "Starting transfer");
                        try {
                            this.data.send(file, this.restart);
                            this.reply(226, "Ok");
                        }
                        catch (IOException e) {
                            this.reply(426, "Failed");
                        }
                        this.restart = 0L;
                        break;
                    }
                    this.processList(param, true);
                    break;
                }
                if ("RMD".equals(command)) {
                    FileObject file = this.server.getFile(this.getFileName(param));
                    if (!this.readonly && file.exists() && file.isDirectory() && file.delete()) {
                        this.reply(250, "Ok");
                        break;
                    }
                    this.reply(500, "Failed");
                    break;
                }
                if (!"REST".equals(command)) break;
                try {
                    this.restart = Integer.parseInt(param);
                    this.reply(350, "Ok");
                }
                catch (NumberFormatException e) {
                    this.reply(500, "Invalid");
                }
                break;
            }
            case 'S': {
                if ("SYST".equals(command)) {
                    this.reply(215, "UNIX Type: L8");
                    break;
                }
                if ("SITE".equals(command)) {
                    this.reply(500, "Not understood");
                    break;
                }
                if ("SIZE".equals(command)) {
                    FileObject file = this.server.getFile(this.getFileName(param));
                    if (file.exists() && file.isFile()) {
                        this.reply(250, String.valueOf(file.length()));
                        break;
                    }
                    this.reply(500, "Failed");
                    break;
                }
                if ("STOR".equals(command)) {
                    FileObject file = this.server.getFile(this.getFileName(param));
                    if (!this.readonly && !file.exists() || file.isFile()) {
                        this.reply(150, "Starting transfer");
                        try {
                            this.data.receive(file);
                            this.reply(226, "Ok");
                        }
                        catch (IOException e) {
                            this.reply(426, "Failed");
                        }
                        break;
                    }
                    this.reply(550, "Failed");
                    break;
                }
                if (!"STRU".equals(command)) break;
                if ("F".equals(StringUtils.toUpperEnglish(param))) {
                    this.reply(200, "Ok");
                    break;
                }
                this.reply(504, "Invalid");
                break;
            }
            case 'T': {
                if (!"TYPE".equals(command)) break;
                if ("A".equals(param = StringUtils.toUpperEnglish(param)) || "A N".equals(param)) {
                    this.reply(200, "Ok");
                    break;
                }
                if ("I".equals(param) || "L 8".equals(param)) {
                    this.reply(200, "Ok");
                    break;
                }
                this.reply(500, "Invalid");
            }
        }
    }

    private String getFileName(String file) {
        return file.startsWith("/") ? file : this.currentDir + file;
    }

    private void processList(String param, boolean directories) throws IOException {
        FileObject directory = this.server.getFile(this.getFileName(param));
        if (!directory.exists()) {
            this.reply(450, "Directory does not exist");
            return;
        }
        if (!directory.isDirectory()) {
            this.reply(450, "Not a directory");
            return;
        }
        String list = this.server.getDirectoryListing(directory, directories);
        this.reply(150, "Starting transfer");
        this.server.log(list);
        this.data.send(list.getBytes("UTF-8"));
        this.reply(226, "Done");
    }

    private void reply(int code, String message) throws IOException {
        this.server.log(code + " " + message);
        this.output.print(code + " " + message + "\r\n");
        this.output.flush();
        this.replied = true;
    }
}

