/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class OdbcTransfer {
    static final int BUFFER_SIZE = 1024;
    private DataInputStream in;
    private DataOutputStream out;

    OdbcTransfer(DataInputStream in, DataOutputStream out) {
        this.in = in;
        this.out = out;
    }

    OdbcTransfer writeBoolean(boolean x) throws IOException {
        this.writeInt(x ? 1 : 0);
        return this;
    }

    OdbcTransfer writeOk() throws IOException {
        this.writeBoolean(true);
        return this;
    }

    boolean readBoolean() throws IOException {
        return this.readInt() == 1;
    }

    OdbcTransfer writeByte(byte x) throws IOException {
        this.out.write(x);
        return this;
    }

    int readByte() throws IOException {
        return this.in.read();
    }

    OdbcTransfer writeShort(short x) throws IOException {
        return this.writeInt(x);
    }

    short readShort() throws IOException {
        return (short)this.readInt();
    }

    OdbcTransfer writeInt(int i) throws IOException {
        this.out.writeInt(i);
        return this;
    }

    int readInt() throws IOException {
        return this.in.readInt();
    }

    OdbcTransfer writeLong(long i) throws IOException {
        this.out.writeLong(i);
        return this;
    }

    long readLong() throws IOException {
        return this.in.readLong();
    }

    OdbcTransfer writeFloat(float i) throws IOException {
        this.out.writeFloat(i);
        return this;
    }

    float readFloat() throws IOException {
        return this.in.readFloat();
    }

    OdbcTransfer writeDouble(double i) throws IOException {
        this.out.writeDouble(i);
        return this;
    }

    double readDouble() throws IOException {
        return this.in.readDouble();
    }

    OdbcTransfer writeString(String s) throws IOException {
        if (s == null) {
            this.out.writeInt(-1);
        } else {
            this.out.writeInt(s.length());
            for (int i = 0; i < s.length(); ++i) {
                this.out.write(s.charAt(i));
            }
        }
        return this;
    }

    String readString() throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)this.in.readByte();
        }
        return new String(chars);
    }

    OdbcTransfer writeDate(Date x) throws IOException {
        if (x == null) {
            this.writeString(null);
        } else {
            this.writeString(x.toString());
        }
        return this;
    }

    OdbcTransfer writeTime(Time x) throws IOException {
        if (x == null) {
            this.writeString(null);
        } else {
            this.writeString(x.toString());
        }
        return this;
    }

    OdbcTransfer writeTimestamp(Timestamp x) throws IOException {
        if (x == null) {
            this.writeString(null);
        } else {
            this.writeString(x.toString());
        }
        return this;
    }

    Date readDate() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Date.valueOf(s);
    }

    Time readTime() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Time.valueOf(s);
    }

    Timestamp readTimestamp() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        return Timestamp.valueOf(s);
    }

    OdbcTransfer writeByteArray(byte[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
        }
        this.out.write(data);
        return this;
    }

    byte[] readByteArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        byte[] b = new byte[len];
        this.in.readFully(b);
        return b;
    }

    OdbcTransfer writeIntArray(int[] s) throws IOException {
        if (s == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(s.length);
            for (int i = 0; i < s.length; ++i) {
                this.writeInt(s[i]);
            }
        }
        return this;
    }

    int[] readIntArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        int[] s = new int[len];
        for (int i = 0; i < len; ++i) {
            s[i] = this.readInt();
        }
        return s;
    }

    OdbcTransfer writeStringArray(String[] s) throws IOException {
        if (s == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(s.length);
            for (int i = 0; i < s.length; ++i) {
                this.writeString(s[i]);
            }
        }
        return this;
    }

    String[] readStringArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        String[] s = new String[len];
        for (int i = 0; i < len; ++i) {
            s[i] = this.readString();
        }
        return s;
    }

    OdbcTransfer writeBuffer(byte[] buffer) throws IOException {
        this.out.write(buffer);
        return this;
    }
}

