/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.helper;

import com.gwtplatform.dispatch.annotation.helper.GenerationHelper;
import java.io.Writer;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class InterfaceGenerationHelper
extends GenerationHelper {
    public InterfaceGenerationHelper(Writer sourceWriter) {
        super(sourceWriter);
    }

    public void generateEmptyMethodBody(String methodName, String returnType) {
        this.println();
        this.print("  {0} {1}();", returnType, methodName);
    }

    public void generateGetter(String fieldName, String getterType) {
        this.println();
        this.print("  {0} get{1}();", getterType, this.firstCharToUpperCase(fieldName));
        this.println();
    }

    public void generateGetter(VariableElement fieldElement) {
        this.println();
        this.print("  {0} {1}();", fieldElement.asType().toString(), this.manufactureAccessorName(fieldElement));
        this.println();
    }

    public void generateInterfaceHeader(String inferfaceName, Set<Modifier> modifiers, String ... extendedInterfaces) {
        this.print("{0}interface {1}", this.generateModifierList(modifiers.toArray(new Modifier[0])), inferfaceName);
        if (extendedInterfaces != null && extendedInterfaces.length > 0) {
            this.printWithoutSpaces(" extends {0}", InterfaceGenerationHelper.implode(extendedInterfaces, ","));
        }
        this.printWithoutSpaces(" { ", new Object[0]);
    }

    public void generateSetter(String fieldName, String fieldType) {
        this.println();
        this.print("  void {0}({1} {2});", this.manufactureSetterName(fieldName), fieldType, fieldName);
        this.println();
    }

    public void generateSetter(VariableElement fieldElement) {
        this.generateSetter(fieldElement.getSimpleName().toString(), fieldElement.asType().toString());
    }
}

