/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.helper;

import com.gwtplatform.dispatch.annotation.helper.GenerationHelper;
import java.io.Writer;
import java.util.Collection;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;

public class ClassGenerationHelper
extends GenerationHelper {
    public ClassGenerationHelper(Writer sourceWriter) {
        super(sourceWriter);
    }

    public void generateClassHeader(String className, String extendedClassName, Set<Modifier> modifiers, String ... extraInterfaces) {
        this.println();
        this.print("{0}class {1}", this.generateModifierList(modifiers.toArray(new Modifier[0])), className);
        if (extendedClassName != null && !extendedClassName.isEmpty()) {
            String trimedExtendedClassName = extendedClassName.trim();
            this.printWithoutSpaces(" extends {0}", trimedExtendedClassName);
        }
        if (extraInterfaces != null && extraInterfaces.length > 0) {
            this.printWithoutSpaces(" implements {0}", ClassGenerationHelper.implode(extraInterfaces, ","));
        }
        this.printWithoutSpaces(" { ", new Object[0]);
    }

    public void generateConstructorUsingFields(String simpleClassName, Collection<VariableElement> fieldsToBePassedAndAssigned, Modifier ... constructorModifiers) {
        this.println();
        this.println("  {0}{1}({2}) {", this.generateModifierList(constructorModifiers), simpleClassName, this.generateFieldList(fieldsToBePassedAndAssigned, true, false));
        if (fieldsToBePassedAndAssigned != null) {
            for (VariableElement fieldToBeAssigned : fieldsToBePassedAndAssigned) {
                this.generateFieldAssignment(fieldToBeAssigned, fieldToBeAssigned.getSimpleName().toString());
            }
        }
        this.println("  }");
    }

    public void generateEmptyConstructor(String simpleClassName, Modifier modifier) {
        this.println();
        if (modifier != null) {
            this.println("  {0} {1}() {", new Object[]{modifier, simpleClassName});
        } else {
            this.println("  {0}() {", simpleClassName);
        }
        this.println("    // Possibly for serialization.");
        this.println("  }");
    }

    public void generateEquals(String simpleClassName, Collection<VariableElement> fieldElements) {
        this.println();
        this.println("  @Override");
        this.println("  public boolean equals(Object obj) {");
        if (fieldElements.size() > 0) {
            this.println("    if (this == obj)");
            this.println("        return true;");
            this.println("    if (obj == null)");
            this.println("        return false;");
            this.println("    if (getClass() != obj.getClass())");
            this.println("        return false;");
            this.println("    {0} other = ({0}) obj;", simpleClassName);
            for (VariableElement fieldElement : fieldElements) {
                TypeMirror type = fieldElement.asType();
                String fieldName = fieldElement.getSimpleName().toString();
                if (this.isStatic(fieldElement)) continue;
                if (this.isPrimitive(type)) {
                    this.println("    if ({0} != other.{0})", fieldName);
                    this.println("        return false;");
                    continue;
                }
                this.println("    if ({0} == null) {", fieldName);
                this.println("      if (other.{0} != null)", fieldName);
                this.println("        return false;");
                this.println("    } else if (!{0}.equals(other.{0}))", fieldName);
                this.println("      return false;");
            }
            this.println("    return true;");
        } else {
            this.println("    return super.equals(obj);");
        }
        this.println("  }");
    }

    public void generateFieldAccessors(Collection<VariableElement> fieldElements) {
        for (VariableElement fieldElement : fieldElements) {
            this.println();
            this.println("  {0} {1} {2}(){", new Object[]{Modifier.PUBLIC, fieldElement.asType().toString(), this.manufactureAccessorName(fieldElement)});
            this.println("    return {0};", fieldElement.getSimpleName());
            this.println("  }");
        }
    }

    public void generateFieldAssignment(VariableElement fieldElement, Object value) {
        this.println("    this.{0} = {1};", fieldElement.getSimpleName(), String.valueOf(value));
    }

    public void generateHashCode(Collection<VariableElement> fieldElements) {
        this.println();
        this.println("  @Override");
        this.println("  public int hashCode() {");
        if (fieldElements.size() > 0) {
            this.println("    int hashCode = 23;");
            for (VariableElement fieldElement : fieldElements) {
                TypeMirror type = fieldElement.asType();
                String fieldName = fieldElement.getSimpleName().toString();
                if (this.isStatic(fieldElement)) continue;
                if (type instanceof ArrayType) {
                    this.println("    hashCode = (hashCode * 37) + java.util.Arrays.deepHashCode({0});", fieldName);
                    continue;
                }
                if (this.isPrimitive(type)) {
                    this.println("    hashCode = (hashCode * 37) + new {0}({1}).hashCode();", this.determineWrapperClass(type), fieldName);
                    continue;
                }
                this.println("    hashCode = (hashCode * 37) + ({0} == null ? 1 : {0}.hashCode());", fieldName);
            }
            this.println("    return hashCode;");
        } else {
            this.println("    return super.hashCode();");
        }
        this.println("  }");
    }

    public void generateToString(String simpleClassName, Collection<VariableElement> fieldElements) {
        this.println();
        this.println("  @Override");
        this.println("  public String toString() {");
        this.println("    return \"" + simpleClassName + "[\"");
        int i = 0;
        for (VariableElement fieldElement : fieldElements) {
            if (i++ > 0) {
                this.println("                 + \",\"");
            }
            this.println("                 + " + fieldElement.getSimpleName());
        }
        this.println("    + \"]\";");
        this.println("  }");
    }
}

